/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scan;

import java.text.DecimalFormat;
import java.util.List;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scan.props.InjectionInfo;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.datatypes.scan.props.Polarity;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scan.props.ScanType;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.spectrum.ISpectrum;

public abstract class AbstractScan
implements IScan {
    public static final DecimalFormat FMT_DOUBLE_2_DIGITS_AFTER_DOT = new DecimalFormat("0.00");
    protected int num;
    protected IScanCollection scans;
    protected PrecursorInfo precursor;
    protected InjectionInfo injectionInfo;
    protected List<Integer> childScans;
    protected Double rt;
    protected Integer msLevel;
    protected Polarity polarity;
    protected Instrument instrument;
    protected Boolean isCentroided;
    protected ScanType scanType;
    protected Double basePeakMz;
    protected Double basePeakIntensity;
    protected Double tic;
    protected Double scanMzWindowLower;
    protected Double scanMzWindowUpper;
    protected StorageStrategy storageStrategy;

    protected AbstractScan(int num) {
        this.num = num;
        this.precursor = null;
        this.childScans = null;
        this.rt = null;
        this.msLevel = null;
        this.polarity = null;
        this.instrument = null;
        this.isCentroided = null;
        this.scanType = null;
        this.basePeakMz = null;
        this.basePeakIntensity = null;
        this.tic = null;
        this.scanMzWindowLower = null;
        this.scanMzWindowUpper = null;
        this.storageStrategy = StorageStrategy.STRONG;
        this.scans = null;
    }

    @Override
    public InjectionInfo getInjectionInfo() {
        return this.injectionInfo;
    }

    @Override
    public void setInjectionInfo(InjectionInfo injectionInfo) {
        this.injectionInfo = injectionInfo;
    }

    @Override
    public int getNum() {
        return this.num;
    }

    @Override
    public PrecursorInfo getPrecursor() {
        return this.precursor;
    }

    @Override
    public void setPrecursor(PrecursorInfo precursor) {
        this.precursor = precursor;
    }

    @Override
    public ScanType getScanType() {
        return this.scanType;
    }

    @Override
    public void setScanType(ScanType scanType) {
        this.scanType = scanType;
    }

    @Override
    public List<Integer> getChildScans() {
        return this.childScans;
    }

    @Override
    public void setChildScans(List<Integer> childScans) {
        this.childScans = childScans;
    }

    @Override
    public Double getRt() {
        return this.rt;
    }

    @Override
    public void setRt(Double rt) {
        this.rt = rt;
    }

    @Override
    public Integer getMsLevel() {
        return this.msLevel;
    }

    @Override
    public void setMsLevel(Integer msLevel) {
        this.msLevel = msLevel;
    }

    @Override
    public Polarity getPolarity() {
        return this.polarity;
    }

    @Override
    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
    }

    @Override
    public Instrument getInstrument() {
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public Boolean getCentroided() {
        return this.isCentroided;
    }

    @Override
    public void setCentroided(Boolean centroided) {
        this.isCentroided = centroided;
    }

    @Override
    public Double getBasePeakMz() {
        return this.basePeakMz;
    }

    @Override
    public void setBasePeakMz(Double basePeakMz) {
        this.basePeakMz = basePeakMz;
    }

    @Override
    public Double getBasePeakIntensity() {
        return this.basePeakIntensity;
    }

    @Override
    public void setBasePeakIntensity(Double basePeakIntensity) {
        this.basePeakIntensity = basePeakIntensity;
    }

    @Override
    public Double getTic() {
        return this.tic;
    }

    @Override
    public void setTic(Double tic) {
        this.tic = tic;
    }

    @Override
    public Double getScanMzWindowLower() {
        return this.scanMzWindowLower;
    }

    @Override
    public void setScanMzWindowLower(Double scanMzWindowLower) {
        this.scanMzWindowLower = scanMzWindowLower;
    }

    @Override
    public Double getScanMzWindowUpper() {
        return this.scanMzWindowUpper;
    }

    @Override
    public void setScanMzWindowUpper(Double scanMzWindowUpper) {
        this.scanMzWindowUpper = scanMzWindowUpper;
    }

    @Override
    public Boolean isCentroided() {
        return this.isCentroided;
    }

    @Override
    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    @Override
    public void setStorageStrategy(StorageStrategy storageStrategy) {
        if (storageStrategy == null) {
            throw new NullPointerException("StorageStrategy can't be null");
        }
        if (this.storageStrategy != storageStrategy) {
            this.storageStrategy = storageStrategy;
        }
        this.setSpectrumImpl(this.getSpectrum());
    }

    @Override
    public IScanCollection getScanCollection() {
        return this.scans;
    }

    @Override
    public void setScanCollection(IScanCollection scans) {
        this.scans = scans;
    }

    @Override
    public final void setSpectrum(ISpectrum spectrum, boolean forceOverrideMinMaxSumVals) {
        if (spectrum == null && forceOverrideMinMaxSumVals) {
            throw new IllegalArgumentException(String.format("If you force override min/max values, the spectrumRef must be non-null. Scan MS%d #%d @ %.3f", this.getMsLevel(), this.getNum(), this.getRt()));
        }
        if (forceOverrideMinMaxSumVals) {
            this.basePeakIntensity = spectrum.getMaxInt();
            this.basePeakMz = spectrum.getMaxIntMz();
            if (this.scanMzWindowLower == null) {
                this.scanMzWindowLower = spectrum.getMinMZ();
            }
            if (this.scanMzWindowUpper == null) {
                this.scanMzWindowUpper = spectrum.getMaxMZ();
            }
            this.tic = spectrum.getSumInt();
        }
        this.setSpectrumImpl(spectrum);
    }

    public void setSpectrum(ISpectrum spectrum) {
        this.setSpectrum(spectrum, true);
    }

    protected abstract void setSpectrumImpl(ISpectrum var1);

    public String toString() {
        return new StringBuilder(64).append("Scan #").append(this.getNum()).append(":MS").append(this.getMsLevel()).append("[").append(this.getPolarity().toString()).append("]").append("@").append(FMT_DOUBLE_2_DIGITS_AFTER_DOT.format(this.getRt())).append("min").toString();
    }
}

