/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.internal.stream;

import javolution.text.CharArray;
import javolution.util.FastTable;
import javolution.xml.internal.stream.NamespacesImpl;
import javolution.xml.sax.Attributes;

public final class AttributesImpl
implements Attributes {
    private static final CharArray CDATA = new CharArray("CDATA");
    private static final CharArray EMPTY = new CharArray();
    private final FastTable<AttributeImpl> attributes = new FastTable();
    private int length;
    private final NamespacesImpl namespaces;

    public AttributesImpl(NamespacesImpl namespaces) {
        this.namespaces = namespaces;
    }

    public void addAttribute(CharArray localName, CharArray prefix, CharArray qName, CharArray value) {
        AttributeImpl attribute;
        if (this.length >= this.attributes.size()) {
            attribute = new AttributeImpl();
            this.attributes.add(attribute);
        } else {
            attribute = this.attributes.get(this.length);
        }
        attribute.localName = localName;
        attribute.prefix = prefix;
        attribute.qName = qName;
        attribute.value = value;
        ++this.length;
    }

    @Override
    public int getIndex(CharSequence qName) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.attributes.get((int)i).qName.contentEquals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(CharSequence uri, CharSequence localName) {
        for (int i = 0; i < this.length; ++i) {
            AttributeImpl attribute = this.attributes.get(i);
            if (!attribute.localName.contentEquals(localName) || !(attribute.prefix == null ? uri.length() == 0 : this.namespaces.getNamespaceURI(attribute.prefix).equals(uri))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public CharArray getLocalName(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        return this.attributes.get((int)index).localName;
    }

    public CharArray getPrefix(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        return this.attributes.get((int)index).prefix;
    }

    @Override
    public CharArray getQName(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        return this.attributes.get((int)index).qName;
    }

    @Override
    public CharArray getType(CharSequence qName) {
        return this.getIndex(qName) >= 0 ? CDATA : null;
    }

    @Override
    public CharArray getType(CharSequence uri, CharSequence localName) {
        return this.getIndex(uri, localName) >= 0 ? CDATA : null;
    }

    @Override
    public CharArray getType(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        return CDATA;
    }

    @Override
    public CharArray getURI(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        CharArray prefix = this.attributes.get((int)index).prefix;
        return prefix == null ? EMPTY : this.namespaces.getNamespaceURI(prefix);
    }

    @Override
    public CharArray getValue(CharSequence qName) {
        int index = this.getIndex(qName);
        return index >= 0 ? this.attributes.get((int)index).value : null;
    }

    @Override
    public CharArray getValue(CharSequence uri, CharSequence localName) {
        int index = this.getIndex(uri, localName);
        return index >= 0 ? this.attributes.get((int)index).value : null;
    }

    @Override
    public CharArray getValue(int index) {
        if (index < 0 || index >= this.length) {
            return null;
        }
        return this.attributes.get((int)index).value;
    }

    public void reset() {
        this.length = 0;
    }

    private static class AttributeImpl {
        CharArray localName;
        CharArray prefix;
        CharArray qName;
        CharArray value;

        private AttributeImpl() {
        }

        public String toString() {
            return this.qName + "=" + this.value;
        }
    }
}

