/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table.sorted;

import javolution.util.internal.table.TableView;
import javolution.util.internal.table.sorted.SubSortedTableImpl;
import javolution.util.service.SortedTableService;

public abstract class SortedTableView<E>
extends TableView<E>
implements SortedTableService<E> {
    private static final long serialVersionUID = 1536L;

    public SortedTableView(SortedTableService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E element) {
        int i = this.positionOf(element);
        this.add(i < 0 ? -i - 1 : i, element);
        return true;
    }

    @Override
    public boolean addIfAbsent(E element) {
        int i = this.positionOf(element);
        if (i >= 0) {
            return false;
        }
        this.add(-i - 1, element);
        return true;
    }

    @Override
    public int indexOf(Object element) {
        int i = this.positionOf(element);
        return i >= 0 ? i : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.positionOf(o);
        if (i < 0) {
            return -1;
        }
        while (++i < this.size() && this.comparator().equal(o, this.get(i))) {
        }
        return --i;
    }

    @Override
    public abstract int positionOf(E var1);

    @Override
    public SortedTableService<E>[] split(int n, boolean updateable) {
        return SubSortedTableImpl.splitOf(this, n, updateable);
    }

    @Override
    protected SortedTableService<E> target() {
        return (SortedTableService)super.target();
    }
}

