/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class PGLockService
extends SessionLockService {
    static final String SQL_TRY_LOCK = "SELECT pg_try_advisory_lock(?,?)";
    static final String SQL_UNLOCK = "SELECT pg_advisory_unlock(?,?)";
    static final String SQL_LOCK_INFO = "SELECT l.pid, a.client_hostname, a.backend_start, a.state FROM pg_locks l LEFT JOIN pg_stat_activity a ON a.pid = l.pid WHERE l.locktype = 'advisory' AND l.classid = ? AND l.objid = ? AND l.objsubid = 2 AND l.granted";

    @Override
    public boolean supports(Database database) {
        return database instanceof PostgresDatabase && PGLockService.isAtLeastPostgres91(database);
    }

    private static boolean isAtLeastPostgres91(Database database) {
        try {
            return database.getDatabaseMajorVersion() > 9 || database.getDatabaseMajorVersion() == 9 && database.getDatabaseMinorVersion() >= 1;
        }
        catch (DatabaseException e) {
            PGLockService.getLog(PGLockService.class).warning("Problem querying database version", (Throwable)e);
            return false;
        }
    }

    private int[] getChangeLogLockId() throws LockException {
        String defaultSchemaName = this.database.getDefaultSchemaName();
        if (defaultSchemaName == null) {
            throw new LockException("Default schema name is not set for current DB user/connection");
        }
        return new int[]{this.database.getDatabaseChangeLogLockTableName().hashCode(), defaultSchemaName.hashCode()};
    }

    private static Boolean getBooleanResult(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            Boolean bl = (Boolean)rs.getObject(1);
            return bl;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_TRY_LOCK);){
            int[] lockId = this.getChangeLogLockId();
            stmt.setInt(1, lockId[0]);
            stmt.setInt(2, lockId[1]);
            boolean bl = Boolean.TRUE.equals(PGLockService.getBooleanResult(stmt));
            return bl;
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_UNLOCK);){
            int[] lockId = this.getChangeLogLockId();
            stmt.setInt(1, lockId[0]);
            stmt.setInt(2, lockId[1]);
            Boolean unlocked = PGLockService.getBooleanResult(stmt);
            if (!Boolean.TRUE.equals(unlocked)) {
                throw new LockException("pg_advisory_unlock() returned " + unlocked);
            }
        }
    }

    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_LOCK_INFO);){
            DatabaseChangeLogLock databaseChangeLogLock;
            block16: {
                ResultSet rs;
                block14: {
                    DatabaseChangeLogLock databaseChangeLogLock2;
                    block15: {
                        int[] lockId = this.getChangeLogLockId();
                        stmt.setInt(1, lockId[0]);
                        stmt.setInt(2, lockId[1]);
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            databaseChangeLogLock2 = null;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return databaseChangeLogLock2;
                }
                Timestamp lockGranted = rs.getTimestamp("backend_start");
                databaseChangeLogLock = new DatabaseChangeLogLock(1, (Date)lockGranted, PGLockService.lockedBy(rs));
                if (rs == null) break block16;
                rs.close();
            }
            return databaseChangeLogLock;
        }
    }

    private static String lockedBy(ResultSet rs) throws SQLException {
        String host = rs.getString("client_hostname");
        if (host == null) {
            return "pid#" + rs.getInt("pid");
        }
        return host + " (" + rs.getString("state") + ")";
    }
}

