/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.session;

import com.github.adminfaces.template.config.AdminConfig;
import com.github.adminfaces.template.session.AdminSession;
import com.github.adminfaces.template.util.Assert;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(urlPatterns={"/*"})
public class AdminFilter
implements Filter {
    private static final String FACES_RESOURCES = "/javax.faces.resource";
    private static final Logger log = Logger.getLogger(AdminFilter.class.getName());
    private boolean disableFilter;
    private String loginPage;
    private String errorPage;
    private String indexPage;
    @Inject
    AdminSession adminSession;
    @Inject
    AdminConfig adminConfig;
    private final List<String> ignoredResources = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String disableAdminFilter = filterConfig.getServletContext().getInitParameter("com.github.adminfaces.DISABLE_FILTER");
        if (this.adminConfig.isDisableFilter() || Assert.has(disableAdminFilter) && Boolean.valueOf(disableAdminFilter).booleanValue()) {
            this.disableFilter = true;
        }
        if (!this.disableFilter) {
            try {
                this.loginPage = filterConfig.getServletContext().getInitParameter("com.github.adminfaces.LOGIN_PAGE");
                if (!Assert.has(this.loginPage)) {
                    this.loginPage = Assert.has(this.adminConfig) ? this.adminConfig.getLoginPage() : "login.xhtml";
                }
                this.errorPage = filterConfig.getServletContext().getInitParameter("com.github.adminfaces.ERROR_PAGE");
                if (!Assert.has(this.errorPage)) {
                    this.errorPage = "500.xhtml";
                }
                this.indexPage = filterConfig.getServletContext().getInitParameter("com.github.adminfaces.INDEX_PAGE");
                if (!Assert.has(this.indexPage)) {
                    this.indexPage = Assert.has(this.adminConfig) ? this.adminConfig.getIndexPage() : "index.xhtml";
                }
                this.errorPage = this.errorPage.startsWith("/") ? this.errorPage.substring(1) : this.errorPage;
                this.loginPage = this.loginPage.startsWith("/") ? this.loginPage.substring(1) : this.loginPage;
                this.indexPage = this.indexPage.startsWith("/") ? this.indexPage.substring(1) : this.indexPage;
                this.ignoredResources.add("/" + this.loginPage.substring(0, this.loginPage.lastIndexOf(".")));
                this.ignoredResources.add("/" + this.errorPage.substring(0, this.errorPage.lastIndexOf(".")));
                String configuredResouces = this.adminConfig.getIgnoredResources();
                if (Assert.has(configuredResouces)) {
                    this.ignoredResources.addAll(Arrays.asList(configuredResouces.split(",")));
                    for (String ignoredResource : this.ignoredResources) {
                        if (ignoredResource.startsWith("/")) continue;
                        this.ignoredResources.set(this.ignoredResources.indexOf(ignoredResource), "/" + ignoredResource);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "problem initializing admin filter", e);
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.disableFilter) {
            chain.doFilter(req, resp);
            return;
        }
        req.setCharacterEncoding("UTF-8");
        resp.setCharacterEncoding("UTF-8");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (request.getRequestURI().equals(request.getContextPath() + "/") || this.adminSession.isLoggedIn() && request.getRequestURI().endsWith(this.loginPage)) {
            response.sendRedirect(request.getContextPath() + "/" + this.indexPage);
            return;
        }
        if (request.getRequestURI().contains(request.getContextPath() + "/public/")) {
            chain.doFilter(req, resp);
            return;
        }
        if (this.skipResource(request, response) || this.adminSession.isLoggedIn()) {
            if (!this.adminSession.isUserRedirected() && this.adminSession.isLoggedIn() && Assert.has(request.getHeader("Referer")) && request.getHeader("Referer").contains("?page=")) {
                this.adminSession.setUserRedirected(true);
                response.sendRedirect(request.getContextPath() + this.extractPageFromURL(request.getHeader("Referer")));
                return;
            }
            try {
                chain.doFilter(req, resp);
            }
            catch (FileNotFoundException e) {
                log.log(Level.WARNING, "File not found", e);
                response.sendError(404);
            }
        } else {
            this.redirectToLogon(request, (HttpServletResponse)resp);
            return;
        }
    }

    private String extractPageFromURL(String referer) {
        String page = referer.substring(referer.indexOf("page=") + 5);
        try {
            return URLDecoder.decode(page, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Could not extract page from url", e);
            return this.indexPage;
        }
    }

    public void destroy() {
    }

    private boolean skipResource(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getServletPath();
        if (path.contains(".")) {
            path = path.substring(0, path.lastIndexOf("."));
        }
        boolean skip = path.startsWith(FACES_RESOURCES) || this.shouldIgnoreResource(path) || response.getStatus() == 500;
        return skip;
    }

    private void redirectToLogon(HttpServletRequest request, HttpServletResponse response) {
        try {
            String referer = request.getHeader("Referer");
            String recoveryUrlParams = Assert.has(referer) && referer.contains("?") ? referer.substring(referer.lastIndexOf("?") + 1) : request.getQueryString();
            String requestedPage = request.getRequestURI();
            StringBuilder recoveryUrl = null;
            if (!this.loginPage.equals(requestedPage) && requestedPage.contains(".")) {
                if (requestedPage.startsWith(request.getContextPath())) {
                    requestedPage = requestedPage.replaceFirst(request.getContextPath(), "");
                }
                recoveryUrl = new StringBuilder(requestedPage);
                if (Assert.has(recoveryUrlParams)) {
                    recoveryUrl.append("?").append(recoveryUrlParams);
                }
            }
            String redirectUrl = request.getContextPath() + "/" + this.loginPage + (Assert.has(recoveryUrl) && this.isValidRecoveryUrl(recoveryUrl) ? "?page=" + URLEncoder.encode(recoveryUrl.toString(), "UTF-8") : "");
            if ("partial/ajax".equals(request.getHeader("Faces-Request"))) {
                response.setContentType("text/xml");
                response.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").printf("<partial-response><redirect url=\"%s\"></redirect></partial-response>", redirectUrl);
            } else {
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not redirect to " + this.loginPage, e);
        }
    }

    private boolean isValidRecoveryUrl(StringBuilder recoveryUrl) {
        String pageSuffix = this.adminConfig.getPageSufix();
        return !recoveryUrl.toString().contains("index.xhtml".replace("xhtml", pageSuffix)) && !recoveryUrl.toString().contains("403.xhtml".replace("xhtml", this.adminConfig.getPageSufix())) && !recoveryUrl.toString().contains("expired.xhtml".replace("xhtml", pageSuffix)) && !recoveryUrl.toString().contains("optimistic.xhtml".replace("xhtml", this.adminConfig.getPageSufix())) && !recoveryUrl.toString().contains("login.xhtml".replace("xhtml", this.adminConfig.getPageSufix()));
    }

    private boolean shouldIgnoreResource(String path) {
        for (String ignoredResource : this.ignoredResources) {
            if (!path.startsWith(ignoredResource)) continue;
            return true;
        }
        return false;
    }
}

