/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.bean;

import com.github.adminfaces.template.config.AdminConfig;
import com.github.adminfaces.template.config.ControlSidebarConfig;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.omnifaces.util.Faces;

@Named
@SessionScoped
public class LayoutMB
implements Serializable {
    private static final Logger LOG = Logger.getLogger(LayoutMB.class.getName());
    private static final String DEFAULT_TEMPLATE = "/admin.xhtml";
    private static final String TEMPLATE_TOP = "/admin-top.xhtml";
    private static final String APP_TEMPLATE_PATH = "/WEB-INF/templates/template.xhtml";
    private static final String APP_TEMPLATE_TOP_PATH = "/WEB-INF/templates/template-top.xhtml";
    private String template;
    private Boolean appTemplateExists;
    private Boolean leftMenuTemplate;
    private Boolean fixedLayout;
    private Boolean boxedLayout;
    private Boolean expandOnHover;
    private Boolean sidebarCollapsed;
    private Boolean fixedControlSidebar;
    private Boolean darkControlSidebarSkin;
    @Inject
    protected AdminConfig adminConfig;

    @PostConstruct
    public void init() {
        if (this.adminConfig.isLeftMenuTemplate()) {
            this.setDefaultTemplate();
        } else {
            this.setTemplateTop();
        }
        ControlSidebarConfig controlSidebarConfig = this.adminConfig.getControlSidebar();
        this.fixedLayout = controlSidebarConfig.getFixedLayout();
        this.boxedLayout = controlSidebarConfig.getBoxedLayout();
        this.expandOnHover = controlSidebarConfig.getExpandOnHover();
        this.sidebarCollapsed = controlSidebarConfig.getSidebarCollapsed();
        this.fixedControlSidebar = controlSidebarConfig.getFixed();
        this.darkControlSidebarSkin = controlSidebarConfig.getDarkSkin();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setTemplateTop() {
        this.template = this.appTemplateExists() ? APP_TEMPLATE_TOP_PATH : TEMPLATE_TOP;
        this.leftMenuTemplate = false;
    }

    public void setDefaultTemplate() {
        this.template = this.appTemplateExists() ? APP_TEMPLATE_PATH : DEFAULT_TEMPLATE;
        this.leftMenuTemplate = true;
    }

    public Boolean getLeftMenuTemplate() {
        return this.leftMenuTemplate;
    }

    public void setLeftMenuTemplate(Boolean leftMenuTemplate) {
        this.leftMenuTemplate = leftMenuTemplate;
    }

    public Boolean getFixedLayout() {
        return this.fixedLayout;
    }

    public void setFixedLayout(Boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
    }

    public Boolean getBoxedLayout() {
        return this.boxedLayout;
    }

    public void setBoxedLayout(Boolean boxedLayout) {
        this.boxedLayout = boxedLayout;
    }

    public Boolean getExpandOnHover() {
        return this.expandOnHover;
    }

    public void setExpandOnHover(Boolean expandOnHover) {
        this.expandOnHover = expandOnHover;
    }

    public Boolean getSidebarCollapsed() {
        return this.sidebarCollapsed;
    }

    public void setSidebarCollapsed(Boolean sidebarCollapsed) {
        this.sidebarCollapsed = sidebarCollapsed;
    }

    public Boolean getFixedControlSidebar() {
        return this.fixedControlSidebar;
    }

    public void setFixedControlSidebar(Boolean fixedControlSidebar) {
        this.fixedControlSidebar = fixedControlSidebar;
    }

    public Boolean getDarkControlSidebarSkin() {
        return this.darkControlSidebarSkin;
    }

    public void setDarkControlSidebarSkin(Boolean darkControlSidebarSkin) {
        this.darkControlSidebarSkin = darkControlSidebarSkin;
    }

    public void toggleTemplate() {
        if (this.isDefaultTemplate()) {
            this.setTemplateTop();
        } else {
            this.setDefaultTemplate();
        }
    }

    public void toggleFixedLayout() {
        this.fixedLayout = this.fixedLayout == false;
    }

    public void toggleBoxedLayout() {
        this.boxedLayout = this.boxedLayout == false;
    }

    public void toggleExpandOnHover() {
        this.expandOnHover = this.expandOnHover == false;
    }

    public void toggleSidebarCollapsed() {
        this.sidebarCollapsed = this.sidebarCollapsed == false;
    }

    public void toggleFixedControlSidebar() {
        this.fixedControlSidebar = this.fixedControlSidebar == false;
    }

    public void toggleControlSidebarSkin() {
        this.darkControlSidebarSkin = this.darkControlSidebarSkin == false;
    }

    public boolean isDefaultTemplate() {
        return this.template != null && (this.template.endsWith("template.xhtml") || this.template.equals("admin.xhtml"));
    }

    private boolean appTemplateExists() {
        if (this.appTemplateExists != null) {
            return this.appTemplateExists;
        }
        try {
            this.appTemplateExists = Faces.getExternalContext().getResourceAsStream(APP_TEMPLATE_PATH) != null;
        }
        catch (Exception e) {
            LOG.warning(String.format("Could not find application defined template in path '%s' due to following error: %s. Falling back to default admin template. See application template documentation for more details: https://github.com/adminfaces/admin-template#application-template", APP_TEMPLATE_PATH, e.getMessage()));
            this.appTemplateExists = false;
        }
        return this.appTemplateExists;
    }
}

