/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.bean;

import com.github.adminfaces.template.config.AdminConfig;
import com.github.adminfaces.template.model.BreadCrumb;
import com.github.adminfaces.template.util.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.omnifaces.util.Faces;

@Named
@SessionScoped
public class BreadCrumbMB
implements Serializable {
    @Inject
    protected AdminConfig adminConfig;
    private int maxSize = 5;
    private List<BreadCrumb> breadCrumbs = new ArrayList<BreadCrumb>();

    @PostConstruct
    public void init() {
        this.maxSize = this.adminConfig.getBreadCrumbMaxSize();
    }

    public void add(String link, String title, Boolean clear) {
        if (clear != null && clear.booleanValue()) {
            this.breadCrumbs.clear();
        }
        if (title != null && !title.isEmpty()) {
            this.add(new BreadCrumb(link, title));
        }
    }

    public void add(String link, String title, Boolean clear, Boolean shouldAdd) {
        if (shouldAdd != null && shouldAdd.booleanValue()) {
            this.add(link, title, clear);
        }
    }

    public void add(BreadCrumb breadCrumb) {
        String link = breadCrumb.getLink();
        if (!Assert.has(link)) {
            String pageUrl = FacesContext.getCurrentInstance().getViewRoot().getViewId();
            link = pageUrl.replaceAll(pageUrl.substring(pageUrl.lastIndexOf(46) + 1), this.adminConfig.getPageSufix());
        }
        if (!link.startsWith("/")) {
            link = "/" + link;
        }
        if (link != null && this.adminConfig.isExtensionLessUrls()) {
            link = link.substring(0, link.lastIndexOf("."));
        } else if (link != null && !link.contains(".")) {
            link = link + "." + this.adminConfig.getPageSufix();
        }
        breadCrumb.setLink(link);
        if (this.breadCrumbs.contains(breadCrumb)) {
            this.breadCrumbs.remove(breadCrumb);
        }
        if (this.breadCrumbs.size() == this.maxSize) {
            this.breadCrumbs.remove(0);
        }
        this.breadCrumbs.add(breadCrumb);
    }

    public void remove(BreadCrumb breadCrumb) {
        this.breadCrumbs.remove(breadCrumb);
    }

    public void clear() {
        this.breadCrumbs.clear();
    }

    public void clearAndHome() throws IOException {
        this.clear();
        Faces.redirect((String)Faces.getRequestBaseURL(), (String[])new String[0]);
    }

    public List<BreadCrumb> getBreadCrumbs() {
        return this.breadCrumbs;
    }

    public void setBreadCrumbs(List<BreadCrumb> breadCrumbs) {
        this.breadCrumbs = breadCrumbs;
    }
}

