/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence.dao;

import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.dao.AbstractStoredArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class StoredArticleJpaDao
extends AbstractStoredArticleJpaDao {
    public StoredArticleJpaDao(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public List<StoredArticle> findAllForArticleInBuilding(Article article, Building building) {
        TypedQuery query = this.createQuery("from StoredArticle sa where sa.article = :article and sa.location.warehouse.withdrawAllowed = true and sa.location.warehouse.building = :building");
        query.setParameter("article", (Object)article);
        query.setParameter("building", (Object)building);
        List resultList = this.findAll(query);
        for (StoredArticle storedArticle : resultList) {
            this.entityManager.detach((Object)storedArticle);
        }
        return resultList;
    }

    @Override
    public List<StoredArticle> findAllReceivedForAllSupplier(Building building) {
        TypedQuery query = this.createQuery("from StoredArticle sa where sa.location.warehouse.building = :building and sa.location.code = :code");
        query.setParameter("building", (Object)building);
        query.setParameter("code", (Object)Locations.codeForReceptionLocations());
        List resultList = this.findAll(query);
        for (StoredArticle storedArticle : resultList) {
            this.entityManager.detach((Object)storedArticle);
        }
        return resultList;
    }

    @Override
    public List<StoredArticle> findAllReceivedForSupplier(Building building, String supplierId) {
        TypedQuery query = this.createQuery("from StoredArticle sa where sa.location.warehouse.building = :building and sa.location.code = :code and sa.article.supplier.id = :supplierId");
        query.setParameter("building", (Object)building);
        query.setParameter("supplierId", (Object)supplierId);
        query.setParameter("code", (Object)Locations.codeForReceptionLocations());
        List resultList = this.findAll(query);
        for (StoredArticle storedArticle : resultList) {
            this.entityManager.detach((Object)storedArticle);
        }
        return resultList;
    }

    @Override
    public List<StoredArticle> findAllByLocation(Location location) {
        TypedQuery query = this.createQuery("from StoredArticle sa where sa.location = :location");
        query.setParameter("location", (Object)location);
        List resultList = this.findAll(query);
        for (StoredArticle storedArticle : resultList) {
            this.entityManager.detach((Object)storedArticle);
        }
        return resultList;
    }

    @Override
    public StoredArticle findDetachedById(String storedArticleId) {
        StoredArticle storedArticle = (StoredArticle)this.findById(storedArticleId);
        this.entityManager.detach((Object)storedArticle);
        return storedArticle;
    }

    @Override
    public StoredArticle findInReception(Building building, Article article) {
        TypedQuery query = this.createQuery("from StoredArticle sa where sa.article = :article and sa.location.code = :codeForReceptionLocations and sa.location.warehouse.building = :building");
        query.setParameter("building", (Object)building);
        query.setParameter("article", (Object)article);
        query.setParameter("codeForReceptionLocations", (Object)Locations.codeForReceptionLocations());
        return (StoredArticle)this.findUnique(query);
    }
}

