/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence.dao;

import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.dao.AbstractStorageMovementJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class StorageMovementJpaDao
extends AbstractStorageMovementJpaDao {
    public StorageMovementJpaDao(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public List<StorageMovement> findAllByArticle(Article article) {
        Query query = this.entityManager.createQuery("from StorageMovement sm where sm.article = :article");
        query.setParameter("article", (Object)article);
        return query.getResultList();
    }

    @Override
    public List<StorageMovement> findAllInReception(Building building) {
        Query query = this.entityManager.createQuery(" from StorageMovement sm where sm.originLocation.code = :codeForReceptionLocations and sm.originLocation.warehouse.building = :building or  sm.destinationLocation.code = :codeForReceptionLocations and sm.destinationLocation.warehouse.building = :building");
        query.setParameter("building", (Object)building);
        query.setParameter("codeForReceptionLocations", (Object)Locations.codeForReceptionLocations());
        return query.getResultList();
    }

    @Override
    public List<StorageMovement> findAllImpactingStoredArticle(StoredArticle storedArticle) {
        Query query = this.entityManager.createQuery("from StorageMovement sm where sm.article = :article and (sm.originLocation = :location or sm.destinationLocation = :location)");
        query.setParameter("location", (Object)storedArticle.getLocation());
        query.setParameter("article", (Object)storedArticle.getArticle());
        return query.getResultList();
    }

    @Override
    public List<StorageMovement> findAll() {
        Query query = this.entityManager.createQuery("from StorageMovement sm order by sm.movementDate");
        return query.getResultList();
    }

    @Override
    public List<StorageMovement> findAllUnconfirmed(MagalieUser magalieUser) {
        HashMap storageMovementProperties = Maps.newHashMap();
        storageMovementProperties.put("magalieUser", magalieUser);
        storageMovementProperties.put("confirmDate", null);
        List storageMovements = this.findAllByProperties(storageMovementProperties);
        return storageMovements;
    }
}

