/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence;

import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class StorageMovements {
    public static Function<StorageMovement, Article> getArticleFunction() {
        return new GetArticleFunction();
    }

    public static Function<StorageMovement, Location> getOriginFunction() {
        return new GetOriginFunction();
    }

    public static Function<StorageMovement, Location> getDestinationFunction() {
        return new GetDestinationFunction();
    }

    public static Predicate<StorageMovement> storageMovementIsConfirmed() {
        return new StorageMovementIsConfirmedPredicate();
    }

    public static Predicate<StorageMovement> storageMovementIsNotConfirmed() {
        return Predicates.not(StorageMovements.storageMovementIsConfirmed());
    }

    protected static class StorageMovementIsConfirmedPredicate
    implements Predicate<StorageMovement> {
        protected StorageMovementIsConfirmedPredicate() {
        }

        public boolean apply(StorageMovement storageMovement) {
            return storageMovement.isConfirmed();
        }
    }

    protected static class GetDestinationFunction
    implements Function<StorageMovement, Location> {
        protected GetDestinationFunction() {
        }

        public Location apply(StorageMovement storageMovement) {
            return storageMovement.getDestinationLocation();
        }
    }

    protected static class GetOriginFunction
    implements Function<StorageMovement, Location> {
        protected GetOriginFunction() {
        }

        public Location apply(StorageMovement storageMovement) {
            return storageMovement.getOriginLocation();
        }
    }

    protected static class GetArticleFunction
    implements Function<StorageMovement, Article> {
        protected GetArticleFunction() {
        }

        public Article apply(StorageMovement storageMovement) {
            return storageMovement.getArticle();
        }
    }
}

