/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence;

import com.franciaflex.magalie.persistence.RequestedLists;
import com.franciaflex.magalie.persistence.entity.RequestedArticle;
import com.franciaflex.magalie.persistence.entity.RequestedList;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public class RequestedArticles {
    public static Comparator<RequestedArticle> comparator() {
        Comparator<RequestedList> requestedListComparator = RequestedLists.comparator();
        Ordering comparator = Ordering.compound((Iterable)Lists.newArrayList((Object[])new Comparator[]{Ordering.from(requestedListComparator).onResultOf(RequestedArticles.getRequestList()), RequestedArticles.priorityComparator()}));
        return comparator;
    }

    public static Comparator<RequestedArticle> priorityComparator() {
        return Ordering.natural().onResultOf((Function)new GetPriority());
    }

    public static Function<RequestedArticle, RequestedList> getRequestList() {
        return new GetRequestList();
    }

    protected static class GetPriority
    implements Function<RequestedArticle, String> {
        protected GetPriority() {
        }

        public String apply(RequestedArticle requestedArticle) {
            return requestedArticle.getPriority();
        }
    }

    protected static class GetRequestList
    implements Function<RequestedArticle, RequestedList> {
        protected GetRequestList() {
        }

        public RequestedList apply(RequestedArticle requestedArticle) {
            return requestedArticle.getRequestedList();
        }
    }
}

