/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie;

import com.franciaflex.magalie.MagalieConfigOption;
import com.franciaflex.magalie.MagalieTechnicalException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

public class MagalieApplicationConfig {
    private static final Log log = LogFactory.getLog(MagalieApplicationConfig.class);
    protected ApplicationConfig applicationConfig = new ApplicationConfig();
    protected ImmutableMap<String, String> oracleCompatibilityModeJpaParameters;

    public MagalieApplicationConfig() {
        this("magalie");
    }

    public MagalieApplicationConfig(String contextPath) {
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])MagalieConfigOption.values());
        String configFileName = contextPath + ".properties";
        if (log.isDebugEnabled()) {
            log.debug((Object)("will read file config file name " + configFileName));
        }
        this.applicationConfig.setConfigFileName(configFileName);
        try {
            this.applicationConfig.parse(new String[0]);
        }
        catch (ArgumentsParserException e) {
            throw new MagalieTechnicalException(e);
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            ArrayList options = Lists.newArrayList((Object[])MagalieConfigOption.values());
            for (MagalieConfigOption option : options) {
                builder.append(String.format("\n%1$-40s = %2$s", option.getKey(), this.applicationConfig.getOption((ConfigOptionDef)option)));
            }
            log.info((Object)("MagaLiE configuration:" + builder.toString()));
        }
    }

    public Map<String, String> getJpaParameters() {
        HashMap jpaParameters = Maps.newHashMap();
        Properties hibernateProperties = this.applicationConfig.getOptionStartsWith("hibernate");
        jpaParameters.putAll(hibernateProperties);
        Properties jpaProperties = this.applicationConfig.getOptionStartsWith("javax.persistence");
        jpaParameters.putAll(jpaProperties);
        if (this.isOracleCompatibilityMode()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("oracle compatibility mode enabled: overriding settings with " + this.oracleCompatibilityModeJpaParameters));
            }
            jpaParameters.putAll(this.getOracleCompatibilityModeJpaParameters());
        }
        return jpaParameters;
    }

    protected ImmutableMap<String, String> getOracleCompatibilityModeJpaParameters() {
        if (this.oracleCompatibilityModeJpaParameters == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream("/hibernate-oracle.properties");
                Properties oracleCompatibilityModeProperties = new Properties();
                oracleCompatibilityModeProperties.load(inputStream);
                this.oracleCompatibilityModeJpaParameters = Maps.fromProperties((Properties)oracleCompatibilityModeProperties);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                try {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"should never occur", (Throwable)e);
                    }
                    throw new MagalieTechnicalException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return this.oracleCompatibilityModeJpaParameters;
    }

    public boolean isDevMode() {
        boolean isDevMode = this.applicationConfig.getOptionAsBoolean(MagalieConfigOption.DEV_MODE.key);
        return isDevMode;
    }

    public boolean isOracleCompatibilityMode() {
        boolean isOracleCompatibilityMode = this.applicationConfig.getOptionAsBoolean(MagalieConfigOption.ORACLE_COMPATIBILITY_MODE.key);
        return isOracleCompatibilityMode;
    }
}

