/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action.admin;

import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

@InterceptorRefs(value={@InterceptorRef(value="faxToMailInterceptor"), @InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="paramsPrepareParamsStack")})
public class ImportArchiveAction
extends FaxToMailActionSupport
implements Preparable {
    private static final Log log = LogFactory.getLog(ImportArchiveAction.class);
    protected String attachmentBase;
    protected File archiveFile;
    protected EmailService emailService;
    protected boolean disabledImport;

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public void setAttachmentBase(String attachmentBase) {
        this.attachmentBase = attachmentBase;
    }

    public boolean isDisabledImport() {
        return this.disabledImport;
    }

    public void prepare() throws Exception {
        if (!this.getSession().isAdmin()) {
            throw new RuntimeException("Not authorized");
        }
    }

    @Action(value="import-archive-input")
    public String input() throws Exception {
        this.checkDisabled();
        return super.input();
    }

    protected boolean checkDisabled() {
        if (this.emailService.getArchivedMailCount() > 1000L) {
            this.disabledImport = true;
        }
        return this.disabledImport;
    }

    public void validate() {
        if (StringUtils.isNotEmpty((CharSequence)this.attachmentBase) && !new File(this.attachmentBase).isDirectory()) {
            this.addActionError("Le r\u00e9pertoire de base des pi\u00e8ces jointes n'est pas un r\u00e9pertoire lisible !");
        }
        if (this.archiveFile == null) {
            this.addActionError("Le fichier d'archive est obligatoire !");
        }
        this.checkDisabled();
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "import-archive-input"})})
    public String execute() throws Exception {
        String result = "input";
        if (!this.checkDisabled()) {
            try (FileInputStream is = new FileInputStream(this.archiveFile);){
                File file = new File(this.attachmentBase);
                this.emailService.importArchive((InputStream)is, file);
                result = "success";
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import archive file", (Throwable)ex);
                }
                this.addActionError("Can't import archive " + ex.getMessage());
            }
        }
        return result;
    }
}

