package com.franciaflex.faxtomail.ui.swing.content;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class MainUI extends JFrame implements FaxToMailUI<FaxToMailUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEMAND_LIST_BUTTON_SELECTED = "demandListButton.selected";
    public static final String BINDING_SEARCH_BUTTON_SELECTED = "searchButton.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXz28bRRSeOLFbO6mSNm3UlgJOf0gJKutQkVMoNHZiYsuJq9iVInII492xvenuzrL7Fm8UBfEn8CfQOxckbpwQB84cuCD+BYQ4cEW8mXV2bWc3dg5EkRPNe+9733zz3pvxd3+StOuQ5WPq+4rjWaCbTKluHhzUW8dMhS3mqo5uA3dI8DOVIqlDMquF6y6QR4c1EV7ohxdK3LS5xayB6I0ayblwYjC3yxgAeXs4QnXdQiM0b/i255yjhqTiUL/9+6/UN9rXb1KE+Dayy+FW8uOiop3M1EhK14Dcwkxf0oJBrQ7ScHSrg3xviLWSQV13j5rsC/IVuVYjGZs6CAbk4eRblhgy3reBZE2qW2UHIYF8oHJTaTvUUnXaNpivtKkPHB0MxdMVt4dEFJVbgLjKLoa9qti2RMoASZtcYwaQ9QkwytRvcgQwXlVKAs6HCCcD3C5SB8htsV+/H1Ftcm7gsnDKhr4LGjOppdV0F4oeAEKReyNRnY7BApuImQ9D51xGHbUbmW4P22cfhxKu4YEIVIX2IDq/YfdsiyOQ2Wd4c5jmLG1xL2S4OMQwInA/9J9pce0EyDJ3OsoxVvZrlCTw95XqQVMHg2kvqcWM4TQZFyh4WP9PhiouSNSQtl3murTDBoMd8taQO5a+EpV+VJtThyTteLgM5O7hxW7ZR1PQJ3dH+kQASuu/S4u//fjHD+Xz5pjD3HdiXQd6G4vWdrjNHNBF6vmgMzzQjcIutTcOSdZlBg4G2fgPYog1+mYkh/luyoMU4coOdbsIkb72+08/L33+6zRJlUnO4FQrU+FfIVnoOqgCNzTf/uSFZDTXu46fC4Ib6t3ijobESOE0X5T/BpEniuowCmzbtOEkMKysPc2vP82Lz9X8mY8qPYhRKaTayv7yz2Lj+xfnSk0h83uJ7pFa6c9IRrcM3WJykPRnROzgmLVd5mk8mgVx04HgfMhVGwyHDMVE/SZ9T34qcZLMm9TXTc/c570S98RcSj1b8z3h/ww9UjLyQwG7VGTUKusGMIe2MCs3W7zI/X4K6TInXEYMSblTOIBANAaQx9HAEaNNkcsKtW1DVyno3NqTs+6OxtrUM6BkcJfVscCkDWvotCqnobJVP9qrN3cqe58e1feOSrV6Y/ss2spUn+fgALXHkJxG5zZWGIgdI+E2NVz8mzGp09Ex9fKpxXr5cNRULLS6K+uydMTv6hmQG0HRvcScwLRzkDhe/UE6jlQayPWghQTc+6d5OceVDoMGljGzVlbzz5/nw4kdLCq1SqOZRzozYngj8xHNsQ9QTCUYz0zMZyykYLEiLhAyY8i1W0cD57KpBiewczrBFRKAYRN0eW8rShNgKKooYqQ3C3htNHW7KVk+GcsSi8WO0/LCRXM1VQsTqtrY3twv7Qzo+m48Y4epXYa3FxtRNRNcagm6lq+q6/55mktVfTSGY5KmQzfwOD1nQknux6djvn6hxoK1WC0qV9FCjojNUZAEOd5J5pekRE4YJ9NhemSPafm0SNhk8aoHvinALt1dQkFKFknbG3z+/D8jck1erWtXHpHRq20cL7xfsvgU6GEpqK8jXgtibZeZeOk3+o+vSwZy8D4bl0q8LLpM73TFsX4UXOd5Cvg1oOUB+/gC8pT4zE2Amu7hd4uuML9JBvkP2sVuH4ANAAA=";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton aboutButton;
    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected JToggleButton demandListButton;
    protected final MainUIHandler handler = createHandler();
    protected MainUI mainFrame = this;
    protected FaxToMailUIContext model;
    protected JToggleButton searchButton;
    protected StatusMessagePanel status;
    protected JToolBar topBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Component $Component0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(FaxToMailUIContext context) {
        FaxToMailUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAboutButton() {
        return aboutButton;
    }

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public JToggleButton getDemandListButton() {
        return demandListButton;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public FaxToMailUIContext getModel() {
        return model;
    }

    public JToggleButton getSearchButton() {
        return searchButton;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public JToolBar getTopBar() {
        return topBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Component get$Component0() {
        return $Component0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(aboutButton);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(topBar, BorderLayout.NORTH);
        add(bottomBar);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
    }

    protected void addChildrenToTopBar() {
        if (!allComponentsCreated) {
            return;
        }
        topBar.add(demandListButton);
        topBar.add(searchButton);
        topBar.add($Component0);
    }

    protected void createAboutButton() {
        $objectMap.put("aboutButton", aboutButton = new JButton());
        
        aboutButton.setName("aboutButton");
        aboutButton.setToolTipText(t("faxtomail.main.action.about.tip"));
        aboutButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowAboutAction.class);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createDemandListButton() {
        $objectMap.put("demandListButton", demandListButton = new JToggleButton());
        
        demandListButton.setName("demandListButton");
        demandListButton.setText(t("faxtomail.main.action.demandeList"));
        demandListButton.setToolTipText(t("faxtomail.main.action.demandeList.tip"));
        demandListButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeListAction.class);
    }

    protected MainUIHandler createHandler() {
        return new MainUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FaxToMailUIContext.class));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JToggleButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(t("faxtomail.main.action.recherche"));
        searchButton.setToolTipText(t("faxtomail.main.action.recherche.tip"));
        searchButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowRechercheAction.class);
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
        status.setShowClock(false);
        status.setShowMemoryStatus(false);
    }

    protected void createTopBar() {
        $objectMap.put("topBar", topBar = new JToolBar());
        
        topBar.setName("topBar");
        topBar.setFloatable(false);
        topBar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToTopBar();
        addChildrenToBottomBar();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        topBar.setMargin(new java.awt.Insets(5, 5, 5, 5));
        demandListButton.setIcon(SwingUtil.createActionIcon("list"));
        searchButton.setIcon(SwingUtil.createActionIcon("search"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        aboutButton.setIcon(SwingUtil.createActionIcon("about"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createTopBar();
        createDemandListButton();
        createSearchButton();
        // inline creation of $Component0
        $objectMap.put("$Component0", $Component0 = Box.createHorizontalGlue());
        
        $Component0.setName("$Component0");
        createBottomBar();
        createAboutButton();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,780);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("faxtomail.main.title.applicationName"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMAND_LIST_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    demandListButton.setSelected( model.getScreen() == FaxToMailScreen.LIST );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SEARCH_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    searchButton.setSelected( model.getScreen() == FaxToMailScreen.SEARCH );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
    }

}