/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DontUseCopyRequestControl
extends Control {
    public static final String DONT_USE_COPY_REQUEST_OID = "1.3.6.1.1.22";
    private static final long serialVersionUID = -5352797941017941217L;

    public DontUseCopyRequestControl() {
        super(DONT_USE_COPY_REQUEST_OID, true, null);
    }

    public DontUseCopyRequestControl(Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_DONT_USE_COPY_HAS_VALUE.get());
        }
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_DONT_USE_COPY.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DontUseCopyRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

