/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.transmit;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import org.nuiton.jaxx.application.swing.util.Cancelable;

public class MailFolderChooserUIHandler
extends AbstractFaxToMailUIHandler<MailFolderChooserUIModel, MailFolderChooserUI>
implements Cancelable {
    public void afterInit(MailFolderChooserUI mailFolderChooserUI) {
        this.initUI(mailFolderChooserUI);
        MailFolderChooserUIModel model = (MailFolderChooserUIModel)((Object)this.getModel());
        MailFolder currentMailFolder = model.getDemandeUIModels().get(0).getMailFolder();
        HashSet<WaitingState> allWaitingStates = new HashSet<WaitingState>();
        for (DemandeUIModel demande : model.getDemandeUIModels()) {
            if (demande.getWaitingState() == null) continue;
            allWaitingStates.add(demande.getWaitingState());
        }
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        Collection foldersWithWaitingState = null;
        if (!allWaitingStates.isEmpty()) {
            foldersWithWaitingState = serviceContext.getMailFolderService().getFoldersWithWaitingState(allWaitingStates);
        }
        List folders = serviceContext.getMailFolderService().getRootMailFoldersWithMoveRights(this.getContext().getCurrentUser());
        JTree navigationTree = ((MailFolderChooserUI)this.ui).getNavigationTree();
        List<MailFolder> foldersToExpand = this.getContext().getTransmitExpandedFolders();
        Map<MailFolder, FolderTreeNode> nodesByFolder = FaxToMailUIUtil.initFolderTree(this.getContext(), navigationTree, folders, foldersToExpand, false);
        for (MailFolder folder : nodesByFolder.keySet()) {
            DefaultMutableTreeNode node = nodesByFolder.get(folder);
            if (!node.getClass().isAssignableFrom(FolderTreeNode.class)) continue;
            FolderTreeNode folderTreeNode = (FolderTreeNode)node;
            MailFolder folderWithAllowMoveDemandIntoFolder = folder;
            folderTreeNode.setCanSelect(!currentMailFolder.equals(folder) && folderWithAllowMoveDemandIntoFolder.isFolderMoveable() && (foldersWithWaitingState == null || foldersWithWaitingState.contains(folder)));
        }
        navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FolderTreeNode folderNode = (FolderTreeNode)e.getPath().getLastPathComponent();
                MailFolder folder = folderNode.getMailFolder();
                if (!folderNode.isCanSelect()) {
                    folder = null;
                }
                ((MailFolderChooserUIModel)((Object)MailFolderChooserUIHandler.this.getModel())).setMailFolder(folder);
            }
        });
        ((MailFolderChooserUIModel)((Object)this.getModel())).setMailFolder(null);
    }

    public void onCloseUI() {
        JTree tree = ((MailFolderChooserUI)this.getUI()).getNavigationTree();
        List<MailFolder> folders = FaxToMailUIUtil.getExpandedFolders(tree);
        this.getContext().setTransmitExpandedFolders(folders);
    }

    public SwingValidator<MailFolderChooserUIModel> getValidator() {
        return null;
    }

    public void cancel() {
        this.closeFrame();
    }

    protected JComponent getComponentToFocus() {
        return ((MailFolderChooserUI)this.ui).getNavigationTree();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }
}

