/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

abstract class AbstractRLEDecoder
implements Decoder {
    protected final byte[] row;
    protected final int width;
    protected int srcX;
    protected int srcY;
    protected int dstX;
    protected int dstY;

    AbstractRLEDecoder(int n, int n2) {
        int n3 = this.width = n;
        int n4 = n3 % 4;
        if (n4 != 0) {
            n3 += 4 - n4;
        }
        this.row = new byte[n3];
        this.srcX = 0;
        this.srcY = n2 - 1;
        this.dstX = this.srcX;
        this.dstY = this.srcY;
    }

    protected abstract void decodeRow(InputStream var1) throws IOException;

    public final int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining() && this.dstY >= 0) {
            if (this.dstX == 0 && this.srcY == this.dstY) {
                this.decodeRow(inputStream);
            }
            int n = Math.min(this.row.length - this.dstX, byteBuffer.remaining());
            byteBuffer.put(this.row, 0, n);
            this.dstX += n;
            if (this.dstX != this.row.length) continue;
            this.dstX = 0;
            --this.dstY;
            if (this.dstY <= this.srcY) continue;
            for (int i = 0; i < this.row.length; ++i) {
                this.row[i] = 0;
            }
        }
        return byteBuffer.position();
    }

    protected static int checkEOF(int n) throws EOFException {
        if (n < 0) {
            throw new EOFException("Premature end of file");
        }
        return n;
    }
}

