/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.actions.SaveDemandeAndExitAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import javax.swing.JOptionPane;
import org.nuiton.i18n.I18n;

public class ArchiveAction
extends SaveDemandeAndExitAction {
    protected DemandeUIModel previousState;

    public ArchiveAction(DemandeUIHandler handler) {
        super(handler);
        this.setActionDescription(I18n.t((String)"faxtomail.action.archive.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        int i = JOptionPane.showConfirmDialog(null, I18n.t((String)"faxtomail.alert.archiveConfirmation.message", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.archiveConfirmation.title", (Object[])new Object[0]), 0, 3);
        boolean result = i == 0;
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        this.previousState = new DemandeUIModel();
        this.previousState.setDemandStatus(model.getDemandStatus());
        this.previousState.setTakenBy(model.getTakenBy());
        this.previousState.setMailFolder(model.getMailFolder());
        MailFolder folder = model.getMailFolder();
        MailFolder archiveChild = null;
        do {
            Optional optArchiveChild;
            Collection<MailFolder> children;
            if ((children = folder.getChildren()) != null && (optArchiveChild = Iterables.tryFind(children, (Predicate)new Predicate<MailFolder>(){

                public boolean apply(MailFolder mailFolder) {
                    return mailFolder.isArchiveFolder();
                }
            })).isPresent()) {
                archiveChild = (MailFolder)optArchiveChild.get();
            }
            folder = folder.getParent();
        } while (archiveChild == null && folder != null);
        if (archiveChild != null) {
            model.setMailFolder(archiveChild);
        }
        model.setArchiveDate(new Date());
        model.setDemandStatus(DemandStatus.ARCHIVED);
        model.setTakenBy(null);
        super.doAction();
    }

    @Override
    public void postSuccessAction() {
        if (this.getContext().isUseFolderCache()) {
            this.getContext().getCurrentFolderEmails().removeDemand((DemandeUIModel)this.getModel());
        }
        super.postSuccessAction();
    }

    @Override
    public void postFailedAction(Throwable error) {
        super.postFailedAction(error);
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        model.setMailFolder(this.previousState.getMailFolder());
        model.setArchiveDate(null);
        model.setDemandStatus(this.previousState.getDemandStatus());
        model.setTakenBy(this.previousState.getTakenBy());
        this.previousState = null;
    }
}

