/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.AdobeDCTSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFIFSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.SOFSegment;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.color.ICC_Profile;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class JPEGImage10MetadataCleaner {
    static final String JAVAX_IMAGEIO_JPEG_IMAGE_1_0 = "javax_imageio_jpeg_image_1.0";
    private final JPEGImageReader reader;

    JPEGImage10MetadataCleaner(JPEGImageReader jPEGImageReader) {
        this.reader = jPEGImageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    IIOMetadata cleanMetadata(IIOMetadata iIOMetadata) throws IOException {
        void var16_24;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        List<JPEGSegment> list = this.reader.getAppSegments(-1, null);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("JPEGvariety").item(0);
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("markerSequence").item(0);
        JFIFSegment jFIFSegment = this.reader.getJFIF();
        JFXXSegment jFXXSegment = this.reader.getJFXX();
        AdobeDCTSegment adobeDCTSegment = this.reader.getAdobeDCT();
        ICC_Profile iCC_Profile = this.reader.getEmbeddedICCProfile(true);
        SOFSegment sOFSegment = this.reader.getSOF();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (jFIFSegment != null) {
            if (sOFSegment.componentsInFrame() == 1 || sOFSegment.componentsInFrame() == 3) {
                IIOMetadataNode iIOMetadataNode4;
                object6 = new IIOMetadataNode("app0JFIF");
                ((IIOMetadataNode)object6).setAttribute("majorVersion", String.valueOf(jFIFSegment.majorVersion));
                ((IIOMetadataNode)object6).setAttribute("minorVersion", String.valueOf(jFIFSegment.minorVersion));
                ((IIOMetadataNode)object6).setAttribute("resUnits", String.valueOf(jFIFSegment.units));
                ((IIOMetadataNode)object6).setAttribute("Xdensity", String.valueOf(Math.max(1, jFIFSegment.xDensity)));
                ((IIOMetadataNode)object6).setAttribute("Ydensity", String.valueOf(Math.max(1, jFIFSegment.yDensity)));
                ((IIOMetadataNode)object6).setAttribute("thumbWidth", String.valueOf(jFIFSegment.xThumbnail));
                ((IIOMetadataNode)object6).setAttribute("thumbHeight", String.valueOf(jFIFSegment.yThumbnail));
                iIOMetadataNode2.appendChild((Node)object6);
                bl = true;
                if (iCC_Profile != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("app2ICC");
                    iIOMetadataNode4.setUserObject(iCC_Profile);
                    ((IIOMetadataNode)object6).appendChild(iIOMetadataNode4);
                    bl3 = true;
                }
                if (jFXXSegment != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("JFXX");
                    ((IIOMetadataNode)object6).appendChild(iIOMetadataNode4);
                    IIOMetadataNode object52 = new IIOMetadataNode("app0JFXX");
                    object52.setAttribute("extensionCode", String.valueOf(jFXXSegment.extensionCode));
                    object4 = new JFXXThumbnailReader(null, this.reader.getThumbnailReader(), 0, 0, jFXXSegment);
                    switch (jFXXSegment.extensionCode) {
                        case 16: {
                            object3 = new IIOMetadataNode("JFIFthumbJPEG");
                            object2 = ((JFXXThumbnailReader)object4).readMetadata();
                            Node node = ((IIOMetadata)object2).getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
                            ((IIOMetadataNode)object3).appendChild(node.getLastChild());
                            object52.appendChild((Node)object3);
                            break;
                        }
                        case 17: {
                            object3 = new IIOMetadataNode("JFIFthumbPalette");
                            ((IIOMetadataNode)object3).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object4).getWidth()));
                            ((IIOMetadataNode)object3).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object4).getHeight()));
                            object52.appendChild((Node)object3);
                            break;
                        }
                        case 19: {
                            object3 = new IIOMetadataNode("JFIFthumbRGB");
                            ((IIOMetadataNode)object3).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object4).getWidth()));
                            ((IIOMetadataNode)object3).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object4).getHeight()));
                            object52.appendChild((Node)object3);
                            break;
                        }
                        default: {
                            this.reader.processWarningOccurred(String.format("Unknown JFXX extension code: %d", jFXXSegment.extensionCode));
                        }
                    }
                    iIOMetadataNode4.appendChild(object52);
                    bl2 = true;
                }
            } else {
                this.reader.processWarningOccurred(String.format("Incompatible JFIF marker segment in stream. SOF%d has %d color components, JFIF allows only 1 or 3 components. Ignoring JFIF marker.", sOFSegment.marker & 0xF, sOFSegment.componentsInFrame()));
            }
        }
        if (adobeDCTSegment != null && adobeDCTSegment.getTransform() == 2 && sOFSegment.componentsInFrame() < 4) {
            this.reader.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates YCCK/CMYK data, but SOF%d has %d color components. Ignoring Adobe App14 marker.", sOFSegment.marker & 0xF, sOFSegment.componentsInFrame()));
            object6 = iIOMetadataNode.getElementsByTagName("app14Adobe");
            for (int i = object6.getLength() - 1; i >= 0; --i) {
                Node iIOInvalidTreeException = object6.item(i);
                iIOInvalidTreeException.getParentNode().removeChild(iIOInvalidTreeException);
            }
        }
        object6 = null;
        for (JPEGSegment jPEGSegment : list) {
            if (jPEGSegment.marker() == 65504 && "JFIF".equals(jPEGSegment.identifier()) && bl || jPEGSegment.marker() == 65504 && "JFXX".equals(jPEGSegment.identifier()) && bl2 || jPEGSegment.marker() == 65505 && "Exif".equals(jPEGSegment.identifier()) || jPEGSegment.marker() == 65506 && "ICC_PROFILE".equals(jPEGSegment.identifier()) && bl3 || jPEGSegment.marker() == 65518 && "Adobe".equals(jPEGSegment.identifier())) continue;
            object4 = new IIOMetadataNode("unknown");
            ((IIOMetadataNode)object4).setAttribute("MarkerTag", Integer.toString(jPEGSegment.marker() & 0xFF));
            object3 = new DataInputStream(jPEGSegment.data());
            try {
                object2 = jPEGSegment.identifier();
                int n = object2 != null ? ((String)object2).length() + 1 : 0;
                object = new byte[n + jPEGSegment.length()];
                if (object2 != null) {
                    System.arraycopy(((String)object2).getBytes(Charset.forName("ASCII")), 0, object, 0, ((String)object2).length());
                }
                ((DataInputStream)object3).readFully((byte[])object, n, jPEGSegment.length());
                ((IIOMetadataNode)object4).setUserObject(object);
            }
            finally {
                ((FilterInputStream)object3).close();
            }
            if (object6 == null) {
                object2 = iIOMetadataNode3.getElementsByTagName("unknown");
                object6 = object2.getLength() > 0 ? object2.item(object2.getLength() - 1).getNextSibling() : iIOMetadataNode3.getFirstChild();
            }
            iIOMetadataNode3.insertBefore((Node)object4, (Node)object6);
        }
        NodeList nodeList = iIOMetadataNode3.getElementsByTagName("dht");
        boolean bl4 = false;
        while (var16_24 < nodeList.getLength()) {
            object4 = nodeList.item((int)var16_24);
            object3 = object4.getChildNodes();
            if (object3.getLength() > 4) {
                object2 = new IIOMetadataNode("dht");
                object4.getParentNode().insertBefore((Node)object2, object4.getNextSibling());
                for (int i = 0; i < object3.getLength(); ++i) {
                    object = (Element)object3.item(i);
                    String string = object.getAttribute("class");
                    if (!"1".equals(string)) continue;
                    object4.removeChild((Node)object);
                    ((IIOMetadataNode)object2).appendChild((Node)object);
                }
            }
            ++var16_24;
        }
        try {
            iIOMetadata.setFromTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            if (JPEGImageReader.DEBUG) {
                new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize((Node)iIOMetadataNode, false);
            }
            throw iIOInvalidTreeException;
        }
        return iIOMetadata;
    }
}

