/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ImageInputStream stream;
    private ByteBuffer buffer;

    public BufferedImageInputStream(ImageInputStream imageInputStream) throws IOException {
        this(imageInputStream, 8192);
    }

    private BufferedImageInputStream(ImageInputStream imageInputStream, int n) throws IOException {
        this.stream = (ImageInputStream)Validate.notNull((Object)imageInputStream, (String)"stream");
        this.streamPos = imageInputStream.getStreamPosition();
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.limit(0);
    }

    private void fillBuffer() throws IOException {
        this.buffer.clear();
        int n = this.stream.read(this.buffer.array(), 0, this.buffer.capacity());
        if (n >= 0) {
            try {
                this.buffer.position(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("length: " + n);
                throw illegalArgumentException;
            }
            this.buffer.flip();
        } else {
            this.buffer.limit(0);
        }
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.fillBuffer();
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.buffer.get() & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.bitOffset = 0;
        if (!this.buffer.hasRemaining()) {
            if (n2 >= this.buffer.capacity()) {
                return this.readDirect(byArray, n, n2);
            }
            this.fillBuffer();
        }
        return this.readBuffered(byArray, n, n2);
    }

    private int readDirect(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.stream.read(byArray, n, Math.min(this.buffer.capacity(), n2));
        if (n3 > 0) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    private int readBuffered(byte[] byArray, int n, int n2) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int n3 = Math.min(this.buffer.remaining(), n2);
        if (n3 > 0) {
            int n4 = this.buffer.position();
            System.arraycopy(this.buffer.array(), n4, byArray, n, n3);
            this.buffer.position(n4 + n3);
        }
        this.streamPos += (long)n3;
        return n3;
    }

    public void seek(long l) throws IOException {
        this.stream.seek(l);
        this.buffer.limit(0);
        this.streamPos = this.stream.getStreamPosition();
    }

    public void flushBefore(long l) throws IOException {
        this.stream.flushBefore(l);
    }

    public long getFlushedPosition() {
        return this.stream.getFlushedPosition();
    }

    public boolean isCached() {
        return this.stream.isCached();
    }

    public boolean isCachedMemory() {
        return this.stream.isCachedMemory();
    }

    public boolean isCachedFile() {
        return this.stream.isCachedFile();
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream = null;
            this.buffer = null;
        }
        super.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long length() {
        try {
            return this.stream.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

