/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public final class PDCalGray
extends PDCIEDictionaryBasedColorSpace {
    private final PDColor initialColor = new PDColor(new float[]{0.0f}, (PDColorSpace)this);

    public PDCalGray() {
        super(COSName.CALGRAY);
    }

    public PDCalGray(COSArray array) {
        super(array);
    }

    @Override
    public String getName() {
        return COSName.CALGRAY.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        float a = value[0];
        float gamma = this.getGamma();
        double powAG = Math.pow(a, gamma);
        float x = (float)((double)this.wpX * powAG);
        float y = (float)((double)this.wpY * powAG);
        float z = (float)((double)this.wpZ * powAG);
        return this.convXYZtoRGB(x, y, z);
    }

    public float getGamma() {
        float retval = 1.0f;
        COSNumber gamma = (COSNumber)this.dictionary.getDictionaryObject(COSName.GAMMA);
        if (gamma != null) {
            retval = gamma.floatValue();
        }
        return retval;
    }

    public void setGamma(float value) {
        this.dictionary.setItem(COSName.GAMMA, (COSBase)new COSFloat(value));
    }
}

