/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.CIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;
import org.apache.pdfbox.util.Charsets;

final class FileSystemFontProvider
extends FontProvider {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final FontCache cache;

    FileSystemFontProvider(FontCache cache) {
        List<FSFontInfo> cachedInfos;
        this.cache = cache;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Will search the local system for fonts");
        }
        ArrayList<File> files = new ArrayList<File>();
        FontFileFinder fontFileFinder = new FontFileFinder();
        List fonts = fontFileFinder.find();
        for (URI font : fonts) {
            files.add(new File(font));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + files.size() + " fonts on the local system"));
        }
        if ((cachedInfos = this.loadCache(files)) != null && cachedInfos.size() > 0) {
            this.fontInfoList.addAll(cachedInfos);
        } else {
            LOG.warn((Object)"Building font cache, this may take a while");
            this.scanFonts(files);
            this.saveCache();
        }
    }

    private void scanFonts(List<File> files) {
        for (File file : files) {
            try {
                if (file.getPath().toLowerCase().endsWith(".ttf") || file.getPath().toLowerCase().endsWith(".otf")) {
                    this.addTrueTypeFont(file);
                    continue;
                }
                if (file.getPath().toLowerCase().endsWith(".ttc") || file.getPath().toLowerCase().endsWith(".otc")) {
                    this.addTrueTypeCollection(file);
                    continue;
                }
                if (!file.getPath().toLowerCase().endsWith(".pfb")) continue;
                this.addType1Font(file);
            }
            catch (IOException e) {
                LOG.error((Object)("Error parsing font " + file.getPath()), (Throwable)e);
            }
        }
    }

    private void saveCache() {
        Preferences prefs = Preferences.userNodeForPackage(FileSystemFontProvider.class);
        try {
            for (FSFontInfo fontInfo : this.fontInfoList) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(fontInfo);
                prefs.putByteArray(fontInfo.file.getAbsolutePath(), byteOut.toByteArray());
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not write to font cache", (Throwable)e);
        }
        LOG.warn((Object)("Finished building font cache, found " + this.fontInfoList.size() + " fonts"));
    }

    private List<FSFontInfo> loadCache(List<File> files) {
        Preferences prefs = Preferences.userNodeForPackage(FileSystemFontProvider.class);
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        for (File file : files) {
            byte[] stored = prefs.getByteArray(file.getAbsolutePath(), null);
            if (stored != null) {
                try {
                    ByteArrayInputStream byteIn = new ByteArrayInputStream(stored);
                    ObjectInputStream objectIn = new ObjectInputStream(byteIn);
                    Object object = objectIn.readObject();
                    if (!(object instanceof FSFontInfo)) continue;
                    FSFontInfo info = (FSFontInfo)object;
                    info.parent = this;
                    results.add(info);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Error loading font cache, will be re-built", (Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    LOG.error((Object)"Error loading font cache, will be re-built", (Throwable)e);
                    return null;
                }
            }
            LOG.warn((Object)"New fonts found, font cache will be re-built");
            return null;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeCollection(File ttcFile) throws IOException {
        TrueTypeCollection ttc = null;
        try {
            ttc = new TrueTypeCollection(ttcFile);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                this.addTrueTypeFontImpl(ttf, ttcFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + ttcFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + ttcFile), (Throwable)e);
        }
        finally {
            if (ttc != null) {
                ttc.close();
            }
        }
    }

    private void addTrueTypeFont(File ttfFile) throws IOException {
        try {
            if (ttfFile.getPath().endsWith(".otf")) {
                OTFParser parser = new OTFParser(false, true);
                OpenTypeFont otf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl((TrueTypeFont)otf, ttfFile);
            } else {
                TTFParser parser = new TTFParser(false, true);
                TrueTypeFont ttf = parser.parse(ttfFile);
                this.addTrueTypeFontImpl(ttf, ttfFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + ttfFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + ttfFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file) throws IOException {
        try {
            if (ttf.getName() != null) {
                NamingTable name;
                String format;
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                if (ttf.getOS2Windows() != null) {
                    sFamilyClass = ttf.getOS2Windows().getFamilyClass();
                    usWeightClass = ttf.getOS2Windows().getWeightClass();
                    ulCodePageRange1 = (int)ttf.getOS2Windows().getCodePageRange1();
                    ulCodePageRange2 = (int)ttf.getOS2Windows().getCodePageRange2();
                    panose = ttf.getOS2Windows().getPanose();
                }
                if (ttf.getHeader() == null) {
                    this.fontInfoList.add(new FSIgnored(file, FontFormat.TTF, ttf.getName()));
                    return;
                }
                int macStyle = ttf.getHeader().getMacStyle();
                if (ttf instanceof OpenTypeFont && ((OpenTypeFont)ttf).isPostScript()) {
                    format = "OTF";
                    CFFFont cff = ((OpenTypeFont)ttf).getCFF().getFont();
                    CIDSystemInfo ros = null;
                    if (cff instanceof CFFCIDFont) {
                        CFFCIDFont cidFont = (CFFCIDFont)cff;
                        String registry = cidFont.getRegistry();
                        String ordering = cidFont.getOrdering();
                        int supplement = cidFont.getSupplement();
                        ros = new CIDSystemInfo(registry, ordering, supplement);
                    }
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.OTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                } else {
                    CIDSystemInfo ros = null;
                    if (ttf.getTableMap().containsKey("gcid")) {
                        byte[] bytes = ttf.getTableBytes((TTFTable)ttf.getTableMap().get("gcid"));
                        String registryName = new String(bytes, 10, 64, Charsets.US_ASCII).trim();
                        String orderName = new String(bytes, 76, 64, Charsets.US_ASCII).trim();
                        int supplementVersion = bytes[140] << 8 & bytes[141];
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = "TTF";
                    this.fontInfoList.add(new FSFontInfo(file, FontFormat.TTF, ttf.getName(), ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this));
                }
                if (LOG.isTraceEnabled() && (name = ttf.getNaming()) != null) {
                    LOG.trace((Object)(format + ": '" + name.getPostScriptName() + "' / '" + name.getFontFamily() + "' / '" + name.getFontSubFamily() + "'"));
                }
            } else {
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + file));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        FileInputStream input = new FileInputStream(pfbFile);
        try {
            Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
            this.fontInfoList.add(new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), null, -1, -1, 0, 0, -1, null, this));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + pfbFile), (Throwable)e);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
        try {
            TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
            }
            return ttf;
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
        }
        return null;
    }

    private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".ttc")) {
            TrueTypeCollection ttc = new TrueTypeCollection(file);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                if (!ttf.getName().equals(postScriptName)) continue;
                return ttf;
            }
            throw new IOException("Font " + postScriptName + " not found in " + file);
        }
        TTFParser ttfParser = new TTFParser(false, true);
        return ttfParser.parse(file);
    }

    private OpenTypeFont getOTFFont(String postScriptName, File file) {
        try {
            OTFParser parser = new OTFParser(false, true);
            OpenTypeFont otf = parser.parse(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
            }
            return otf;
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type1Font getType1Font(String postScriptName, File file) {
        Type1Font type1Font;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
            }
            type1Font = type1;
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
            return null;
        }
        IOUtils.closeQuietly(input);
        return type1Font;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    private static final class FSIgnored
    extends FSFontInfo
    implements Serializable {
        private FSIgnored(File file, FontFormat format, String postScriptName) {
            super(file, format, postScriptName, null, 0, 0, 0, 0, 0, null, null);
        }
    }

    private static class FSFontInfo
    extends FontInfo
    implements Serializable {
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private transient FileSystemFontProvider parent;

        private FSFontInfo(File file, FontFormat format, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent) {
            this.file = file;
            this.format = format;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public FontBoxFont getFont() {
            Type1Font font;
            FontBoxFont cached = this.parent.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = this.parent.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = this.parent.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.parent.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            this.parent.cache.addFont(this, (FontBoxFont)font);
            return font;
        }

        @Override
        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        @Override
        public int getWeightClass() {
            return this.usWeightClass;
        }

        @Override
        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        @Override
        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        @Override
        public int getMacStyle() {
            return this.macStyle;
        }

        @Override
        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file;
        }
    }
}

