/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SRVRecord
implements Serializable {
    private static final long serialVersionUID = -5505867807717870889L;
    private final int port;
    private final long priority;
    private final long weight;
    private final String address;
    private final String recordString;

    SRVRecord(String recordString) throws LDAPException {
        this.recordString = recordString;
        try {
            StringTokenizer tokenizer = new StringTokenizer(recordString, " ");
            this.priority = Long.parseLong(tokenizer.nextToken());
            this.weight = Long.parseLong(tokenizer.nextToken());
            this.port = Integer.parseInt(tokenizer.nextToken());
            String addrString = tokenizer.nextToken();
            this.address = addrString.endsWith(".") ? addrString.substring(0, addrString.length() - 1) : addrString;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SRV_RECORD_MALFORMED_STRING.get(recordString, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public long getPriority() {
        return this.priority;
    }

    public long getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.recordString;
    }
}

