/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.ConfigurationImpl;
import com.franciaflex.faxtomail.persistence.entities.ConfigurationTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountImpl;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.GroupChef;
import com.franciaflex.faxtomail.persistence.entities.GroupChefTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ConfigurationService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(ConfigurationService.class);

    public Configuration getConfiguration() {
        ConfigurationTopiaDao dao = this.getPersistenceContext().getConfigurationDao();
        Configuration config = (Configuration)dao.forAll().findUniqueOrNull();
        if (config == null) {
            config = new ConfigurationImpl();
        }
        return config;
    }

    public void saveConfiguration(Configuration config) {
        ConfigurationTopiaDao dao = this.getPersistenceContext().getConfigurationDao();
        config = config.isPersisted() ? (Configuration)dao.update((TopiaEntity)config) : (Configuration)dao.create((TopiaEntity)config);
        this.getPersistenceContext().commit();
    }

    public List<MailFilter> getMailFilters() {
        MailFilterTopiaDao mailFilterDao = this.getPersistenceContext().getMailFilterDao();
        List result = mailFilterDao.forAll().setOrderByArguments(new String[]{"position asc"}).findAll();
        return result;
    }

    public void saveMailFilters(List<MailFilter> mailFilters) {
        MailFilterTopiaDao dao = this.getPersistenceContext().getMailFilterDao();
        int position = 0;
        List filters = dao.findAll();
        HashMap filterById = new HashMap(Maps.uniqueIndex((Iterable)filters, (Function)TopiaEntities.getTopiaIdFunction()));
        for (MailFilter mailFilter : mailFilters) {
            boolean create = mailFilter.getTopiaId() == null;
            MailFilter filter = create ? (MailFilter)dao.newInstance() : (MailFilter)filterById.remove(mailFilter.getTopiaId());
            filter.setExpression(mailFilter.getExpression());
            filter.setMailFolder(mailFilter.getMailFolder());
            filter.setPosition(position);
            filter = create ? (MailFilter)dao.create((TopiaEntity)filter) : (MailFilter)dao.update((TopiaEntity)filter);
            ++position;
        }
        dao.deleteAll(filterById.values());
        this.getPersistenceContext().commit();
    }

    public List<EmailAccount> getEmailAccountsWithoutPasswords() {
        List<EmailAccount> accounts = this.getEmailAccounts();
        final Binder binderEmailAccount = BinderFactory.newBinder(EmailAccount.class);
        List result = Lists.transform(accounts, (Function)new Function<EmailAccount, EmailAccount>(){

            public EmailAccount apply(EmailAccount input) {
                EmailAccountImpl account = new EmailAccountImpl();
                binderEmailAccount.copyExcluding((Object)input, (Object)account, new String[]{"password"});
                return account;
            }
        });
        return result;
    }

    public List<EmailAccount> getEmailAccounts() {
        EmailAccountTopiaDao emailAccountTopiaDao = this.getPersistenceContext().getEmailAccountDao();
        List result = emailAccountTopiaDao.findAll();
        return result;
    }

    public void saveEmailAccounts(List<EmailAccount> newEmailAccounts) {
        EmailAccountTopiaDao emailAccountTopiaDao = this.getPersistenceContext().getEmailAccountDao();
        List emailAccounts = emailAccountTopiaDao.findAll();
        HashMap emailAccountMap = new HashMap(Maps.uniqueIndex((Iterable)emailAccounts, (Function)TopiaEntities.getTopiaIdFunction()));
        Binder binder = BinderFactory.newBinder(EmailAccount.class);
        for (EmailAccount newEmailAccount : newEmailAccounts) {
            Object emailAccount = StringUtils.isNotBlank((CharSequence)newEmailAccount.getTopiaId()) ? (EmailAccount)emailAccountMap.remove(newEmailAccount.getTopiaId()) : new EmailAccountImpl();
            binder.copyExcluding((Object)newEmailAccount, emailAccount, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "password"});
            if (StringUtils.isNotEmpty((CharSequence)newEmailAccount.getPassword())) {
                emailAccount.setPassword(newEmailAccount.getPassword());
            }
            if (emailAccount.isPersisted()) {
                emailAccountTopiaDao.update((TopiaEntity)emailAccount);
                continue;
            }
            emailAccountTopiaDao.create((TopiaEntity)emailAccount);
        }
        emailAccountTopiaDao.deleteAll(emailAccountMap.values());
        this.getPersistenceContext().commit();
    }

    public List<FaxToMailUser> getAllUsers() {
        FaxToMailUserTopiaDao faxToMailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        return faxToMailUserDao.forAll().setOrderByArguments(new String[]{"firstName", "lastName"}).find(0, 50);
    }

    public void saveUserFolders(Map<String, Collection<MailFolder>> userFolders) {
        log.warn((Object)("user folders = " + userFolders));
        FaxToMailUserTopiaDao faxToMailUserTopiaDao = this.getPersistenceContext().getFaxToMailUserDao();
        for (Map.Entry<String, Collection<MailFolder>> entry : userFolders.entrySet()) {
            String userId = entry.getKey();
            Collection<MailFolder> mailFolders = entry.getValue();
            FaxToMailUser user = (FaxToMailUser)faxToMailUserTopiaDao.findByTopiaId(userId);
            user.clearAffectedFolders();
            for (MailFolder mailFolder : mailFolders) {
                user.addAffectedFolders(mailFolder);
            }
            faxToMailUserTopiaDao.update((TopiaEntity)user);
        }
        this.getPersistenceContext().commit();
    }

    public List<FaxToMailUserGroup> getAllGroups() {
        FaxToMailUserGroupTopiaDao faxToMailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        return faxToMailUserGroupDao.forAll().setOrderByArguments(new String[]{"fullPath"}).findAll();
    }

    public List<FaxToMailUser> getUserManagedUsers(FaxToMailUser user) {
        ArrayList<FaxToMailUser> result = new ArrayList<FaxToMailUser>();
        if (user.getUserGroups() != null) {
            GroupChefTopiaDao groupChefTopiaDao = this.getPersistenceContext().getGroupChefDao();
            List groupChefs = groupChefTopiaDao.forUserGroupIn(user.getUserGroups()).findAll();
            FaxToMailUserTopiaDao faxToMailUserTopiaDao = this.getPersistenceContext().getFaxToMailUserDao();
            for (GroupChef groupChef : groupChefs) {
                if (groupChef.getManagedGroups() != null) {
                    for (FaxToMailUserGroup group : groupChef.getManagedGroups()) {
                        List users = faxToMailUserTopiaDao.forUserGroupsContains(group).findAll();
                        result.addAll(users);
                    }
                }
                if (groupChef.getManagedUsers() == null) continue;
                result.addAll(groupChef.getManagedUsers());
            }
        }
        return result;
    }
}

