/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import java.text.DateFormat;
import java.util.Date;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

public class DecoratorService
extends FaxToMailServiceSupport {
    public static final String SEPARATOR = "#";
    public static final String DATE = "date";
    protected DecoratorProvider decoratorProvider;

    public <O> Decorator<O> getDecorator(O object) {
        return this.decoratorProvider.getDecorator(object);
    }

    public <O> Decorator<O> getDecorator(O object, String name) {
        return this.decoratorProvider.getDecorator(object, name);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type) {
        return this.decoratorProvider.getDecoratorByType(type);
    }

    public <O> Decorator<O> getDecoratorByType(Class<O> type, String name) {
        return this.decoratorProvider.getDecoratorByType(type, name);
    }

    @Override
    public void setServiceContext(FaxToMailServiceContext context) {
        super.setServiceContext(context);
        this.decoratorProvider = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerDecorator((Decorator)new Decorator<Float>(Float.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        return bean == null ? "" : String.valueOf(bean);
                    }
                });
                this.registerDecorator((Decorator)new Decorator<Number>(Number.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        return bean == null ? "" : String.valueOf(bean);
                    }
                });
                this.registerDecorator((Decorator)new Decorator<Date>(Date.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return DateFormat.getDateTimeInstance(3, 3).format(bean);
                    }
                });
                this.registerDecorator(DecoratorService.DATE, (Decorator)new Decorator<Date>(Date.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return DateFormat.getDateInstance(2).format(bean);
                    }
                });
                this.registerMultiJXPathDecorator(HasLabel.class, "${label}$s", DecoratorService.SEPARATOR, " - ");
                this.registerDecorator((Decorator)new Decorator<Attachment>(Attachment.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((Attachment)bean).getOriginalFile().getFilename();
                    }
                });
                this.registerDecorator((Decorator)new Decorator<AttachmentFile>(AttachmentFile.class){
                    private static final long serialVersionUID = 1L;

                    public String toString(Object bean) {
                        if (bean == null) {
                            return "";
                        }
                        return ((AttachmentFile)bean).getFilename();
                    }
                });
                this.registerMultiJXPathDecorator(Reply.class, "${sentDate}$s#${subject}$s", DecoratorService.SEPARATOR, " - ");
                this.registerMultiJXPathDecorator(FaxToMailUser.class, "${trigraph}$s#${firstName}$s#${lastName}$s", DecoratorService.SEPARATOR, " ");
            }
        };
    }
}

