/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum SSLMessages {
    ERR_CERTIFICATE_REJECTED_BY_USER("The user rejected the provided certificate."),
    ERR_HOSTNAME_NOT_FOUND("The presented certificate ''{0}'' did not contain any of the acceptable addresses in the CN subject attribute or in a subjectAltName extension."),
    ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for key store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_KEYSTORE_CANNOT_LOAD("Unable to load key store ''{0}'' of type ''{1}'':  {2}"),
    ERR_KEYSTORE_NO_SUCH_FILE("Key store file ''{0}'' does not exist."),
    ERR_PKCS11_CANNOT_ACCESS("Unable to access the PKCS#11 key store:  {0}"),
    ERR_PKCS11_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for the PKCS#11 key store:  {0}"),
    ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS("Unable to obtain trust managers for trust store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_TRUSTSTORE_CANNOT_LOAD("Unable to load trust store ''{0}'' of type ''{1}'':  {2}"),
    ERR_TRUSTSTORE_NO_SUCH_FILE("Trust store file ''{0}'' does not exist."),
    ERR_TRUSTSTORE_UNSUPPORTED_FORMAT("Unsupported trust store format ''{0}''."),
    ERR_VALIDITY_TOO_EARLY("The presented certificate ''{0}'' will not be valid until {1}."),
    ERR_VALIDITY_TOO_LATE("The presented certificate ''{0}'' expired on {1}."),
    INFO_PROMPT_CLIENT_HEADING("The client presented the following certificate:"),
    INFO_PROMPT_ISSUER_SUBJECT("Issuer[{0,number,0}] Subject:  {1}"),
    INFO_PROMPT_MD5_FINGERPRINT("MD5 Fingerprint:  {0}"),
    INFO_PROMPT_MESSAGE("Do you wish to trust this certificate?  Enter 'y' or 'n': "),
    INFO_PROMPT_SERVER_HEADING("The server presented the following certificate:"),
    INFO_PROMPT_SHA1_FINGERPRINT("SHA-1 Fingerprint:  {0}"),
    INFO_PROMPT_SUBJECT("Subject:  {0}"),
    INFO_PROMPT_VALIDITY("The certificate is valid from {0} to {1}."),
    WARN_PROMPT_EXPIRED("WARNING:  This certificate is expired."),
    WARN_PROMPT_NOT_YET_VALID("WARNING:  The current time is before the certificate validity start date."),
    WARN_PROMPT_SELF_SIGNED("WARNING:  The certificate is self-signed.");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<SSLMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<SSLMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private SSLMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                s = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception e) {
                s = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-ssl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

