/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentParser
implements Serializable {
    private static final long serialVersionUID = 361008526269946465L;
    private final int maxTrailingArgs;
    private final LinkedHashMap<Character, Argument> namedArgsByShortID;
    private final LinkedHashMap<String, Argument> namedArgsByLongID;
    private final List<Argument> namedArgs;
    private final List<ObjectPair<Argument, Set<Argument>>> dependentArgumentSets;
    private final List<Set<Argument>> exclusiveArgumentSets;
    private final List<Set<Argument>> requiredArgumentSets;
    private final List<String> trailingArgs;
    private final String commandDescription;
    private final String commandName;
    private final String trailingArgsPlaceholder;

    public ArgumentParser(String commandName, String commandDescription) throws ArgumentException {
        this(commandName, commandDescription, 0, null);
    }

    public ArgumentParser(String commandName, String commandDescription, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        if (commandName == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_NAME_NULL.get());
        }
        if (commandDescription == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_DESCRIPTION_NULL.get());
        }
        if (maxTrailingArgs != 0 && trailingArgsPlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_PLACEHOLDER_NULL.get());
        }
        this.commandName = commandName;
        this.commandDescription = commandDescription;
        this.trailingArgsPlaceholder = trailingArgsPlaceholder;
        this.maxTrailingArgs = maxTrailingArgs >= 0 ? maxTrailingArgs : Integer.MAX_VALUE;
        this.namedArgsByShortID = new LinkedHashMap();
        this.namedArgsByLongID = new LinkedHashMap();
        this.namedArgs = new ArrayList<Argument>();
        this.trailingArgs = new ArrayList<String>();
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>();
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>();
        this.requiredArgumentSets = new ArrayList<Set<Argument>>();
    }

    private ArgumentParser(ArgumentParser source) {
        LinkedHashSet newSet;
        this.commandName = source.commandName;
        this.commandDescription = source.commandDescription;
        this.maxTrailingArgs = source.maxTrailingArgs;
        this.trailingArgsPlaceholder = source.trailingArgsPlaceholder;
        this.trailingArgs = new ArrayList<String>();
        this.namedArgs = new ArrayList<Argument>(source.namedArgs.size());
        this.namedArgsByLongID = new LinkedHashMap(source.namedArgsByLongID.size());
        this.namedArgsByShortID = new LinkedHashMap(source.namedArgsByShortID.size());
        LinkedHashMap<String, Argument> argsByID = new LinkedHashMap<String, Argument>(source.namedArgs.size());
        for (Argument argument : source.namedArgs) {
            Argument a = argument.getCleanCopy();
            try {
                a.setRegistered();
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
            }
            this.namedArgs.add(a);
            argsByID.put(a.getIdentifierString(), a);
            for (Character c : a.getShortIdentifiers()) {
                this.namedArgsByShortID.put(c, a);
            }
            for (String s : a.getLongIdentifiers()) {
                this.namedArgsByLongID.put(StaticUtils.toLowerCase(s), a);
            }
        }
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>(source.dependentArgumentSets.size());
        for (ObjectPair objectPair : source.dependentArgumentSets) {
            Set sourceSet = (Set)objectPair.getSecond();
            LinkedHashSet newSet2 = new LinkedHashSet(sourceSet.size());
            for (Argument a : sourceSet) {
                newSet2.add(argsByID.get(a.getIdentifierString()));
            }
            Argument sourceFirst = (Argument)objectPair.getFirst();
            Argument newFirst = (Argument)argsByID.get(sourceFirst.getIdentifierString());
            this.dependentArgumentSets.add(new ObjectPair(newFirst, newSet2));
        }
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>(source.exclusiveArgumentSets.size());
        for (Set set : source.exclusiveArgumentSets) {
            newSet = new LinkedHashSet(set.size());
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.exclusiveArgumentSets.add(newSet);
        }
        this.requiredArgumentSets = new ArrayList<Set<Argument>>(source.requiredArgumentSets.size());
        for (Set set : source.requiredArgumentSets) {
            newSet = new LinkedHashSet(set.size());
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.requiredArgumentSets.add(newSet);
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public boolean allowsTrailingArguments() {
        return this.maxTrailingArgs != 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return this.trailingArgsPlaceholder;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArgs;
    }

    public Argument getNamedArgument(Character shortIdentifier) {
        Validator.ensureNotNull(shortIdentifier);
        return this.namedArgsByShortID.get(shortIdentifier);
    }

    public Argument getNamedArgument(String longIdentifier) {
        Validator.ensureNotNull(longIdentifier);
        return this.namedArgsByLongID.get(StaticUtils.toLowerCase(longIdentifier));
    }

    public List<Argument> getNamedArguments() {
        return Collections.unmodifiableList(this.namedArgs);
    }

    public void addArgument(Argument argument) throws ArgumentException {
        argument.setRegistered();
        for (Character c : argument.getShortIdentifiers()) {
            if (!this.namedArgsByShortID.containsKey(c)) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ID_CONFLICT.get(c));
        }
        for (String s : argument.getLongIdentifiers()) {
            if (!this.namedArgsByLongID.containsKey(StaticUtils.toLowerCase(s))) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ID_CONFLICT.get(s));
        }
        for (Character c : argument.getShortIdentifiers()) {
            this.namedArgsByShortID.put(c, argument);
        }
        for (String s : argument.getLongIdentifiers()) {
            this.namedArgsByLongID.put(StaticUtils.toLowerCase(s), argument);
        }
        this.namedArgs.add(argument);
    }

    public List<ObjectPair<Argument, Set<Argument>>> getDependentArgumentSets() {
        return Collections.unmodifiableList(this.dependentArgumentSets);
    }

    public void addDependentArgumentSet(Argument targetArgument, Collection<Argument> dependentArguments) {
        Validator.ensureNotNull(targetArgument, dependentArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(dependentArguments);
        this.dependentArgumentSets.add(new ObjectPair<Argument, LinkedHashSet<Argument>>(targetArgument, argSet));
    }

    public void addDependentArgumentSet(Argument targetArgument, Argument dependentArg1, Argument ... remaining) {
        Validator.ensureNotNull(targetArgument, dependentArg1);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(dependentArg1);
        argSet.addAll(Arrays.asList(remaining));
        this.dependentArgumentSets.add(new ObjectPair(targetArgument, argSet));
    }

    public List<Set<Argument>> getExclusiveArgumentSets() {
        return Collections.unmodifiableList(this.exclusiveArgumentSets);
    }

    public void addExclusiveArgumentSet(Collection<Argument> exclusiveArguments) {
        Validator.ensureNotNull(exclusiveArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(exclusiveArguments);
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addExclusiveArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(arg1);
        argSet.add(arg2);
        argSet.addAll(Arrays.asList(remaining));
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public List<Set<Argument>> getRequiredArgumentSets() {
        return Collections.unmodifiableList(this.requiredArgumentSets);
    }

    public void addRequiredArgumentSet(Collection<Argument> requiredArguments) {
        Validator.ensureNotNull(requiredArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(requiredArguments);
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addRequiredArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(arg1);
        argSet.add(arg2);
        argSet.addAll(Arrays.asList(remaining));
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public List<String> getTrailingArguments() {
        return Collections.unmodifiableList(this.trailingArgs);
    }

    public ArgumentParser getCleanCopy() {
        return new ArgumentParser(this);
    }

    public void parse(String[] args) throws ArgumentException {
        boolean inTrailingArgs = false;
        boolean usageArgProvided = false;
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (inTrailingArgs) {
                if (this.maxTrailingArgs == 0) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(string, this.commandName));
                }
                if (this.trailingArgs.size() >= this.maxTrailingArgs) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TOO_MANY_TRAILING_ARGS.get(string, this.commandName, this.maxTrailingArgs));
                }
                this.trailingArgs.add(string);
                continue;
            }
            if (string.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (string.startsWith("--")) {
                int equalPos = string.indexOf(61);
                String argName = equalPos > 0 ? string.substring(2, equalPos) : string.substring(2);
                Argument a = this.namedArgsByLongID.get(StaticUtils.toLowerCase(argName));
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_LONG_ID.get(argName));
                }
                if (a.isUsageArgument()) {
                    usageArgProvided = true;
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    if (equalPos > 0) {
                        a.addValue(string.substring(equalPos + 1));
                        continue;
                    }
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_MISSING_VALUE.get(argName));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                if (equalPos <= 0) continue;
                throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_DOESNT_TAKE_VALUE.get(argName));
            }
            if (string.startsWith("-")) {
                if (string.length() == 1) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_UNEXPECTED_DASH.get());
                }
                if (string.length() == 2) {
                    char c = string.charAt(1);
                    Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                    }
                    if (a.isUsageArgument()) {
                        usageArgProvided = true;
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ARG_MISSING_VALUE.get(Character.valueOf(c)));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                char c = string.charAt(1);
                Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                }
                if (a.isUsageArgument()) {
                    usageArgProvided = true;
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    a.addValue(string.substring(2));
                    continue;
                }
                for (int j = 2; j < string.length(); ++j) {
                    c = string.charAt(j);
                    a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUBSEQUENT_SHORT_ARG.get(Character.valueOf(c), string));
                    }
                    if (a.isUsageArgument()) {
                        usageArgProvided = true;
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_SUBSEQUENT_SHORT_ARG_TAKES_VALUE.get(Character.valueOf(c), string));
                }
                continue;
            }
            inTrailingArgs = true;
            if (this.maxTrailingArgs == 0) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(string, this.commandName));
            }
            this.trailingArgs.add(string);
        }
        if (usageArgProvided) {
            return;
        }
        for (Argument argument : this.namedArgs) {
            if (!argument.isRequired() || argument.isPresent()) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_MISSING_REQUIRED_ARG.get(argument.getIdentifierString()));
        }
        for (ObjectPair objectPair : this.dependentArgumentSets) {
            Argument targetArg = (Argument)objectPair.getFirst();
            if (!targetArg.isPresent()) continue;
            Set argSet = (Set)objectPair.getSecond();
            boolean found = false;
            for (Argument a : argSet) {
                if (!a.isPresent()) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (argSet.size() == 1) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_SINGLE.get(targetArg.getIdentifierString(), ((Argument)argSet.iterator().next()).getIdentifierString()));
            }
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : argSet) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_MULTIPLE.get(targetArg.getIdentifierString(), buffer.toString()));
        }
        for (Set set : this.exclusiveArgumentSets) {
            Argument setArg = null;
            for (Argument a : set) {
                if (!a.isPresent()) continue;
                if (setArg == null) {
                    setArg = a;
                    continue;
                }
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(setArg.getIdentifierString(), a.getIdentifierString()));
            }
        }
        for (Set set : this.requiredArgumentSets) {
            boolean found = false;
            for (Argument a : set) {
                if (!a.isPresent()) continue;
                found = true;
                break;
            }
            if (found) continue;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : set) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_REQUIRED_CONFLICT.get(buffer.toString()));
        }
    }

    public List<String> getUsage(int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(100);
        lines.addAll(StaticUtils.wrapLine(this.commandDescription, maxWidth));
        lines.add("");
        if (this.namedArgs.isEmpty()) {
            if (this.maxTrailingArgs == 0) {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_NOTRAILING.get(this.commandName), maxWidth));
            } else {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
            }
        } else {
            if (this.maxTrailingArgs == 0) {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_NOTRAILING.get(this.commandName), maxWidth));
            } else {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
            }
            lines.add("");
            lines.add(ArgsMessages.INFO_USAGE_OPTIONS_INCLUDE.get());
            for (Argument a : this.namedArgs) {
                if (a.isHidden()) continue;
                StringBuilder argLine = new StringBuilder();
                boolean first = true;
                for (Character c : a.getShortIdentifiers()) {
                    if (first) {
                        argLine.append('-');
                        first = false;
                    } else {
                        argLine.append(", -");
                    }
                    argLine.append(c);
                }
                for (String s : a.getLongIdentifiers()) {
                    if (first) {
                        argLine.append("--");
                    } else {
                        argLine.append(", --");
                    }
                    argLine.append(s);
                }
                String valuePlaceholder = a.getValuePlaceholder();
                if (valuePlaceholder != null) {
                    argLine.append(' ');
                    argLine.append(valuePlaceholder);
                }
                lines.add(argLine.toString());
                String description = a.getDescription();
                if (maxWidth > 10) {
                    List<String> descLines = StaticUtils.wrapLine(description, maxWidth - 4);
                    for (String s : descLines) {
                        lines.add("    " + s);
                    }
                    continue;
                }
                lines.addAll(StaticUtils.wrapLine(description, maxWidth));
            }
        }
        return lines;
    }

    public void getUsage(OutputStream outputStream, int maxWidth) throws IOException {
        List<String> usageLines = this.getUsage(maxWidth);
        for (String s : usageLines) {
            outputStream.write(StaticUtils.getBytes(s));
            outputStream.write(StaticUtils.EOL_BYTES);
        }
    }

    public String getUsageString(int maxWidth) {
        StringBuilder buffer = new StringBuilder();
        this.getUsageString(buffer, maxWidth);
        return buffer.toString();
    }

    public void getUsageString(StringBuilder buffer, int maxWidth) {
        for (String line : this.getUsage(maxWidth)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ArgumentParser(commandName='");
        buffer.append(this.commandName);
        buffer.append("', commandDescription='");
        buffer.append(this.commandDescription);
        buffer.append("', maxTrailingArgs=");
        buffer.append(this.maxTrailingArgs);
        if (this.trailingArgsPlaceholder != null) {
            buffer.append(", trailingArgsPlaceholder='");
            buffer.append(this.trailingArgsPlaceholder);
            buffer.append('\'');
        }
        buffer.append("namedArgs={");
        Iterator<Argument> iterator = this.namedArgs.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

