/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ParallelPoolConnectorTask;
import com.unboundid.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParallelPoolConnector {
    private final boolean throwOnConnectFailure;
    private final int numConnections;
    private final int numThreads;
    private final LDAPConnectionPool pool;
    private final List<LDAPConnection> connList;

    ParallelPoolConnector(LDAPConnectionPool pool, List<LDAPConnection> connList, int numConnections, int numThreads, boolean throwOnConnectFailure) {
        this.pool = pool;
        this.connList = connList;
        this.numConnections = numConnections;
        this.numThreads = numThreads;
        this.throwOnConnectFailure = throwOnConnectFailure;
    }

    void establishConnections() throws LDAPException {
        LDAPException le;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(this.numConnections);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 0L, TimeUnit.MILLISECONDS, queue);
        AtomicReference<LDAPException> firstException = new AtomicReference<LDAPException>();
        ArrayList results = new ArrayList(this.numConnections);
        for (int i = 0; i < this.numConnections; ++i) {
            results.add(executor.submit(new ParallelPoolConnectorTask(this.pool, this.connList, firstException, this.throwOnConnectFailure)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        executor.shutdown();
        if (this.throwOnConnectFailure && (le = firstException.get()) != null) {
            for (LDAPConnection c : this.connList) {
                c.terminate(null);
            }
            this.connList.clear();
            throw le;
        }
    }
}

