/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.GenericResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyResponseProtocolOp
extends GenericResponseProtocolOp {
    private static final long serialVersionUID = -6850364658234891786L;

    public ModifyResponseProtocolOp(int resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs) {
        super((byte)103, resultCode, matchedDN, diagnosticMessage, referralURLs);
    }

    public ModifyResponseProtocolOp(LDAPResult result) {
        super((byte)103, result.getResultCode().intValue(), result.getMatchedDN(), result.getDiagnosticMessage(), StaticUtils.toList(result.getReferralURLs()));
    }

    ModifyResponseProtocolOp(ASN1StreamReader reader) throws LDAPException {
        super(reader);
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1Enumerated(this.getResultCode()));
        String matchedDN = this.getMatchedDN();
        if (matchedDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(matchedDN));
        }
        String diagnosticMessage = this.getDiagnosticMessage();
        if (diagnosticMessage == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(diagnosticMessage));
        }
        List<String> referralURLs = this.getReferralURLs();
        if (!referralURLs.isEmpty()) {
            ArrayList<ASN1OctetString> refElements = new ArrayList<ASN1OctetString>(referralURLs.size());
            for (String r : referralURLs) {
                refElements.add(new ASN1OctetString(r));
            }
            elements.add(new ASN1Sequence(-93, refElements));
        }
        return new ASN1Sequence(103, elements);
    }

    public static ModifyResponseProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ArrayList<String> referralURLs;
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            int resultCode = ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue();
            String md = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            String matchedDN = md.length() > 0 ? md : null;
            String dm = ASN1OctetString.decodeAsOctetString(elements[2]).stringValue();
            String diagnosticMessage = dm.length() > 0 ? dm : null;
            if (elements.length == 4) {
                ASN1Element[] refElements = ASN1Sequence.decodeAsSequence(elements[3]).elements();
                referralURLs = new ArrayList<String>(refElements.length);
                for (ASN1Element e : refElements) {
                    referralURLs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                }
            } else {
                referralURLs = null;
            }
            return new ModifyResponseProtocolOp(resultCode, matchedDN, diagnosticMessage, referralURLs);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

