/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

public class ReplyFormUIModel
extends AbstractSerializableBean {
    private static final Log log = LogFactory.getLog(ReplyFormUIModel.class);
    public static final String PROPERTY_TO = "to";
    public static final String PROPERTY_FROM = "from";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_ORIGINAL_DEMAND = "originalDemand";
    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_READONLY = "readonly";
    public static final String PROPERTY_MAX_ATTACHMENT_LENGTH = "maxAttachmentLength";
    public static final String PROPERTY_TOTAL_ATTACHMENT_LENGTH = "totalAttachmentLength";
    public static final String PROPERTY_VALID = "valid";
    public static final String PROPERTY_SENDER_ALLOWED_DOMAINS = "senderAllowedDomains";
    protected String to;
    protected String from;
    protected String subject;
    protected String message;
    protected DemandeUIModel originalDemand;
    protected long maxAttachmentLength = 0L;
    protected long totalAttachmentLength = 0L;
    protected boolean valid = true;
    protected boolean readonly = false;
    protected List<String> senderAllowedDomains;
    protected Set<AttachmentFile> attachments = new HashSet<AttachmentFile>();
    protected Set<AttachmentFile> availableAttachments = new HashSet<AttachmentFile>();
    protected File lastVisitedDirectory = FileUtils.getUserDirectory();

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        String oldValue = this.getTo();
        this.to = to;
        this.firePropertyChange(PROPERTY_TO, oldValue, to);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        String oldValue = this.getFrom();
        this.from = from;
        this.firePropertyChange(PROPERTY_FROM, oldValue, from);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        String oldValue = this.getSubject();
        this.subject = subject;
        this.firePropertyChange(PROPERTY_SUBJECT, oldValue, subject);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.getMessage();
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public DemandeUIModel getOriginalDemand() {
        return this.originalDemand;
    }

    public void setOriginalDemand(DemandeUIModel originalDemand) {
        DemandeUIModel oldValue = this.getOriginalDemand();
        this.originalDemand = originalDemand;
        this.firePropertyChange(PROPERTY_ORIGINAL_DEMAND, oldValue, originalDemand);
    }

    public Set<AttachmentFile> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(AttachmentFile attachment) {
        this.attachments.add(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        this.setTotalAttachmentLength(this.totalAttachmentLength + attachment.getLength());
    }

    public void removeAttachment(AttachmentFile attachment) {
        this.attachments.remove(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        this.setTotalAttachmentLength(this.totalAttachmentLength - attachment.getLength());
    }

    public Set<AttachmentFile> getAvailableAttachments() {
        return this.availableAttachments;
    }

    public void addAvailableAttachment(AttachmentFile attachment) {
        this.availableAttachments.add(attachment);
    }

    public void removeAvailableAttachment(AttachmentFile attachment) {
        this.availableAttachments.remove(attachment);
    }

    public File getLastVisitedDirectory() {
        return this.lastVisitedDirectory;
    }

    public void setLastVisitedDirectory(File lastVisitedDirectory) {
        this.lastVisitedDirectory = lastVisitedDirectory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        Boolean oldValue = this.isReadonly();
        this.readonly = readonly;
        this.firePropertyChange(PROPERTY_READONLY, oldValue, readonly);
    }

    public long getMaxAttachmentLength() {
        return this.maxAttachmentLength / 1024L;
    }

    public void setMaxAttachmentLength(long maxAttachmentLength) {
        Long oldValue = this.getMaxAttachmentLength();
        this.maxAttachmentLength = maxAttachmentLength;
        this.firePropertyChange(PROPERTY_MAX_ATTACHMENT_LENGTH, oldValue, maxAttachmentLength);
    }

    public long getTotalAttachmentLength() {
        return this.totalAttachmentLength / 1024L;
    }

    public void setTotalAttachmentLength(long totalAttachmentLength) {
        Long oldValue = this.getTotalAttachmentLength();
        this.totalAttachmentLength = totalAttachmentLength;
        this.firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGTH, oldValue, this.getTotalAttachmentLength());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        Boolean oldValue = this.isValid();
        this.valid = valid;
        this.firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public boolean isAttachmentSizeValid(long totalAttachmentLength) {
        return this.maxAttachmentLength == 0L || this.totalAttachmentLength < this.maxAttachmentLength;
    }

    public List<String> getSenderAllowedDomains() {
        return this.senderAllowedDomains;
    }

    public void setSenderAllowedDomains(List<String> senderAllowedDomains) {
        List<String> oldValue = this.getSenderAllowedDomains();
        this.senderAllowedDomains = senderAllowedDomains;
        this.firePropertyChange(PROPERTY_SENDER_ALLOWED_DOMAINS, oldValue, senderAllowedDomains);
    }

    public boolean isDomainAllowed(String from) {
        Preconditions.checkNotNull((Object)from);
        for (String domain : this.getSenderAllowedDomains()) {
            log.info((Object)(domain + " " + from));
            if (!from.endsWith(domain)) continue;
            return true;
        }
        return this.getSenderAllowedDomains().isEmpty();
    }
}

