/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.AttachmentItem;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class ReplyFormUIHandler
extends AbstractFaxToMailUIHandler<ReplyFormUIModel, ReplyFormUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(ReplyFormUIHandler.class);

    public void beforeInit(ReplyFormUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ReplyFormUIModel model = new ReplyFormUIModel();
        long maxSize = this.getContext().getFaxToMailConfiguration().getEmailMaxSize();
        model.setMaxAttachmentLength(maxSize);
        ((ReplyFormUI)this.ui).setContextValue(model);
    }

    public void afterInit(ReplyFormUI replyFormUI) {
        this.initUI(this.ui);
        JEditorPane editor = ((ReplyFormUI)this.ui).getMessage();
        editor.setCaretPosition(0);
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        model.addPropertyChangeListener("originalDemand", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandeUIModel demand = (DemandeUIModel)evt.getNewValue();
                ReplyFormUIModel model = (ReplyFormUIModel)((Object)evt.getSource());
                ArrayList<DemandeUIModel> models = new ArrayList<DemandeUIModel>();
                models.add(demand);
                models.addAll(demand.getGroupedDemandes());
                for (DemandeUIModel demandeUIModel : models) {
                    for (Attachment attachment : demandeUIModel.getAttachment()) {
                        AttachmentFile originalFile = attachment.getOriginalFile();
                        model.addAvailableAttachment(originalFile);
                        AttachmentFile file = attachment.getEditedFile();
                        if (file == null) continue;
                        model.addAvailableAttachment(file);
                    }
                }
                JComboBox addAttachmentFile = ((ReplyFormUI)ReplyFormUIHandler.this.ui).getAddAttachmentFile();
                addAttachmentFile.setModel(ReplyFormUIHandler.this.newComboModel(model.getAvailableAttachments().toArray()));
                addAttachmentFile.setSelectedItem(null);
                model.setFrom(demand.getRecipient());
                model.setSubject(I18n.t((String)"faxtomail.reply.subject", (Object[])new Object[]{demand.getSubject()}));
                String plainContent = JAXXUtil.getStringValue((Object)demand.getPlainContent());
                String quotedReply = I18n.t((String)"faxtomail.reply.message", (Object[])new Object[]{ReplyFormUIHandler.this.decorate(demand.getReceptionDate()), demand.getSender(), plainContent.replaceAll("\n", "\n> ")});
                model.setMessage(quotedReply);
                ArrayList<String> folderReplyAdresses = new ArrayList<String>();
                ArrayList<String> folderReplyDomains = new ArrayList<String>();
                for (MailFolder folder = demand.getMailFolder(); folder != null; folder = folder.getParent()) {
                    folderReplyAdresses.addAll(folder.getReplyAddresses());
                    folderReplyDomains.addAll(folder.getReplyDomains());
                }
                model.setSenderAllowedDomains(folderReplyDomains);
                ArrayList replyToAddresses = Lists.newArrayList((Object[])new String[]{demand.getRecipient()});
                if (folderReplyAdresses != null) {
                    replyToAddresses.addAll(folderReplyAdresses);
                }
                ((ReplyFormUI)ReplyFormUIHandler.this.ui).getFromComboBox().setModel(ReplyFormUIHandler.this.newComboModel(replyToAddresses.toArray()));
            }
        });
        model.addPropertyChangeListener("attachment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIHandler.this.updateAttachmentPanel((Collection)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("readonly", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIHandler.this.updateAttachmentPanel(((ReplyFormUIModel)((Object)ReplyFormUIHandler.this.getModel())).getAttachments());
            }
        });
        JComboBox addAttachmentFile = ((ReplyFormUI)this.ui).getAddAttachmentFile();
        addAttachmentFile.setRenderer(new DecoratorListCellRenderer(this.getDecorator(AttachmentFile.class, null)));
        addAttachmentFile.setEditor(new FileComboBoxEditor());
        this.getValidator().addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIModel model = (ReplyFormUIModel)((Object)ReplyFormUIHandler.this.getModel());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    @Override
    public void cancel() {
        this.closeFrame();
    }

    public void onCloseUI() {
    }

    public SwingValidator<ReplyFormUIModel> getValidator() {
        return ((ReplyFormUI)this.getUI()).getValidator();
    }

    protected JComponent getComponentToFocus() {
        return ((ReplyFormUI)this.getUI()).getMessage();
    }

    public void removeAttachment(AttachmentFile attachment) {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        model.removeAttachment(attachment);
        model.addAvailableAttachment(attachment);
        ((ReplyFormUI)this.ui).getAddAttachmentFile().addItem(attachment);
    }

    public void addAttachment() {
        AttachmentFile attachmentFile;
        JComboBox addAttachmentFile;
        block6: {
            addAttachmentFile = ((ReplyFormUI)this.ui).getAddAttachmentFile();
            attachmentFile = null;
            Object selectedItem = addAttachmentFile.getSelectedItem();
            if (AttachmentFile.class.isAssignableFrom(selectedItem.getClass())) {
                attachmentFile = (AttachmentFile)selectedItem;
            } else if (File.class.isAssignableFrom(selectedItem.getClass())) {
                File file = (File)selectedItem;
                attachmentFile = new AttachmentFileImpl();
                attachmentFile.setFilename(file.getName());
                try {
                    attachmentFile.setContent(FileUtils.readFileToByteArray((File)file));
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Error while converting the file " + file.getName() + " into a byte[]"), (Throwable)e);
                }
            }
        }
        if (attachmentFile != null) {
            ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
            model.addAttachment(attachmentFile);
            model.removeAvailableAttachment(attachmentFile);
            ((ReplyFormUI)this.ui).getAddAttachmentFile().removeItem(attachmentFile);
            addAttachmentFile.setSelectedItem(null);
        }
    }

    protected void updateAttachmentPanel(Collection<AttachmentFile> attachments) {
        JPanel attachmentsPanel = ((ReplyFormUI)this.ui).getAttachmentsPanel();
        attachmentsPanel.removeAll();
        for (AttachmentFile attachment : attachments) {
            AttachmentItem item = new AttachmentItem();
            item.setHandler(this);
            item.setAttachmentFile(attachment);
            attachmentsPanel.add(item);
        }
        attachmentsPanel.updateUI();
    }

    public void openLocation() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        File startFile = model.getLastVisitedDirectory();
        JFileChooser fc = new JFileChooser(startFile);
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog((Component)this.ui);
        model.setLastVisitedDirectory(fc.getCurrentDirectory());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            ((ReplyFormUI)this.ui).getAddAttachmentFile().setSelectedItem(file);
        }
    }

    public void openAttachment(AttachmentFile attachment) {
        File file = attachment.getFile();
        Desktop desktop = FaxToMailUIUtil.getDesktopForOpen();
        try {
            desktop.open(file);
        }
        catch (IOException e) {
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
        }
    }

    protected class FileComboBoxEditor
    implements ComboBoxEditor {
        protected AttachmentFile oldValue;
        protected JTextField editorComponent = new JTextField();

        protected FileComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return this.editorComponent;
        }

        @Override
        public void setItem(Object anObject) {
            String text;
            AttachmentFile attachmentFile = null;
            if (anObject != null) {
                if (AttachmentFile.class.isAssignableFrom(anObject.getClass())) {
                    attachmentFile = (AttachmentFile)anObject;
                } else if (File.class.isAssignableFrom(anObject.getClass())) {
                    File file = (File)anObject;
                    attachmentFile = new AttachmentFileImpl();
                    attachmentFile.setFilename(file.getName());
                }
            }
            if (attachmentFile != null) {
                text = ReplyFormUIHandler.this.decorate((Serializable)((Object)attachmentFile));
                this.oldValue = attachmentFile;
            } else {
                text = "";
            }
            if (!text.equals(this.editorComponent.getText())) {
                this.editorComponent.setText(text);
            }
        }

        @Override
        public Object getItem() {
            Object newValue = this.editorComponent.getText();
            if (this.oldValue != null) {
                if (newValue.equals(ReplyFormUIHandler.this.decorate((Serializable)((Object)this.oldValue)))) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke((Object)this.oldValue, this.editorComponent.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.editorComponent.selectAll();
            this.editorComponent.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editorComponent.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editorComponent.removeActionListener(l);
        }
    }
}

