/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content;

import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.RunFaxToMail;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.config.FaxToMailConfigUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.RemoveablePropertyChangeListener;
import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.session.SwingSession;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;

public class MainUIHandler
extends AbstractFaxToMailUIHandler<FaxToMailUIContext, MainUI> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected JComponent currentBody;

    public void beforeInit(MainUI ui) {
        super.beforeInit((ApplicationUI)ui);
        FaxToMailUIContext context = this.getContext();
        ui.setContextValue(context);
        context.setMainUI(ui);
        context.setActionUI(new ApplicationActionUI((JFrame)ui, (ApplicationUIContext)context));
        context.addPropertyChangeListener(new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((FaxToMailScreen)((Object)evt.getNewValue()));
                }
            }
        });
        ui.setContextValue(ui, MainUI.class.getName());
        context.addPropertyChangeListener("busy", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                MainUIHandler.this.updateBusyState(newvalue != null && newvalue != false);
            }
        });
        context.addPropertyChangeListener("hideBody", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                if (MainUIHandler.this.getUI() != null && ((MainUI)MainUIHandler.this.getUI()).getBody() != null) {
                    ((MainUI)MainUIHandler.this.getUI()).getBody().setVisible(newvalue != null && newvalue != false);
                }
            }
        });
    }

    protected void updateBusyState(boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getDefaultCursor());
        }
    }

    public void afterInit(MainUI ui) {
        block2: {
            this.initUI(ui);
            SwingSession swingSession = this.getContext().getSwingSession();
            swingSession.add((Component)ui);
            try {
                swingSession.save();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"error while saving the swing session", (Throwable)e);
            }
        }
        this.changeTitle();
        JToolBar bar = ui.getBottomBar();
        ui.getStatus().addWidget((Component)bar, 0);
        this.getContext().setScreen(FaxToMailScreen.LIST);
    }

    protected JComponent getComponentToFocus() {
        return this.currentBody;
    }

    public void onCloseUI() {
        PropertyChangeListener[] propertyChangeListeners;
        FaxToMailUIContext context = this.getContext();
        context.setScreen(null);
        context.removeMessageNotifier(this);
        for (PropertyChangeListener listener : propertyChangeListeners = context.getPropertyChangeListeners()) {
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                listener = (PropertyChangeListener)proxy.getListener();
            }
            if (!(listener instanceof RemoveablePropertyChangeListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            context.removePropertyChangeListener(listener);
        }
        if (this.ui != null) {
            JAXXBinding[] bindings;
            for (JAXXBinding binding : bindings = ((MainUI)this.ui).getDataBindings()) {
                SwingUtil.removeDataBinding((JAXXObject)this.ui, (String[])new String[]{binding.getId()});
            }
            ((MainUI)this.ui).setVisible(false);
            ((MainUI)this.ui).dispose();
        }
    }

    public SwingValidator<FaxToMailUIContext> getValidator() {
        return null;
    }

    public void reloadUI() {
        this.onCloseUI();
        RunFaxToMail.startFaxToMail(this.getContext(), false);
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    public void changeLocale(Locale locale) {
        ((FaxToMailUIContext)this.getModel()).setLocale(locale);
        I18n.setDefaultLocale((Locale)this.getConfig().getI18nLocale());
        this.reloadUI();
    }

    @Override
    public final void showInformationMessage(String message) {
        ((MainUI)this.ui).getStatus().setStatus("<html><body>" + message + "</body></html>");
    }

    public void registerValidator(SwingValidator validator) {
        ((MainUI)this.ui).getValidatorMessageWidget().registerValidator(validator);
    }

    @Override
    public void clearValidators() {
        ((MainUI)this.ui).getValidatorMessageWidget().clearValidators();
    }

    public boolean quitCurrentScreen() {
        boolean canClose;
        if (this.getContext().getScreen() == null || this.currentBody == null) {
            canClose = true;
            if (log.isWarnEnabled()) {
                log.warn((Object)"==================================================");
                log.warn((Object)"No screen, Should then skipCheckCurrent in action.");
                log.warn((Object)"==================================================");
            }
        } else {
            FaxToMailUI body = (FaxToMailUI)((Object)this.currentBody);
            Preconditions.checkNotNull((Object)this.currentBody);
            AbstractFaxToMailUIHandler handler = (AbstractFaxToMailUIHandler)body.getHandler();
            canClose = handler instanceof CloseableUI ? ((CloseableUI)((Object)handler)).quitUI() : true;
        }
        return canClose;
    }

    protected void setScreen(FaxToMailScreen screen) {
        if (this.currentBody != null) {
            block9: {
                FaxToMailUI body = (FaxToMailUI)((Object)this.currentBody);
                ((AbstractFaxToMailUIHandler)body.getHandler()).onCloseUI();
                try {
                    this.getContext().getSwingSession().save();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block9;
                    log.error((Object)"error while saving the swing session", (Throwable)e);
                }
            }
            ((MainUI)this.ui).getBody().remove((Component)this.currentBody);
            this.currentBody = null;
        }
        if (screen != null) {
            Icon icon;
            String screenTitle;
            JPanel screenUI;
            JToolBar rightDecoration = null;
            switch (screen) {
                case CONFIG: {
                    screenUI = new FaxToMailConfigUI((FaxToMailUI)this.ui);
                    screenTitle = I18n.t((String)"faxtomail.config.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileConfiguration().getIcon();
                    break;
                }
                case SEARCH: {
                    screenUI = new SearchUI((FaxToMailUI)this.ui);
                    screenTitle = I18n.t((String)"faxtomail.search.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileRecherche().getIcon();
                    break;
                }
                case DEMANDE: {
                    screenUI = new DemandesUI((FaxToMailUI)this.ui);
                    screenTitle = I18n.t((String)"faxtomail.demand.title", (Object[])new Object[0]);
                    icon = JAXXWidgetUtil.createActionIcon((String)"email-group");
                    rightDecoration = ((DemandesUI)screenUI).getTopToolBar();
                    break;
                }
                default: {
                    screenUI = new DemandeListUI((FaxToMailUI)this.ui);
                    screenTitle = I18n.t((String)"faxtomail.demandeList.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileDemandeList().getIcon();
                }
            }
            this.currentBody = screenUI;
            this.getContext().getSwingSession().add((Component)this.currentBody, true);
            ((MainUI)this.ui).getBody().setTitle(screenTitle);
            ((MainUI)this.ui).getBody().setLeftDecoration((JComponent)new JLabel(icon));
            ((MainUI)this.ui).getBody().setRightDecoration((JComponent)rightDecoration);
            ((MainUI)this.ui).getBody().add((Component)this.currentBody);
        }
    }

    public void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        ((MainUI)this.ui).setTitle(I18n.t((String)"faxtomail.main.title.application", (Object[])new Object[]{this.getConfig().getVersion(), title}));
    }

    protected String getSelectedCruiseTitle() {
        String title = I18n.t((String)"faxtomail.main.title.nodb", (Object[])new Object[0]);
        return title;
    }

    public void setBodyTitle(String title) {
        ((MainUI)this.ui).getBody().setTitle(title);
    }

    public JComponent getCurrentBody() {
        return this.currentBody;
    }
}

