/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GenerateAnnotatedAttachmentAction
extends AbstractFaxToMailAction<PDFEditorUIModel, PDFEditorUI, PDFEditorUIHandler> {
    private static final Log log = LogFactory.getLog(GenerateAnnotatedAttachmentAction.class);

    public GenerateAnnotatedAttachmentAction(PDFEditorUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"faxtomail.action.generateAnnotatedAttachment.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        AttachmentFile attachmentFile = ((PDFEditorUIModel)this.getModel()).getNotNullFile();
        File file = attachmentFile.getFile();
        PDFEditorUIModel model = (PDFEditorUIModel)this.getModel();
        FileInputStream inputStream = new FileInputStream(file);
        PdfReader pdfReader = new PdfReader((InputStream)inputStream);
        File target = File.createTempFile("faxtomail-", ".tmp");
        target.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(target);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)fos);
        int pageNb = model.getPages().length;
        float zoom = model.getZoom();
        int rotation = model.getRotation();
        for (int i = 0; i < pageNb; ++i) {
            int y;
            int x;
            int height;
            int width;
            Point location;
            PdfContentByte cb = pdfStamper.getOverContent(i + 1);
            PdfDictionary pageDict = pdfReader.getPageN(i + 1);
            int pageRotation = pdfReader.getPageRotation(i + 1);
            pageDict.put(PdfName.ROTATE, (PdfObject)new PdfNumber((360 + pageRotation + rotation) % 360));
            for (PDFEditorNoteUI pDFEditorNoteUI : model.getPages()[i].getNotes()) {
                String[] rows;
                location = pDFEditorNoteUI.getLocation();
                width = (int)((float)pDFEditorNoteUI.getWidth() / zoom);
                height = (int)((float)pDFEditorNoteUI.getHeight() / zoom);
                x = (int)((float)location.x / zoom);
                y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - height;
                Insets insets = pDFEditorNoteUI.getInsets();
                cb.saveState();
                cb.setColorFill(BaseColor.YELLOW);
                cb.rectangle((float)x, (float)y, (float)width, (float)height);
                cb.fill();
                cb.restoreState();
                cb.saveState();
                JTextArea textArea = pDFEditorNoteUI.getNoteText();
                float fontSize = textArea.getFont().getSize2D() / zoom;
                cb.setFontAndSize(BaseFont.createFont((String)"Helvetica-Oblique", (String)"Cp1252", (boolean)false), fontSize * 1.3f);
                ColumnText ct = new ColumnText(cb);
                ct.setSimpleColumn((float)(x + insets.left), (float)(y + insets.bottom), (float)(x + insets.left + width - insets.right), (float)(y + insets.bottom + height - insets.top));
                ct.setLeading(fontSize + 3.0f);
                ct.addText(new Phrase(pDFEditorNoteUI.getTitle()));
                ct.go();
                String text = pDFEditorNoteUI.getText();
                for (String s : rows = text.split("\n")) {
                    if (s.isEmpty()) {
                        s = " ";
                    }
                    ct.addText(new Phrase(s));
                    ct.go();
                }
                cb.restoreState();
            }
            for (PDFEditorCrossUI pDFEditorCrossUI : model.getPages()[i].getCrosses()) {
                location = pDFEditorCrossUI.getLocation();
                width = (int)((float)pDFEditorCrossUI.getWidth() / zoom);
                height = (int)((float)pDFEditorCrossUI.getHeight() / zoom);
                x = (int)((float)location.x / zoom);
                y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - height;
                cb.saveState();
                cb.setColorStroke(BaseColor.BLUE);
                cb.moveTo((float)x, (float)y);
                cb.lineTo((float)(x + width), (float)(y + height));
                cb.stroke();
                cb.moveTo((float)(x + width), (float)y);
                cb.lineTo((float)x, (float)(y + height));
                cb.stroke();
                cb.restoreState();
            }
            for (PDFEditorLineUI pDFEditorLineUI : model.getPages()[i].getLines()) {
                location = pDFEditorLineUI.getLocation();
                width = (int)((float)pDFEditorLineUI.getWidth() / zoom);
                height = (int)((float)pDFEditorLineUI.getHeight() / zoom);
                x = (int)((float)location.x / zoom);
                y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - height;
                if (pDFEditorLineUI.isHorizontal().booleanValue()) {
                    y += height / 2;
                } else {
                    x += width / 2;
                }
                cb.saveState();
                cb.setColorStroke(BaseColor.BLUE);
                cb.moveTo((float)x, (float)y);
                if (pDFEditorLineUI.isHorizontal().booleanValue()) {
                    cb.lineTo((float)(x + width), (float)y);
                } else {
                    cb.lineTo((float)x, (float)(y + height));
                }
                cb.stroke();
                cb.restoreState();
            }
            for (PDFEditorHighlighterUI pDFEditorHighlighterUI : model.getPages()[i].getHighlighters()) {
                location = pDFEditorHighlighterUI.getLocation();
                width = (int)((float)pDFEditorHighlighterUI.getWidth() / zoom);
                height = (int)((float)pDFEditorHighlighterUI.getHeight() / zoom);
                x = (int)((float)location.x / zoom);
                y = (int)((float)(((PDFEditorUI)this.getUI()).getContainer().getHeight() - location.y) / zoom) - height;
                cb.saveState();
                PdfGState gs1 = new PdfGState();
                gs1.setFillOpacity(0.4f);
                cb.setGState(gs1);
                cb.setColorFill(BaseColor.YELLOW);
                cb.rectangle((float)x, (float)y, (float)width, (float)height);
                cb.fill();
                cb.restoreState();
            }
        }
        pdfStamper.close();
        pdfReader.close();
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        PdfAction action = new PdfAction(5);
        writer.setOpenAction(action);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(target));
        AttachmentFile attachmentFileNew = this.getContext().getEmailService().getAttachmentFileFromStream((InputStream)is);
        attachmentFileNew.setFilename(FaxToMailUIUtil.getEditedFileName(((PDFEditorUIModel)this.getModel()).getOriginalFile()));
        ((PDFEditorUIModel)this.getModel()).setEditedFile(attachmentFileNew);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        AttachmentEditorUI parentUI = (AttachmentEditorUI)((PDFEditorUI)this.getUI()).getContextValue(JAXXContext.class, "parent");
        parentUI.getModel().fireAttachmentEdited((Attachment)((PDFEditorUIModel)this.getModel()).toEntity());
    }
}

