/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.intfc;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.intfc.ReflectiveDelegationPolicy;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class DelegatorGenerator {
    int class_modifiers = 1025;
    int method_modifiers = 1;
    int wrapping_ctor_modifiers = 1;
    int default_ctor_modifiers = 1;
    boolean wrapping_constructor = true;
    boolean default_constructor = true;
    boolean inner_getter = true;
    boolean inner_setter = true;
    Class superclass = null;
    Class[] extraInterfaces = null;
    Method[] reflectiveDelegateMethods = null;
    ReflectiveDelegationPolicy reflectiveDelegationPolicy = ReflectiveDelegationPolicy.USE_MAIN_DELEGATE_INTERFACE;
    static final Comparator classComp = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Class)a).getName().compareTo(((Class)b).getName());
        }
    };

    public void setGenerateInnerSetter(boolean b) {
        this.inner_setter = b;
    }

    public boolean isGenerateInnerSetter() {
        return this.inner_setter;
    }

    public void setGenerateInnerGetter(boolean b) {
        this.inner_getter = b;
    }

    public boolean isGenerateInnerGetter() {
        return this.inner_getter;
    }

    public void setGenerateNoArgConstructor(boolean b) {
        this.default_constructor = b;
    }

    public boolean isGenerateNoArgConstructor() {
        return this.default_constructor;
    }

    public void setGenerateWrappingConstructor(boolean b) {
        this.wrapping_constructor = b;
    }

    public boolean isGenerateWrappingConstructor() {
        return this.wrapping_constructor;
    }

    public void setWrappingConstructorModifiers(int modifiers) {
        this.wrapping_ctor_modifiers = modifiers;
    }

    public int getWrappingConstructorModifiers() {
        return this.wrapping_ctor_modifiers;
    }

    public void setNoArgConstructorModifiers(int modifiers) {
        this.default_ctor_modifiers = modifiers;
    }

    public int getNoArgConstructorModifiers() {
        return this.default_ctor_modifiers;
    }

    public void setMethodModifiers(int modifiers) {
        this.method_modifiers = modifiers;
    }

    public int getMethodModifiers() {
        return this.method_modifiers;
    }

    public void setClassModifiers(int modifiers) {
        this.class_modifiers = modifiers;
    }

    public int getClassModifiers() {
        return this.class_modifiers;
    }

    public void setSuperclass(Class superclass) {
        this.superclass = superclass;
    }

    public Class getSuperclass() {
        return this.superclass;
    }

    public void setExtraInterfaces(Class[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
    }

    public Class[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public Method[] getReflectiveDelegateMethods() {
        return this.reflectiveDelegateMethods;
    }

    public void setReflectiveDelegateMethods(Method[] reflectiveDelegateMethods) {
        this.reflectiveDelegateMethods = reflectiveDelegateMethods;
    }

    public ReflectiveDelegationPolicy getReflectiveDelegationPolicy() {
        return this.reflectiveDelegationPolicy;
    }

    public void setReflectiveDelegationPolicy(ReflectiveDelegationPolicy reflectiveDelegationPolicy) {
        this.reflectiveDelegationPolicy = reflectiveDelegationPolicy;
    }

    public void writeDelegator(Class intfcl, String genclass, Writer w) throws IOException {
        Method method;
        int i;
        int len;
        IndentedWriter iw = CodegenUtils.toIndentedWriter(w);
        String pkg = genclass.substring(0, genclass.lastIndexOf(46));
        String sgc = CodegenUtils.fqcnLastElement(genclass);
        String scn = this.superclass != null ? ClassUtils.simpleClassName(this.superclass) : null;
        String sin = ClassUtils.simpleClassName(intfcl);
        String[] eins = null;
        if (this.extraInterfaces != null) {
            eins = new String[this.extraInterfaces.length];
            int len2 = this.extraInterfaces.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                eins[i2] = ClassUtils.simpleClassName(this.extraInterfaces[i2]);
            }
        }
        TreeSet<Class> imports = new TreeSet<Class>(classComp);
        Method[] methods = intfcl.getMethods();
        if (!CodegenUtils.inSamePackage(intfcl.getName(), genclass)) {
            imports.add(intfcl);
        }
        if (this.superclass != null && !CodegenUtils.inSamePackage(this.superclass.getName(), genclass)) {
            imports.add(this.superclass);
        }
        if (this.extraInterfaces != null) {
            for (Class checkMe : this.extraInterfaces) {
                if (CodegenUtils.inSamePackage(checkMe.getName(), genclass)) continue;
                imports.add(checkMe);
            }
        }
        this.ensureImports(genclass, imports, methods);
        if (this.reflectiveDelegateMethods != null) {
            this.ensureImports(genclass, imports, this.reflectiveDelegateMethods);
        }
        if (this.reflectiveDelegationPolicy.delegateClass != null && !CodegenUtils.inSamePackage(this.reflectiveDelegationPolicy.delegateClass.getName(), genclass)) {
            imports.add(this.reflectiveDelegationPolicy.delegateClass);
        }
        this.generateBannerComment(iw);
        iw.println("package " + pkg + ';');
        iw.println();
        Iterator ii = imports.iterator();
        while (ii.hasNext()) {
            iw.println("import " + ((Class)ii.next()).getName() + ';');
        }
        this.generateExtraImports(iw);
        iw.println();
        this.generateClassJavaDocComment(iw);
        iw.print(CodegenUtils.getModifierString(this.class_modifiers) + " class " + sgc);
        if (this.superclass != null) {
            iw.print(" extends " + scn);
        }
        iw.print(" implements " + sin);
        if (eins != null) {
            len = eins.length;
            for (int i3 = 0; i3 < len; ++i3) {
                iw.print(", " + eins[i3]);
            }
        }
        iw.println();
        iw.println("{");
        iw.upIndent();
        iw.println("protected " + sin + " inner;");
        iw.println();
        if (this.reflectiveDelegateMethods != null) {
            iw.println("protected Class __delegateClass = null;");
        }
        iw.println();
        iw.println("private void __setInner( " + sin + " inner )");
        iw.println("{");
        iw.upIndent();
        iw.println("this.inner = inner;");
        if (this.reflectiveDelegateMethods != null) {
            String delegateClassExpr = this.reflectiveDelegationPolicy == ReflectiveDelegationPolicy.USE_MAIN_DELEGATE_INTERFACE ? sin + ".class" : (this.reflectiveDelegationPolicy == ReflectiveDelegationPolicy.USE_RUNTIME_CLASS ? "inner.getClass()" : ClassUtils.simpleClassName(this.reflectiveDelegationPolicy.delegateClass) + ".class");
            iw.println("this.__delegateClass = inner == null ? null : " + delegateClassExpr + ";");
        }
        iw.downIndent();
        iw.println("}");
        iw.println();
        if (this.wrapping_constructor) {
            iw.println("public " + sgc + '(' + sin + " inner)");
            iw.println("{ __setInner( inner ); }");
        }
        if (this.default_constructor) {
            iw.println();
            iw.println("public " + sgc + "()");
            iw.println("{}");
        }
        if (this.inner_setter) {
            iw.println();
            iw.println(CodegenUtils.getModifierString(this.method_modifiers) + " void setInner( " + sin + " inner )");
            iw.println("{ __setInner( inner ); }");
        }
        if (this.inner_getter) {
            iw.println();
            iw.println(CodegenUtils.getModifierString(this.method_modifiers) + ' ' + sin + " getInner()");
            iw.println("{ return inner; }");
        }
        iw.println();
        len = methods.length;
        for (i = 0; i < len; ++i) {
            method = methods[i];
            if (i != 0) {
                iw.println();
            }
            iw.println(CodegenUtils.methodSignature(this.method_modifiers, method, null));
            iw.println("{");
            iw.upIndent();
            this.generatePreDelegateCode(intfcl, genclass, method, iw);
            this.generateDelegateCode(intfcl, genclass, method, iw);
            this.generatePostDelegateCode(intfcl, genclass, method, iw);
            iw.downIndent();
            iw.println("}");
        }
        if (this.reflectiveDelegateMethods != null) {
            iw.println("// Methods not in core interface to be delegated via reflection");
            len = this.reflectiveDelegateMethods.length;
            for (i = 0; i < len; ++i) {
                method = this.reflectiveDelegateMethods[i];
                if (i != 0) {
                    iw.println();
                }
                iw.println(CodegenUtils.methodSignature(this.method_modifiers, method, null));
                iw.println("{");
                iw.upIndent();
                this.generatePreDelegateCode(intfcl, genclass, method, iw);
                this.generateReflectiveDelegateCode(intfcl, genclass, method, iw);
                this.generatePostDelegateCode(intfcl, genclass, method, iw);
                iw.downIndent();
                iw.println("}");
            }
        }
        iw.println();
        this.generateExtraDeclarations(intfcl, genclass, iw);
        iw.downIndent();
        iw.println("}");
    }

    private void ensureImports(String genclass, Set imports, Method[] methods) {
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            Class<?>[] args = methods[i].getParameterTypes();
            int jlen = args.length;
            for (int j = 0; j < jlen; ++j) {
                if (CodegenUtils.inSamePackage(args[j].getName(), genclass)) continue;
                imports.add(CodegenUtils.unarrayClass(args[j]));
            }
            Class<?>[] excClasses = methods[i].getExceptionTypes();
            int jlen2 = excClasses.length;
            for (int j = 0; j < jlen2; ++j) {
                if (CodegenUtils.inSamePackage(excClasses[j].getName(), genclass)) continue;
                imports.add(CodegenUtils.unarrayClass(excClasses[j]));
            }
            if (CodegenUtils.inSamePackage(methods[i].getReturnType().getName(), genclass)) continue;
            imports.add(CodegenUtils.unarrayClass(methods[i].getReturnType()));
        }
    }

    protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
        Class<?> retType = method.getReturnType();
        iw.println((retType == Void.TYPE ? "" : "return ") + "inner." + CodegenUtils.methodCall(method) + ";");
    }

    protected void generateReflectiveDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
        Class<?> retType = method.getReturnType();
        String paramTypesArrayStr = CodegenUtils.reflectiveMethodParameterTypeArray(method);
        String argArrayStr = CodegenUtils.reflectiveMethodObjectArray(method);
        Class<?>[] exceptionsArray = method.getExceptionTypes();
        HashSet exceptionsSet = new HashSet();
        exceptionsSet.addAll(Arrays.asList(exceptionsArray));
        iw.println("try");
        iw.println("{");
        iw.upIndent();
        iw.println("Method m = __delegateClass.getMethod(\"" + method.getName() + "\", " + paramTypesArrayStr + ");");
        iw.println((retType == Void.TYPE ? "" : "return (" + ClassUtils.simpleClassName(retType) + ") ") + "m.invoke( inner, " + argArrayStr + " );");
        iw.downIndent();
        iw.println("}");
        if (!exceptionsSet.contains(IllegalAccessException.class)) {
            iw.println("catch (IllegalAccessException iae)");
            iw.println("{");
            iw.upIndent();
            iw.println("throw new RuntimeException(\"A reflectively delegated method '" + method.getName() + "' cannot access the object to which the call is delegated\", iae);");
            iw.downIndent();
            iw.println("}");
        }
        iw.println("catch (InvocationTargetException ite)");
        iw.println("{");
        iw.upIndent();
        iw.println("Throwable cause = ite.getCause();");
        iw.println("if (cause instanceof RuntimeException) throw (RuntimeException) cause;");
        iw.println("if (cause instanceof Error) throw (Error) cause;");
        int len = exceptionsArray.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                String ecn = ClassUtils.simpleClassName(exceptionsArray[i]);
                iw.println("if (cause instanceof " + ecn + ") throw (" + ecn + ") cause;");
            }
        }
        iw.println("throw new RuntimeException(\"Target of reflectively delegated method '" + method.getName() + "' threw an Exception.\", cause);");
        iw.downIndent();
        iw.println("}");
    }

    protected void generateBannerComment(IndentedWriter iw) throws IOException {
        iw.println("/*");
        iw.println(" * This class generated by " + this.getClass().getName());
        iw.println(" * " + new Date());
        iw.println(" * DO NOT HAND EDIT!!!!");
        iw.println(" */");
    }

    protected void generateClassJavaDocComment(IndentedWriter iw) throws IOException {
        iw.println("/**");
        iw.println(" * This class was generated by " + this.getClass().getName() + ".");
        iw.println(" */");
    }

    protected void generateExtraImports(IndentedWriter iw) throws IOException {
    }

    protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
    }

    protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
    }

    protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw) throws IOException {
    }
}

