package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class SearchUIModel extends AbstractFaxToMailBeanUIModel<EmailFilter, SearchUIModel> {

    private static final Log log = LogFactory.getLog(SearchUIModel.class);

    public static final String PROPERTY_RESULTS = "results";
    public static final String PROPERTY_MENU_ENABLED = "menuEnabled";
    public static final String PROPERTY_GROUP_ENABLED = "groupEnabled";

    protected final EmailFilter editObject = new EmailFilter();

    protected List<DemandeUIModel> results;

    protected boolean menuEnabled;
    protected boolean groupEnabled;
    protected boolean showGroupesDemandsInResults;

    protected static Binder<SearchUIModel, EmailFilter> toBeanBinder =
            BinderFactory.newBinder(SearchUIModel.class,
                    EmailFilter.class);

    protected static Binder<EmailFilter, SearchUIModel> fromBeanBinder =
            BinderFactory.newBinder(EmailFilter.class, SearchUIModel.class);

    public SearchUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    
    public void setSender(String sender) {
        Object oldValue = getSender();
        editObject.setSender(sender);
        firePropertyChanged(EmailFilter.PROPERTY_SENDER, oldValue, sender);
    }

    public String getSender() {
        return editObject.getSender();
    }

    /*public void setRecipient(String recipient) {
        Object oldValue = getRecipient();
        editObject.setRecipient(recipient);
        firePropertyChanged(EmailFilter.PROPERTY_RECIPIENT, oldValue, recipient);
    }

    public String getRecipient() {
        return editObject.getRecipient();
    }*/

    public void setDemandObject(String demandObject) {
        Object oldValue = getDemandObject();
        editObject.setDemandObject(demandObject);
        firePropertyChanged(EmailFilter.PROPERTY_DEMAND_OBJECT, oldValue, demandObject);
    }

    public String getDemandObject() {
        return editObject.getDemandObject();
    }

    public void setClientCode(String clientCode) {
        Object oldValue = getClientCode();
        editObject.setClientCode(clientCode);
        firePropertyChanged(EmailFilter.PROPERTY_CLIENT_CODE, oldValue, clientCode);
    }

    public String getClientCode() {
        return editObject.getClientCode();
    }

    public void setMessage(String message) {
        Object oldValue = getMessage();
        editObject.setMessage(message);
        firePropertyChanged(EmailFilter.PROPERTY_MESSAGE, oldValue, message);
    }

    public String getMessage() {
        return editObject.getMessage();
    }

    public void setBody(String body) {
        Object oldValue = getBody();
        editObject.setBody(body);
        firePropertyChanged(EmailFilter.PROPERTY_BODY, oldValue, body);
    }

    public String getBody() {
        return editObject.getBody();
    }
//
//    public void setCommandNumber(String commandNumber) {
//        Object oldValue = getCommandNumber();
//        editObject.setCommandNumber(commandNumber);
//        firePropertyChanged(EmailFilter.PROPERTY_COMMAND_NUMBER, oldValue, commandNumber);
//    }
//
//    public String getCommandNumber() {
//        return editObject.getCommandNumber();
//    }

    public void setEtatAttente(List<EtatAttente> etatAttente) {
        editObject.setEtatAttente(etatAttente);
        firePropertyChanged(EmailFilter.PROPERTY_ETAT_ATTENTE, null, etatAttente);
    }

    public List<EtatAttente> getEtatAttente() {
        return editObject.getEtatAttente();
    }

    public void setTakenBy(FaxToMailUser faxToMailUser) {
        Object oldValue = getTakenBy();
        editObject.setTakenBy(faxToMailUser);
        firePropertyChanged(EmailFilter.PROPERTY_TAKEN_BY, oldValue, faxToMailUser);
    }

    public FaxToMailUser getTakenBy() {
        return editObject.getTakenBy();
    }
    
    public FaxToMailUser getPrintingBy() {
        return editObject.getPrintingBy();
    }
    
    public void setPrintingBy(FaxToMailUser faxToMailUser) {
        Object oldValue = getPrintingBy();
        editObject.setPrintingBy(faxToMailUser);
        firePropertyChanged(EmailFilter.PROPERTY_PRINTING_BY, oldValue, faxToMailUser);
    }
    
    public FaxToMailUser getArchivedBy() {
        return editObject.getArchivedBy();
    }
    
    public void setArchivedBy(FaxToMailUser faxToMailUser) {
        Object oldValue = getArchivedBy();
        editObject.setArchivedBy(faxToMailUser);
        firePropertyChanged(EmailFilter.PROPERTY_ARCHIVED_BY, oldValue, faxToMailUser);
    }

    public FaxToMailUser getReplyBy() {
        return editObject.getReplyBy();
    }

    public void setReplyBy(FaxToMailUser faxToMailUser) {
        Object oldValue = getReplyBy();
        editObject.setReplyBy(faxToMailUser);
        firePropertyChanged(EmailFilter.PROPERTY_REPLY_BY, oldValue, faxToMailUser);
    }

    public List<Priority> getPriority() {
        return editObject.getPriority();
    }

    public void setPriority(List<Priority> priority) {
        editObject.setPriority(priority);
        firePropertyChanged(EmailFilter.PROPERTY_PRIORITY, null, priority);
    }

    public List<DemandType> getDemandType() {
        return editObject.getDemandType();
    }

    public void setDemandType(List<DemandType> demandType) {
        editObject.setDemandType(demandType);
        firePropertyChanged(EmailFilter.PROPERTY_DEMAND_TYPE, null, demandType);
    }

    public List<DemandStatus> getDemandStatus() {
        return editObject.getDemandStatus();
    }

    public void setDemandStatus(List<DemandStatus> demandStatus) {
        editObject.setDemandStatus(demandStatus);
        firePropertyChanged(EmailFilter.PROPERTY_DEMAND_STATUS, null, demandStatus);
    }

    public void setEdiCodeNumber(String ediCodeNumber) {
        Object oldValue = getEdiCodeNumber();
        editObject.setEdiCodeNumber(ediCodeNumber);
        firePropertyChanged(EmailFilter.PROPERTY_EDI_CODE_NUMBER, oldValue, ediCodeNumber);
    }

    public String getEdiCodeNumber() {
        return editObject.getEdiCodeNumber();
    }

    public void setProjectReference(String projectReference) {
        Object oldValue = getProjectReference();
        editObject.setProjectReference(projectReference);
        firePropertyChanged(EmailFilter.PROPERTY_PROJECT_REFERENCE, oldValue, projectReference);
    }

    public String getProjectReference() {
        return editObject.getProjectReference();
    }

    public String getLocalReference() {
        return editObject.getLocalReference();
    }
    
    public void setLocalReference(String localReference) {
        Object oldValue = getLocalReference();
        editObject.setLocalReference(localReference);
        firePropertyChanged(EmailFilter.PROPERTY_LOCAL_REFERENCE, oldValue, localReference);
    }

    public FaxToMailUser getModifiedBy() {
        return editObject.getModifiedBy();
    }

    public void setModifiedBy(FaxToMailUser modifiedBy) {
        Object oldValue = getModifiedBy();
        editObject.setModifiedBy(modifiedBy);
        firePropertyChanged(EmailFilter.PROPERTY_MODIFIED_BY, oldValue, modifiedBy);
    }

    public FaxToMailUser getTransferBy() {
        return editObject.getTransferBy();
    }

    public void setTransferBy(FaxToMailUser transferBy) {
        Object oldValue = getTransferBy();
        editObject.setTransferBy(transferBy);
        firePropertyChanged(EmailFilter.PROPERTY_TRANSFER_BY, oldValue, transferBy);
    }

    public Date getMinModificationDate() {
        return editObject.getMinModificationDate();
    }

    public void setMinModificationDate(Date minModificationDate) {
        Object oldValue = getMinModificationDate();
        editObject.setMinModificationDate(minModificationDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_MODIFICATION_DATE, oldValue, minModificationDate);
    }

    public Date getMaxModificationDate() {
        return editObject.getMaxModificationDate();
    }

    public void setMaxModificationDate(Date maxModificationDate) {
        Object oldValue = getMaxModificationDate();
        editObject.setMaxModificationDate(maxModificationDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_MODIFICATION_DATE, oldValue, maxModificationDate);
    }

    public Date getMinReceptionDate() {
        return editObject.getMinReceptionDate();
    }

    public void setMinReceptionDate(Date minReceptionDate) {
        Object oldValue = getMinReceptionDate();
        editObject.setMinReceptionDate(minReceptionDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_RECEPTION_DATE, oldValue, minReceptionDate);
        System.out.println(minReceptionDate);
    }

    public Date getMaxReceptionDate() {
        return editObject.getMaxReceptionDate();
    }

    public void setMaxReceptionDate(Date maxReceptionDate) {
        Object oldValue = getMaxReceptionDate();
        editObject.setMaxReceptionDate(maxReceptionDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_RECEPTION_DATE, oldValue, maxReceptionDate);
    }

    public Date getMinPrintingDate() {
        return editObject.getMinPrintingDate();
    }

    public void setMinPrintingDate(Date minPrintingDate) {
        Object oldValue = getMinPrintingDate();
        editObject.setMinPrintingDate(minPrintingDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_PRINTING_DATE, oldValue, minPrintingDate);
    }

    public Date getMaxPrintingDate() {
        return editObject.getMaxPrintingDate();
    }

    public void setMaxPrintingDate(Date maxPrintingDate) {
        Object oldValue = getMaxPrintingDate();
        editObject.setMaxPrintingDate(maxPrintingDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_PRINTING_DATE, oldValue, maxPrintingDate);
    }
    
    public Date getMinArchivedDate() {
        return editObject.getMinArchivedDate();
    }

    public void setMinArchivedDate(Date minArchivedDate) {
        Object oldValue = getMinArchivedDate();
        editObject.setMinArchivedDate(minArchivedDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_ARCHIVED_DATE, oldValue, minArchivedDate);
    }
    
    public Date getMaxArchivedDate() {
        return editObject.getMaxArchivedDate();
    }

    public void setMaxArchivedDate(Date maxArchivedDate) {
        Object oldValue = getMaxArchivedDate();
        editObject.setMaxArchivedDate(maxArchivedDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_ARCHIVED_DATE, oldValue, maxArchivedDate);
    }

    public Date getMinReplyDate() {
        return editObject.getMinReplyDate();
    }

    public void setMinReplyDate(Date minReplyDate) {
        Object oldValue = getMinReplyDate();
        editObject.setMinReplyDate(minReplyDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_REPLY_DATE, oldValue, minReplyDate);
    }

    public Date getMaxReplyDate() {
        return editObject.getMaxReplyDate();
    }

    public void setMaxReplyDate(Date maxReplyDate) {
        Object oldValue = getMaxReplyDate();
        editObject.setMaxReplyDate(maxReplyDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_REPLY_DATE, oldValue, maxReplyDate);
    }
    
    public Date getMinTransferDate() {
        return editObject.getMinTransferDate();
    }

    public void setMinTransferDate(Date minTransferDate) {
        Object oldValue = getMinTransferDate();
        editObject.setMinTransferDate(minTransferDate);
        firePropertyChanged(EmailFilter.PROPERTY_MIN_TRANSFER_DATE, oldValue, minTransferDate);
    }
    
    public Date getMaxTransferDate() {
        return editObject.getMaxTransferDate();
    }

    public void setMaxTransferDate(Date maxTransferDate) {
        Object oldValue = getMaxTransferDate();
        editObject.setMaxTransferDate(maxTransferDate);
        firePropertyChanged(EmailFilter.PROPERTY_MAX_TRANSFER_DATE, oldValue, maxTransferDate);
    }
    
    public List<Range> getGamme() {
        return editObject.getGamme();
    }
    
    public void setGamme(List<Range> gamme) {
        editObject.setGamme(gamme);
        firePropertyChanged(EmailFilter.PROPERTY_GAMME, null, gamme);
    }

    public List<DemandeUIModel> getResults() {
        return results;
    }

    public void setResults(List<DemandeUIModel> results) {
        this.results = results;
        firePropertyChanged(PROPERTY_RESULTS, null, results);
    }

    public boolean isMenuEnabled() {
        return menuEnabled;
    }

    public void setMenuEnabled(boolean menuEnabled) {
        Object oldValue = isMenuEnabled();
        this.menuEnabled = menuEnabled;
        firePropertyChanged(PROPERTY_MENU_ENABLED, oldValue, menuEnabled);
    }

    public boolean isGroupEnabled() {
        return groupEnabled;
    }

    public void setGroupEnabled(boolean groupEnabled) {
        Object oldValue = isGroupEnabled();
        this.groupEnabled = groupEnabled;
        firePropertyChanged(PROPERTY_GROUP_ENABLED, oldValue, groupEnabled);
    }

    public boolean isShowGroupesDemandsInResults() {
        return showGroupesDemandsInResults;
    }

    public void setShowGroupesDemandsInResults(boolean showGroupesDemandsInResults) {
        this.showGroupesDemandsInResults = showGroupesDemandsInResults;
    }

    @Override
    protected EmailFilter newEntity() {
        return new EmailFilter();
    }
}
