package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ReplyFormUIModel.java 82 2014-05-20 14:25:32Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/reply/ReplyFormUIModel.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ReplyFormUIModel extends AbstractSerializableBean {

    private static final Log log = LogFactory.getLog(ReplyFormUIModel.class);

    public static final String PROPERTY_TO = "to";
    public static final String PROPERTY_FROM = "from";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_ORIGINAL_DEMAND = "originalDemand";
    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_READONLY = "readonly";
    public static final String PROPERTY_MAX_ATTACHMENT_LENGHT = "maxAttachmentLength";
    public static final String PROPERTY_TOTAL_ATTACHMENT_LENGHT = "totalAttachmentLength";
    public static final String PROPERTY_VALID = "valid";

    protected String to;
    protected String from;
    protected String subject;
    protected String message;
    protected DemandeUIModel originalDemand;
    protected long maxAttachmentLength = 0;
    protected long totalAttachmentLength = 0;
    protected boolean valid = true;
    protected boolean readonly = false;

    protected Set<AttachmentFile> attachments = new HashSet<AttachmentFile>();
    protected Set<AttachmentFile> availableAttachments = new HashSet<AttachmentFile>();

    protected File lastVisitedDirectory = FileUtils.getUserDirectory();

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        Object oldValue = getTo();
        this.to = to;
        firePropertyChange(PROPERTY_TO, oldValue, to);
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        Object oldValue = getFrom();
        this.from = from;
        firePropertyChange(PROPERTY_FROM, oldValue, from);
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        Object oldValue = getSubject();
        this.subject = subject;
        firePropertyChange(PROPERTY_SUBJECT, oldValue, subject);
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        Object oldValue = getMessage();
        this.message = message;
        firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public DemandeUIModel getOriginalDemand() {
        return originalDemand;
    }

    public void setOriginalDemand(DemandeUIModel originalDemand) {
        Object oldValue = getOriginalDemand();
        this.originalDemand = originalDemand;
        firePropertyChange(PROPERTY_ORIGINAL_DEMAND, oldValue, originalDemand);
    }

    public Set<AttachmentFile> getAttachments() {
        return attachments;
    }

    public void addAttachment(AttachmentFile attachment) {
        attachments.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachments());

        Object oldValue = getTotalAttachmentLength();
        totalAttachmentLength += attachment.getLength();
        firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGHT, oldValue, getTotalAttachmentLength());

        recomputeValidity();
    }

    public void removeAttachment(AttachmentFile attachment) {
        attachments.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachments());

        Object oldValue = getTotalAttachmentLength();
        totalAttachmentLength -= attachment.getLength();
        firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGHT, oldValue, getTotalAttachmentLength());

        recomputeValidity();
    }

    public Set<AttachmentFile> getAvailableAttachments() {
        return availableAttachments;
    }

    public void addAvailableAttachment(AttachmentFile attachment) {
        availableAttachments.add(attachment);
    }

    public void removeAvailableAttachment(AttachmentFile attachment) {
        availableAttachments.remove(attachment);
    }

    public File getLastVisitedDirectory() {
        return lastVisitedDirectory;
    }

    public void setLastVisitedDirectory(File lastVisitedDirectory) {
        this.lastVisitedDirectory = lastVisitedDirectory;
    }

    public boolean isReadonly() {
        return readonly;
    }

    public void setReadonly(boolean readonly) {
        Object oldValue = isReadonly();
        this.readonly = readonly;
        firePropertyChange(PROPERTY_READONLY, oldValue, readonly);
    }

    public long getMaxAttachmentLength() {
        return maxAttachmentLength / 1024;
    }

    public void setMaxAttachmentLength(long maxAttachmentLength) {
        Object oldValue = getMaxAttachmentLength();
        this.maxAttachmentLength = maxAttachmentLength;
        firePropertyChange(PROPERTY_MAX_ATTACHMENT_LENGHT, oldValue, maxAttachmentLength);

        recomputeValidity();
    }

    public long getTotalAttachmentLength() {
        return totalAttachmentLength / 1024;
    }

    public boolean isValid() {
        return valid;
    }

    public void setValid(boolean valid) {
        Object oldValue = isValid();
        this.valid = valid;
        firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public void recomputeValidity() {
        setValid(totalAttachmentLength < maxAttachmentLength);

    }
}
