package com.franciaflex.faxtomail.ui.swing.content.print;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class AttachmentToPrintChooserUI extends JPanel implements FaxToMailUI<AttachmentToPrintChooserUIModel, AttachmentToPrintChooserUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz08TQRR+rbT8FpUIGDGpygESMsUYTxgFUSJYlAgmxF6c7g50zOzOuDOFJUTjn+CfoHcvJt48GQ+ePXgx/gvGePBqfLPb7tJSUog27ab7fnzvzTffe29/QE4HcPEpDUMS1HzDPUaW5zc2HlSeMsfcZtoJuDIygPiTyUK2DP1uYtcGLpdLNr1YTy8uSE9Jn/n7smdL0KfNrmC6ypgxcKE5w9G6uJa4Z0NVCxqoSVPtUF//+pl95b58kwUIFXbXg0cpdMpKT9JVgix3DZzBStu0KKi/hW0E3N/CfgetbUFQre9Tjz2DF9BdgryiAYIZuHT0I0cYUX6oDIxRY6hT9TB2Xa5iLbNQlVKzwMA9R3pkM6C+w+mmYCHZpKGRHuWC1DjRO9gXcaRvMJUom0nmD8F6tKRUVDJvIOdJlwkDq/8RfcVCpiW6PaY13WLIpCUtrKMtl2iFCRvTm4QOTiyvOYEUYpX6bMbAaFNC6mrOGkpJs07RWigy2tgzSUrPRGydse+jzXADDrLAxK2aMXhgGG7Ciq02cixJOLlNBXepYalzvB4RwPkmwaGUSSrlVGuZMuSCGppRAuWD6n+Irlj3Yy26t4CR98/I8NcP398vNsSex9pn24bum1UUoQqkQnlxW3ooVnrNcFFcoWq2DL2aCRz0aJDH2zS2Vndjc1jvtE0nNp3cpbqKELnubx8/jTz5cgKyi9AnJHUXqY1fgl5TDZAFKdxQ3ZyLOhrY6cHnKfxlDXQZFuIkTaU6dCJ9HZAdSeSVr8jAtaMyu1fYf2m3InNceJc4AcOruuMpsxs7Jq9NF+rfqcLzEEkeb0NyctJK7+ffw2vv5hpEZ/Dg5w4NT8nOPYY89wX3WbRX6iuj7R7pV5rVXJmuhnbLAtLJUvVhm4iekwfoPJHQWexMJ9LEpU/iITDQF78v2eGHfMPab6QU61ytR6hXj4lKDFdhzfZKIgLtvxlombxOh+rC8zOfVgTDHT29V7gYbTKCQkir63r5ySnCdXTlk3jFCRtXjtx3Y8Jb+OhJ7c2MXDs28mGctCyXTqxk8JIE3ZUYDCevYx4tVLjv4hjcOICesc++jojWvGIf99sjjPwzwjlE+Atn80oWawgAAA==";
    private static final Log log = LogFactory.getLog(AttachmentToPrintChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel attachmentPanel;
    protected AttachmentToPrintChooserUI attachmentToPrintChooser = this;
    protected JButton cancelButton;
    protected final AttachmentToPrintChooserUIHandler handler = new AttachmentToPrintChooserUIHandler();
    protected JLabel message;
    protected AttachmentToPrintChooserUIModel model;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentToPrintChooserUI(FaxToMailUI parentUI, DemandeUIModel demande) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
                AttachmentToPrintChooserUIModel model = new AttachmentToPrintChooserUIModel();
                model.setDemand(demande);
                setContextValue(model);
            $initialize();
    }

    public AttachmentToPrintChooserUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI() {
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getAttachmentPanel() {
        return attachmentPanel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public AttachmentToPrintChooserUIHandler getHandler() {
        return handler;
    }

    public JLabel getMessage() {
        return message;
    }

    public AttachmentToPrintChooserUIModel getModel() {
        return model;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(AttachmentToPrintChooserUIModel model) {
        AttachmentToPrintChooserUIModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentToPrintChooser() {
        if (!allComponentsCreated) {
            return;
        }
        add(message, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAttachmentPanel() {
        $objectMap.put("attachmentPanel", attachmentPanel = new JPanel());
        
        attachmentPanel.setName("attachmentPanel");
        attachmentPanel.setLayout( new BoxLayout(attachmentPanel, BoxLayout.Y_AXIS) );
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.chooseAttachmentToPrint.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.chooseAttachmentToPrint.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
        message.setText(t("faxtomail.chooseAttachmentToPrint.message"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AttachmentToPrintChooserUIModel.class));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.chooseAttachmentToPrint.action.validate"));
        validateButton.setToolTipText(t("faxtomail.chooseAttachmentToPrint.action.validate.tip"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentToPrintChooser();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(attachmentPanel);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        message.setBorder( javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5) );
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentToPrintChooser", attachmentToPrintChooser);
        createModel();
        createMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAttachmentPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout( new GridLayout(1, 0) );
        createCancelButton();
        createValidateButton();
        // inline creation of attachmentToPrintChooser
        setName("attachmentToPrintChooser");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachmentsToPrint", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachmentsToPrint() != null) {
                    validateButton.setEnabled( !model.getAttachmentsToPrint().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachmentsToPrint", this);
                }
            }
        });
    }

}