package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: PDFEditorUIModel.java 83 2014-05-20 21:03:58Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/pdfeditor/PDFEditorUIModel.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;

import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class PDFEditorUIModel extends AbstractFaxToMailBeanUIModel<Attachment, PDFEditorUIModel> {

    public static final String PROPERTY_PAGES = "pages";
    public static final String PROPERTY_CURRENT_PAGE_INDEX = "currentPageIndex";
    public static final String PROPERTY_ZOOM = "zoom";
    public static final String PROPERTY_ROTATION = "rotation";

    protected final Attachment editObject = new AttachmentImpl();

    public class Page {

        protected List<PDFEditorNoteUI> notes = new ArrayList<PDFEditorNoteUI>();
        protected List<PDFEditorCrossUI> crosses = new ArrayList<PDFEditorCrossUI>();
        protected List<PDFEditorLineUI> lines = new ArrayList<PDFEditorLineUI>();
        protected List<PDFEditorHighlighterUI> highlighters = new ArrayList<PDFEditorHighlighterUI>();

        public List<PDFEditorNoteUI> getNotes() {
            return notes;
        }

        public void addNote(PDFEditorNoteUI note) {
            notes.add(note);
        }

        public void removeNote(PDFEditorNoteUI note) {
            notes.remove(note);
        }

        public List<PDFEditorCrossUI> getCrosses() {
            return crosses;
        }

        public void addCross(PDFEditorCrossUI cross) {
            crosses.add(cross);
        }

        public void removeCross(PDFEditorCrossUI cross) {
            crosses.remove(cross);
        }

        public List<PDFEditorLineUI> getLines() {
            return lines;
        }

        public void addLine(PDFEditorLineUI line) {
            lines.add(line);
        }

        public void removeLine(PDFEditorLineUI line) {
            lines.remove(line);
        }

        public List<PDFEditorHighlighterUI> getHighlighters() {
            return highlighters;
        }

        public void addHighlighter(PDFEditorHighlighterUI highlighter) {
            highlighters.add(highlighter);
        }

        public void removeHighlighter(PDFEditorHighlighterUI highlighter) {
            highlighters.remove(highlighter);
        }
    }

    protected Page[] pages;

    // first page is 1 not 0
    protected int currentPageIndex = -1;

    protected float zoom = 1.0f;

    protected int rotation = 0;

    protected static Binder<PDFEditorUIModel, Attachment> toBeanBinder =
            BinderFactory.newBinder(PDFEditorUIModel.class,
                                    Attachment.class);

    protected static Binder<Attachment, PDFEditorUIModel> fromBeanBinder =
            BinderFactory.newBinder(Attachment.class, PDFEditorUIModel.class);

    public PDFEditorUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    public void setOriginalFile(AttachmentFile file) {
        Object oldValue = getOriginalFile();
        editObject.setOriginalFile(file);
        firePropertyChange(Attachment.PROPERTY_ORIGINAL_FILE, oldValue, file);
    }

    public AttachmentFile getOriginalFile() {
        return editObject.getOriginalFile();
    }

    public void setEditedFile(AttachmentFile file) {
        Object oldValue = getEditedFile();
        editObject.setEditedFile(file);
        firePropertyChange(Attachment.PROPERTY_EDITED_FILE, oldValue, file);
    }

    public AttachmentFile getEditedFile() {
        return editObject.getEditedFile();
    }

    public AttachmentFile getNotNullFile() {
        AttachmentFile file = getEditedFile();
        if (file == null) {
            file = getOriginalFile();
        }
        return file;
    }

    public String getTopiaId() {
        return editObject.getTopiaId();
    }

    public void setTopiaId(String id) {
        Object oldValue = getTopiaId();
        editObject.setTopiaId(id);
        firePropertyChange(Attachment.PROPERTY_TOPIA_ID, oldValue, id);
    }

    public Page[] getPages() {
        return pages;
    }

    public void setPageNumber(int nb) {
        pages = new Page[nb];
        for (int i = 0 ; i < nb ; i++) {
            pages[i] = new Page();
        }
        firePropertyChanged(PROPERTY_PAGES, null, pages);
    }

    public Page getCurrentPage() {
        if (pages == null || currentPageIndex < 1 || currentPageIndex > pages.length) {
            return null;
        }
        return pages[currentPageIndex - 1];
    }

    public Page getPage(int i) {
        if (pages == null || i < 1 || i > pages.length) {
            return null;
        }
        return pages[i - 1];
    }

    public int getCurrentPageIndex() {
        return currentPageIndex;
    }

    public void setCurrentPageIndex(int currentPageIndex) {
        Object oldValue = getCurrentPageIndex();
        currentPageIndex = Math.max(1, currentPageIndex);
        if (pages != null) {
            currentPageIndex = Math.min(pages.length, currentPageIndex);
        }
        this.currentPageIndex = currentPageIndex;
        firePropertyChange(PROPERTY_CURRENT_PAGE_INDEX, oldValue, currentPageIndex);
    }

    public void decPageIndex() {
        setCurrentPageIndex(currentPageIndex - 1);
    }

    public void incPageIndex() {
        setCurrentPageIndex(currentPageIndex + 1);
    }

    public float getZoom() {
        return zoom;
    }

    public void setZoom(float zoom) {
        if (zoom > 0) {
            Object oldValue = getZoom();
            this.zoom = zoom;
            firePropertyChanged(PROPERTY_ZOOM, oldValue, zoom);
        }
    }

    public int getRotation() {
        return rotation;
    }

    public void setRotation(int rotation) {
        Object oldValue = getRotation();
        this.rotation = rotation;
        firePropertyChanged(PROPERTY_ROTATION, oldValue, rotation);
    }

    @Override
    protected Attachment newEntity() {
        return new AttachmentImpl();
    }
}
