package com.franciaflex.faxtomail.ui.swing.content.demande.history;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ButtonHistory.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/demande/history/ButtonHistory.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupButton;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;

import static org.nuiton.i18n.I18n.t;

/**
 * Button to edit attachments.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class ButtonHistory extends AbstractToolbarPopupButton<HistoryListUI> {

    public ButtonHistory() {
        setToolTipText(t("faxtomail.historyList.action.tip"));
        int historySize = popup.getModel().sizeHistory();
        setText(t("faxtomail.historyList.text", historySize));

        popup.getModel().addPropertyChangeListener(Email.PROPERTY_HISTORY, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Collection<History> history = (Collection<History>) evt.getNewValue();
                if (history != null) {
                    setText(t("faxtomail.historyList.text", history.size()));
                }
            }
        });
    }

    @Override
    protected String getActionIcon() {
        return "view-history";
    }

    @Override
    protected HistoryListUI createNewPopup() {
        return new HistoryListUI(FaxToMailUIContext.getApplicationContext());
    }

}
