package com.franciaflex.faxtomail.ui.swing;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.actions.StartAction;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailExceptionHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.itextpdf.text.*;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import javax.swing.plaf.BorderUIResource;
import java.awt.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.1
 */
public class RunFaxToMail {

    /** Logger. */
    private static final Log log = LogFactory.getLog(RunFaxToMail.class);

    public static final int NORMAL_EXIT_CODE = 0;

    public static final int UPATE_EXIT_CODE = 88;

    public static void main(String... args) {

        if (log.isInfoEnabled()) {
            log.info("Starting FaxToMail with arguments: " + Arrays.toString(args));
        }

        // Create configuration
        FaxToMailConfiguration config =
                new FaxToMailConfiguration("faxToMail.properties", args);

        // Create application context
        FaxToMailUIContext context = FaxToMailUIContext.newContext(config);

        // override default exception management (after config init)
        Thread.setDefaultUncaughtExceptionHandler(new FaxToMailExceptionHandler(context.getErrorHelper()));
        // See http://forge.codelutin.com/issues/2055
        //System.setProperty("sun.awt.exception.handler", TuttiExceptionHandler.class.getName());

        // prepare context (mainly init configs, i18n)
        context.init();

        // Prepare ui look&feel and load ui properties
        try {
            SwingUtil.initNimbusLoookAndFeel();
        } catch (Exception e) {
            // could not find nimbus look-and-feel
            if (log.isWarnEnabled()) {
                log.warn("Failed to init nimbus look and feel", e);
            }
        }

        boolean reload = false;

        if (config.isFullLaunchMode()) {

            if (log.isInfoEnabled()) {
                log.info("Full launch mode, try to update.");
            }

            // check application url is reachable
//            boolean canUpdateApplication = context.checkUpdateApplicationReachable();

//            if (canUpdateApplication) {
//                // try to update jre - i18n - application - help and exit if so
//                UpdateApplicationAction logicAction = TuttiActionHelper.createLogicAction(new MainUIHandler(context),
//                                                                                          UpdateApplicationAction.class);
//                TuttiActionHelper.runActionAndWait(logicAction);
//
//                reload = logicAction.isReload();
//            }

            // check data url is reachable
//            boolean canUpdateData = context.checkUpdateDataReachable();

//            if (canUpdateData) {
//                // try to update report and exit if so
//                UpdateReportAction logicAction = TuttiActionHelper.createLogicAction(new MainUIHandler(context),
//                                                                                     UpdateReportAction.class);
//                TuttiActionHelper.runActionAndWait(logicAction);
//
//                reload |= logicAction.isReload();
//            }
        }

        if (!reload) {
            if (log.isInfoEnabled()) {
                log.info("Will start FaxToMail...");
            }
            startFaxToMail(context, true);
        }

    }

    public static void startFaxToMail(FaxToMailUIContext context, boolean openContext) {

        if (openContext) {
            context.open();
        }

//        UIManager.put("Table.alternateRowColor", context.getConfig().getColorAlternateRow());
//        UIManager.put("Table[Disabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
//        UIManager.put("Table[Enabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));

        final MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                mainUI.setVisible(true);
            }
        });

        // launch start action (use the tutti-start-action file)
        StartAction uiAction = context.getActionFactory().createLogicAction(
                mainUI.getHandler(), StartAction.class);
        context.getActionEngine().runAction(uiAction);
    }

    public static void closeFaxToMail(MainUIHandler handler, Integer exitCode) {

        FaxToMailUIContext context = handler.getContext();

        // close ui
        handler.onCloseUI();

        //close context
        try {
            context.getSwingSession().save();

        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("error while saving the swing session", e);
            }
        }
        context.close();

        if (exitCode != null) {
            System.exit(exitCode);
        }
    }

}