/* The following code was generated by JFlex 1.4.1 on 4/22/13 10:43 PM */

/*
 * 02/05/2012
 *
 * JavaScriptTokenMaker.java - Parses a document into JavaScript tokens.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for JavaScript files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated JavaScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class JavaScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int E4X = 6;
  public static final int E4X_INTAG = 10;
  public static final int E4X_PI = 8;
  public static final int JS_MLC = 3;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 5;
  public static final int E4X_COMMENT = 7;
  public static final int JS_DOCCOMMENT = 4;
  public static final int E4X_DTD = 9;
  public static final int E4X_INATTR_SINGLE = 12;
  public static final int E4X_INATTR_DOUBLE = 11;
  public static final int YYINITIAL = 0;
  public static final int E4X_CDATA = 13;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\73\1\2\1\0\1\1\1\11\22\0\1\73\1\36\1\75"+
    "\1\12\1\15\1\35\1\40\1\105\2\104\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\41\1\74\1\31\1\32\1\34"+
    "\1\37\1\44\1\101\1\6\1\77\1\100\1\23\1\22\2\3\1\110"+
    "\2\3\1\21\1\3\1\107\5\3\1\102\3\3\1\20\2\3\1\76"+
    "\1\13\1\103\1\33\1\14\1\0\1\45\1\46\1\52\1\64\1\53"+
    "\1\67\1\56\1\60\1\55\1\3\1\63\1\54\1\43\1\57\1\61"+
    "\1\65\1\72\1\51\1\47\1\50\1\10\1\70\1\62\1\71\1\66"+
    "\1\106\1\111\1\33\1\26\1\42\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\2\1\1\0\1\2\1\3\1\4\1\5\2\6"+
    "\1\5\1\2\3\7\1\5\1\10\1\5\6\7\1\2"+
    "\20\5\1\11\1\12\2\5\1\1\1\13\1\14\1\15"+
    "\1\1\1\16\1\17\1\20\1\1\1\21\5\1\1\22"+
    "\10\1\1\23\2\5\1\24\1\25\1\26\1\27\1\1"+
    "\1\30\5\1\1\31\2\1\1\32\1\1\1\33\1\34"+
    "\1\35\2\36\1\37\1\40\1\41\1\42\1\1\1\43"+
    "\3\1\1\2\1\44\1\6\1\45\1\44\1\45\1\44"+
    "\1\46\1\44\1\5\2\0\1\47\1\50\2\7\2\0"+
    "\1\51\1\7\1\52\33\5\2\53\7\5\1\53\13\5"+
    "\1\54\1\55\1\56\1\57\4\0\1\60\2\0\1\61"+
    "\26\0\1\62\1\25\1\63\1\64\1\26\5\0\1\65"+
    "\2\0\1\2\1\45\1\0\2\46\1\5\1\66\1\67"+
    "\32\5\1\70\5\5\1\71\25\5\60\0\1\72\2\0"+
    "\1\73\5\0\1\74\1\2\1\75\3\5\1\71\3\5"+
    "\1\76\6\5\1\77\1\5\1\100\24\5\1\0\1\1"+
    "\1\0\1\101\15\0\1\102\45\0\1\103\3\0\1\104"+
    "\2\0\1\105\1\0\1\106\1\2\5\5\1\53\17\5"+
    "\1\53\1\5\15\0\1\102\20\0\1\102\16\0\1\2"+
    "\4\5\1\107\13\5\33\0\10\5\1\102\4\0\1\102"+
    "\12\0\3\5\6\0\1\5\2\0\1\110\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[603];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\112\0\224\0\336\0\u0128\0\u0172\0\u01bc\0\u0206"+
    "\0\u0250\0\u029a\0\u02e4\0\u032e\0\u0378\0\u03c2\0\u040c\0\u0456"+
    "\0\u04a0\0\u04ea\0\u0534\0\u057e\0\u05c8\0\u04a0\0\u0612\0\u065c"+
    "\0\u06a6\0\u06f0\0\u04a0\0\u04a0\0\u073a\0\u0784\0\u07ce\0\u0818"+
    "\0\u04a0\0\u0862\0\u08ac\0\u08f6\0\u0940\0\u098a\0\u09d4\0\u0a1e"+
    "\0\u0a68\0\u0ab2\0\u0afc\0\u0b46\0\u0b90\0\u0bda\0\u0c24\0\u0c6e"+
    "\0\u0cb8\0\u0d02\0\u0d4c\0\u04a0\0\u04a0\0\u0d96\0\u0de0\0\u0e2a"+
    "\0\u04a0\0\u0e74\0\u04a0\0\u0ebe\0\u04a0\0\u0e74\0\u04a0\0\u0f08"+
    "\0\u04a0\0\u0f52\0\u0f9c\0\u0fe6\0\u1030\0\u107a\0\u04a0\0\u10c4"+
    "\0\u110e\0\u1158\0\u11a2\0\u11ec\0\u1236\0\u1280\0\u12ca\0\u04a0"+
    "\0\u1314\0\u135e\0\u04a0\0\u13a8\0\u13f2\0\u04a0\0\u143c\0\u04a0"+
    "\0\u1486\0\u14d0\0\u151a\0\u1564\0\u15ae\0\u04a0\0\u15f8\0\u1642"+
    "\0\u04a0\0\u168c\0\u04a0\0\u04a0\0\u04a0\0\u16d6\0\u1720\0\u176a"+
    "\0\u04a0\0\u04a0\0\u04a0\0\u17b4\0\u04a0\0\u17fe\0\u1848\0\u1892"+
    "\0\u18dc\0\u1926\0\u1926\0\u1926\0\u1970\0\u19ba\0\u1a04\0\u1a4e"+
    "\0\u1a98\0\u1ae2\0\u1b2c\0\u1b76\0\u04a0\0\u1bc0\0\u1b2c\0\u1c0a"+
    "\0\u065c\0\u1c0a\0\u04a0\0\u1c54\0\u1c9e\0\u1ce8\0\u1d32\0\u1d7c"+
    "\0\u1dc6\0\u1e10\0\u1e5a\0\u1ea4\0\u1eee\0\u1f38\0\u1f82\0\u1fcc"+
    "\0\u2016\0\u2060\0\u20aa\0\u20f4\0\u213e\0\u2188\0\u21d2\0\u221c"+
    "\0\u2266\0\u22b0\0\u22fa\0\u2344\0\u238e\0\u23d8\0\u2422\0\u246c"+
    "\0\u24b6\0\u04ea\0\u2500\0\u254a\0\u2594\0\u25de\0\u2628\0\u2672"+
    "\0\u26bc\0\u2706\0\u2750\0\u279a\0\u27e4\0\u282e\0\u2878\0\u28c2"+
    "\0\u290c\0\u2956\0\u29a0\0\u29ea\0\u2a34\0\u04a0\0\u2a7e\0\u2ac8"+
    "\0\u04a0\0\u2b12\0\u2b5c\0\u2ba6\0\u2bf0\0\u04a0\0\u2c3a\0\u2c84"+
    "\0\u04a0\0\u2cce\0\u2d18\0\u2d62\0\u2dac\0\u2df6\0\u2e40\0\u2e8a"+
    "\0\u2ed4\0\u2f1e\0\u2f68\0\u2fb2\0\u2ffc\0\u3046\0\u3090\0\u30da"+
    "\0\u3124\0\u316e\0\u31b8\0\u3202\0\u324c\0\u3296\0\u32e0\0\u332a"+
    "\0\u3374\0\u33be\0\u04a0\0\u04a0\0\u3408\0\u3452\0\u349c\0\u34e6"+
    "\0\u3530\0\u04a0\0\u357a\0\u35c4\0\u360e\0\u3658\0\u36a2\0\u1926"+
    "\0\u36ec\0\u3736\0\u3780\0\u37ca\0\u3814\0\u385e\0\u38a8\0\u38f2"+
    "\0\u393c\0\u3986\0\u39d0\0\u3a1a\0\u3a64\0\u3aae\0\u3af8\0\u3b42"+
    "\0\u3b8c\0\u3bd6\0\u3c20\0\u3c6a\0\u3cb4\0\u3cfe\0\u3d48\0\u3d92"+
    "\0\u3ddc\0\u3e26\0\u3e70\0\u3eba\0\u3f04\0\u3f4e\0\u04ea\0\u3f98"+
    "\0\u3fe2\0\u402c\0\u4076\0\u40c0\0\u410a\0\u4154\0\u419e\0\u41e8"+
    "\0\u4232\0\u427c\0\u42c6\0\u4310\0\u435a\0\u43a4\0\u43ee\0\u4438"+
    "\0\u4482\0\u44cc\0\u4516\0\u4560\0\u45aa\0\u45f4\0\u463e\0\u4688"+
    "\0\u46d2\0\u471c\0\u4766\0\u47b0\0\u47fa\0\u4844\0\u488e\0\u48d8"+
    "\0\u4922\0\u496c\0\u49b6\0\u4a00\0\u4a4a\0\u4a94\0\u4ade\0\u4b28"+
    "\0\u4b72\0\u4bbc\0\u4c06\0\u4c50\0\u4c9a\0\u4ce4\0\u4d2e\0\u4d78"+
    "\0\u4dc2\0\u4e0c\0\u4e56\0\u4ea0\0\u4eea\0\u4f34\0\u4f7e\0\u4fc8"+
    "\0\u5012\0\u505c\0\u50a6\0\u50f0\0\u513a\0\u5184\0\u51ce\0\u5218"+
    "\0\u5262\0\u52ac\0\u52f6\0\u5340\0\u538a\0\u53d4\0\u541e\0\u5468"+
    "\0\u54b2\0\u54fc\0\u5546\0\u5590\0\u55da\0\u04a0\0\u5624\0\u566e"+
    "\0\u56b8\0\u5702\0\u574c\0\u04a0\0\u5796\0\u04a0\0\u57e0\0\u582a"+
    "\0\u5874\0\u04ea\0\u58be\0\u5908\0\u5952\0\u04ea\0\u599c\0\u59e6"+
    "\0\u5a30\0\u5a7a\0\u5ac4\0\u5b0e\0\u04ea\0\u5b58\0\u04ea\0\u5ba2"+
    "\0\u5bec\0\u5c36\0\u5c80\0\u5cca\0\u5d14\0\u5d5e\0\u5da8\0\u5df2"+
    "\0\u5e3c\0\u5e86\0\u5ed0\0\u5f1a\0\u5f64\0\u5fae\0\u5ff8\0\u6042"+
    "\0\u608c\0\u60d6\0\u6120\0\u2ac8\0\u04a0\0\u616a\0\u61b4\0\u61fe"+
    "\0\u6248\0\u6292\0\u62dc\0\u6326\0\u6370\0\u63ba\0\u6404\0\u644e"+
    "\0\u6498\0\u64e2\0\u652c\0\u6576\0\u04a0\0\u65c0\0\u660a\0\u6654"+
    "\0\u669e\0\u66e8\0\u6732\0\u677c\0\u67c6\0\u6810\0\u685a\0\u68a4"+
    "\0\u68ee\0\u6938\0\u6982\0\u69cc\0\u6a16\0\u6a60\0\u6aaa\0\u6af4"+
    "\0\u6b3e\0\u6b88\0\u6bd2\0\u6c1c\0\u6c66\0\u6cb0\0\u6cfa\0\u6d44"+
    "\0\u6d8e\0\u6dd8\0\u6e22\0\u6e6c\0\u6eb6\0\u6f00\0\u6f4a\0\u6f94"+
    "\0\u6fde\0\u7028\0\u7072\0\u70bc\0\u7106\0\u7150\0\u04a0\0\u719a"+
    "\0\u71e4\0\u722e\0\u7278\0\u04a0\0\u72c2\0\u730c\0\u7356\0\u73a0"+
    "\0\u73ea\0\u7434\0\u3b8c\0\u747e\0\u74c8\0\u7512\0\u755c\0\u75a6"+
    "\0\u75f0\0\u763a\0\u7684\0\u76ce\0\u7718\0\u7762\0\u77ac\0\u77f6"+
    "\0\u7840\0\u788a\0\u78d4\0\u791e\0\u61b4\0\u7968\0\u79b2\0\u79fc"+
    "\0\u7a46\0\u7a90\0\u7ada\0\u7b24\0\u7b6e\0\u7bb8\0\u7c02\0\u7c4c"+
    "\0\u7c96\0\u7ce0\0\u7d2a\0\u7d74\0\u7dbe\0\u7e08\0\u7e52\0\u7e9c"+
    "\0\u7ee6\0\u7f30\0\u7f7a\0\u7fc4\0\u800e\0\u8058\0\u80a2\0\u80ec"+
    "\0\u8136\0\u8180\0\u81ca\0\u8214\0\u825e\0\u82a8\0\u82f2\0\u833c"+
    "\0\u8386\0\u83d0\0\u7072\0\u841a\0\u8464\0\u84ae\0\u84f8\0\u722e"+
    "\0\u8542\0\u858c\0\u85d6\0\u8620\0\u866a\0\u86b4\0\u04ea\0\u86fe"+
    "\0\u8748\0\u8792\0\u87dc\0\u8826\0\u8870\0\u88ba\0\u8904\0\u894e"+
    "\0\u8998\0\u89e2\0\u8a2c\0\u8a76\0\u8ac0\0\u8b0a\0\u8b54\0\u8b9e"+
    "\0\u8be8\0\u8c32\0\u8c7c\0\u8cc6\0\u8d10\0\u8d5a\0\u8da4\0\u8dee"+
    "\0\u8e38\0\u8e82\0\u8ecc\0\u8f16\0\u8f60\0\u8faa\0\u8ff4\0\u903e"+
    "\0\u9088\0\u90d2\0\u911c\0\u9166\0\u91b0\0\u91fa\0\u9244\0\u928e"+
    "\0\u92d8\0\u9322\0\u936c\0\u93b6\0\u9400\0\u944a\0\u9494\0\u94de"+
    "\0\u9528\0\u9572\0\u6654\0\u95bc\0\u9606\0\u9650\0\u969a\0\u96e4"+
    "\0\u972e\0\u9778\0\u97c2\0\u980c\0\u9856\0\u98a0\0\u98ea\0\u9934"+
    "\0\u997e\0\u99c8\0\u9a12\0\u9a5c\0\u9aa6\0\u9af0\0\u9b3a\0\u9b84"+
    "\0\u9bce\0\u04a0\0\u9c18";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[603];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\22\1\23"+
    "\1\25\1\26\2\17\2\22\1\27\1\30\4\22\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\30\1\40"+
    "\2\30\1\41\1\42\2\41\1\22\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\2\22\1\57\1\22\1\60\1\61\1\22\1\62"+
    "\1\63\2\22\1\20\1\34\1\64\1\33\4\22\2\33"+
    "\1\65\1\22\1\66\1\67\1\33\2\70\1\71\10\70"+
    "\1\72\61\70\1\73\14\70\2\74\1\75\10\74\1\76"+
    "\71\74\1\77\4\74\2\100\1\101\14\100\1\102\40\100"+
    "\1\103\1\100\1\104\4\100\1\105\22\100\2\106\1\107"+
    "\14\106\1\110\11\106\1\111\12\106\1\112\13\106\1\113"+
    "\1\106\1\114\4\106\1\115\21\106\1\116\2\117\1\120"+
    "\55\117\1\103\1\117\1\104\4\117\1\105\22\117\1\121"+
    "\1\122\1\123\26\121\1\124\6\121\1\125\32\121\1\20"+
    "\1\126\15\121\2\127\1\130\21\127\1\131\33\127\1\132"+
    "\1\127\1\133\4\127\1\134\22\127\2\135\1\136\34\135"+
    "\1\137\52\135\2\140\1\141\26\140\1\142\2\140\1\143"+
    "\41\140\1\144\4\140\1\145\6\140\1\146\1\147\1\0"+
    "\13\146\1\150\13\146\1\41\1\146\1\151\36\146\1\20"+
    "\1\146\1\152\7\146\1\153\4\146\75\154\1\155\14\154"+
    "\105\156\1\155\4\156\103\157\1\160\6\157\1\17\2\0"+
    "\6\17\1\0\4\17\2\0\4\17\17\0\30\17\4\0"+
    "\4\17\3\0\3\17\2\0\1\20\71\0\1\20\130\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\26\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\162\2\0\1\162\2\23\1\162\1\23"+
    "\1\162\1\0\4\162\2\0\1\162\1\163\1\164\1\165"+
    "\1\0\1\166\15\0\10\162\1\165\1\163\7\162\1\164"+
    "\2\162\1\164\3\162\4\0\1\162\1\164\2\162\3\0"+
    "\3\162\1\0\1\162\2\0\1\162\1\167\1\170\1\162"+
    "\1\170\1\162\1\0\4\162\2\0\1\171\1\163\1\164"+
    "\1\165\1\0\1\166\15\0\10\162\1\165\1\163\7\162"+
    "\1\164\2\162\1\164\1\162\1\171\1\162\4\0\1\162"+
    "\1\164\2\162\3\0\3\162\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\12\22\1\172\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\13\173\1\174\2\173\1\175\1\176\12\173\1\177"+
    "\57\173\32\0\1\41\103\0\1\41\5\0\1\41\63\0"+
    "\2\166\1\0\1\166\132\0\1\41\1\0\1\200\110\0"+
    "\1\201\1\41\60\0\1\202\27\0\1\203\1\41\40\0"+
    "\1\202\50\0\1\41\1\0\1\204\107\0\1\41\5\0"+
    "\1\41\51\0\1\17\2\0\1\205\2\17\1\205\1\17"+
    "\1\205\1\0\4\17\2\0\4\205\17\0\1\205\1\17"+
    "\26\205\4\0\4\205\3\0\3\205\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\1\22\1\206\24\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\4\22\1\207"+
    "\7\22\1\210\4\22\1\211\4\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\5\22\1\212\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\3\22"+
    "\1\213\7\22\1\214\1\22\1\215\3\22\1\216\4\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\4\22\1\217\6\22\1\220\5\22\1\221\4\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\6\22\1\222\17\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\1\223\6\22\1\224"+
    "\3\22\1\225\1\226\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\1\227\1\22\1\230"+
    "\4\22\1\231\2\22\1\232\10\22\1\233\1\234\1\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\6\22\1\235\5\22\1\236\11\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\237\1\17\2\22"+
    "\1\240\7\22\1\241\7\22\1\242\3\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\14\22"+
    "\1\243\11\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\5\22\1\244\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\245\5\22\1\246\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\10\22\1\247\2\22\1\250\12\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\6\22"+
    "\1\251\5\22\1\252\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\5\22\1\253\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\1\254\3\22"+
    "\1\255\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\5\22\1\256\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\257\6\22\1\260\1\261"+
    "\3\22\1\262\11\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\262\13\22\1\263\11\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\1\264\25\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\265\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\2\70\1\0\10\70\1\0"+
    "\61\70\1\0\14\70\2\266\1\0\5\266\1\267\60\266"+
    "\1\270\20\266\2\74\1\0\10\74\1\0\71\74\1\0"+
    "\4\74\2\100\1\0\14\100\1\0\40\100\1\0\1\100"+
    "\1\0\4\100\1\0\22\100\16\0\1\271\143\0\1\272"+
    "\123\0\1\273\77\0\1\274\4\0\1\275\34\0\2\106"+
    "\1\0\14\106\1\0\11\106\1\0\12\106\1\0\13\106"+
    "\1\0\1\106\1\0\4\106\1\0\21\106\17\0\1\276"+
    "\76\0\1\277\2\0\1\277\1\0\1\277\5\0\1\300"+
    "\1\0\4\277\10\0\1\301\6\0\1\277\1\0\26\277"+
    "\4\0\4\277\3\0\3\277\44\0\1\302\1\0\1\303"+
    "\1\304\1\305\1\306\1\307\1\310\1\311\1\312\1\313"+
    "\1\314\1\315\3\0\1\316\1\317\1\320\1\0\1\321"+
    "\1\322\71\0\1\323\123\0\1\324\77\0\1\325\4\0"+
    "\1\326\100\0\1\327\45\0\2\117\1\0\55\117\1\0"+
    "\1\117\1\0\4\117\1\0\22\117\2\121\1\0\26\121"+
    "\1\0\6\121\1\0\32\121\2\0\16\121\1\122\1\0"+
    "\26\121\1\0\6\121\1\0\32\121\1\20\1\0\15\121"+
    "\3\0\1\330\2\0\1\330\1\0\1\330\3\0\1\330"+
    "\1\0\1\331\1\0\4\330\12\0\1\332\1\333\1\0"+
    "\1\330\1\0\1\330\1\0\26\330\4\0\4\330\3\0"+
    "\3\330\1\0\73\125\1\0\1\334\15\125\2\127\1\0"+
    "\21\127\1\0\33\127\1\0\1\127\1\0\4\127\1\0"+
    "\22\127\24\0\1\335\135\0\1\336\123\0\1\337\77\0"+
    "\1\340\4\0\1\341\34\0\2\135\1\0\34\135\1\0"+
    "\52\135\34\0\1\342\55\0\2\140\1\0\26\140\1\0"+
    "\2\140\1\0\41\140\1\0\4\140\1\0\6\140\36\0"+
    "\1\343\53\0\2\146\1\0\13\146\1\0\13\146\1\0"+
    "\1\146\1\0\36\146\1\0\1\146\1\0\7\146\1\0"+
    "\5\146\1\147\1\0\13\146\1\0\13\146\1\0\1\146"+
    "\1\0\36\146\1\20\1\146\1\0\7\146\1\0\4\146"+
    "\34\0\1\151\55\0\75\154\1\0\14\154\105\156\1\0"+
    "\4\156\103\157\1\0\6\157\103\0\1\344\6\0\1\17"+
    "\2\0\5\17\1\345\1\0\4\17\2\0\4\17\17\0"+
    "\30\17\4\0\4\17\3\0\3\17\1\0\1\162\2\0"+
    "\6\162\1\0\4\162\2\0\4\162\17\0\30\162\4\0"+
    "\4\162\3\0\3\162\1\0\1\162\2\0\1\162\2\346"+
    "\1\162\1\346\1\162\1\0\4\162\2\0\4\162\1\347"+
    "\3\0\1\347\12\0\30\162\4\0\4\162\3\0\3\162"+
    "\1\0\1\162\2\0\1\162\2\166\1\162\1\166\1\162"+
    "\1\0\4\162\2\0\2\162\1\164\1\165\17\0\10\162"+
    "\1\165\10\162\1\164\2\162\1\164\3\162\4\0\1\162"+
    "\1\164\2\162\3\0\3\162\1\0\1\162\2\0\1\162"+
    "\2\167\1\162\1\167\1\162\1\0\4\162\2\0\2\162"+
    "\1\164\1\165\1\0\1\166\15\0\10\162\1\165\10\162"+
    "\1\164\2\162\1\164\3\162\4\0\1\162\1\164\2\162"+
    "\3\0\3\162\1\0\1\162\2\0\1\162\1\167\1\170"+
    "\1\162\1\170\1\162\1\0\4\162\2\0\1\162\1\350"+
    "\1\164\1\165\1\0\1\166\15\0\10\162\1\165\1\350"+
    "\7\162\1\164\2\162\1\164\3\162\4\0\1\162\1\164"+
    "\2\162\3\0\3\162\1\0\1\162\2\0\1\162\4\351"+
    "\1\162\1\0\4\162\2\0\2\162\2\351\17\0\2\162"+
    "\2\351\3\162\2\351\10\162\1\351\2\162\1\351\3\162"+
    "\4\0\3\351\1\162\3\0\3\162\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\6\22\1\352\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\13\173\1\174\2\173\1\353\75\173\1\0"+
    "\107\173\17\0\1\354\73\0\1\202\27\0\1\203\41\0"+
    "\1\202\50\0\1\41\1\0\1\30\55\0\1\17\2\0"+
    "\6\205\1\0\4\17\2\0\4\205\17\0\1\205\1\17"+
    "\26\205\4\0\4\205\3\0\3\205\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\2\22\1\355\23\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\6\22\1\356"+
    "\17\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\14\22\1\357\11\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\3\22\1\360"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\20\22\1\361\5\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\1\362\25\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\14\22\1\363\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\10\22\1\364\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\12\22\1\365\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\5\22\1\366\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\1\367\20\22"+
    "\1\242\4\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\4\22\1\370\3\22\1\371\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\20\22\1\372\5\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\3\22\1\373\22\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\2\22\1\374\1\375\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\1\376\25\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\1\377\25\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\u0100\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\5\22\1\u0101\20\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\5\22\1\u0102\20\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\2\22\1\374\23\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\5\22\1\u0103\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\1\u0104"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\3\22\1\u0105\14\22\1\u0106\5\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\3\22\1\u0107\22\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\u0108\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\20\22\1\u0109\5\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\2\22\1\u010a\1\22\17\0\1\22\1\17\26\22\4\0"+
    "\4\22\3\0\1\22\1\u010b\1\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\2\22\1\u010c\1\u010d\22\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\3\22"+
    "\1\u010e\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\7\22\1\u010f\16\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\3\22"+
    "\1\u0110\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\15\22\1\242\10\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\3\22"+
    "\1\u0111\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\10\22\1\u0112\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\1\22"+
    "\1\u0113\5\22\1\u0114\12\22\1\u0115\3\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\5\22\1\u0116\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\26\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\1\22\1\u0117\24\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\4\22\1\u0118"+
    "\1\u0119\20\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\10\22\1\u011a\3\22\1\u011b\11\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\12\22\1\u011c\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\7\22\1\u011d\16\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\14\22\1\u011e\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\12\22\1\u011f\13\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\4\22\1\242\21\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\7\22\1\u0120\1\u0121"+
    "\15\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\26\22\4\0\4\22\3\0\1\22\1\242"+
    "\1\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\22\22\1\u0122"+
    "\3\22\4\0\4\22\3\0\3\22\5\0\4\u0123\12\0"+
    "\2\u0123\21\0\2\u0123\3\0\2\u0123\10\0\1\u0123\2\0"+
    "\1\u0123\7\0\3\u0123\14\0\4\u0124\12\0\2\u0124\21\0"+
    "\2\u0124\3\0\2\u0124\10\0\1\u0124\2\0\1\u0124\7\0"+
    "\3\u0124\60\0\1\u0125\123\0\1\u0126\114\0\1\u0127\100\0"+
    "\1\u0128\35\0\34\277\1\301\55\277\3\0\1\277\2\0"+
    "\1\277\1\0\1\277\7\0\4\277\10\0\1\301\6\0"+
    "\1\277\1\0\26\277\4\0\4\277\3\0\3\277\54\0"+
    "\1\u0129\1\0\1\u012a\3\0\1\u012b\40\0\1\u012c\35\0"+
    "\1\u012d\3\0\1\u012e\1\0\1\u012f\116\0\1\u0130\40\0"+
    "\1\u0131\37\0\1\u0132\2\0\1\u0133\1\0\1\u0134\114\0"+
    "\1\u0135\1\u0136\4\0\1\u0137\76\0\1\u0138\103\0\1\u0139"+
    "\6\0\1\u013a\4\0\1\u013b\107\0\1\u013c\10\0\1\u013d"+
    "\1\u013e\73\0\1\u013f\1\0\1\u0140\112\0\1\u0141\1\u0142"+
    "\106\0\1\u0143\102\0\1\u0144\121\0\1\u0145\107\0\1\u0146"+
    "\46\0\1\u0147\34\0\1\u0148\3\0\1\u0149\115\0\1\u014a"+
    "\101\0\1\u014b\5\0\1\u014c\106\0\1\u014d\123\0\1\u014e"+
    "\114\0\1\u014f\100\0\1\u0150\105\0\1\u0151\3\0\1\u0152"+
    "\40\0\6\330\3\0\1\330\3\0\6\330\13\0\1\330"+
    "\1\0\1\330\1\0\26\330\4\0\4\330\3\0\3\330"+
    "\4\0\1\u0153\2\0\1\u0153\1\0\1\u0153\3\0\1\u0153"+
    "\3\0\4\u0153\15\0\1\u0153\1\0\1\u0153\1\0\26\u0153"+
    "\4\0\4\u0153\3\0\3\u0153\25\0\1\u0154\51\0\1\u0155"+
    "\47\0\1\u0156\125\0\1\u0157\123\0\1\u0158\114\0\1\u0159"+
    "\100\0\1\u015a\61\0\1\u015b\121\0\1\u015c\55\0\1\17"+
    "\2\0\1\17\4\u015d\1\17\1\0\4\17\2\0\2\17"+
    "\2\u015d\17\0\2\17\2\u015d\3\17\2\u015d\10\17\1\u015d"+
    "\2\17\1\u015d\3\17\4\0\3\u015d\1\17\3\0\3\17"+
    "\1\0\1\162\2\0\1\162\2\346\1\162\1\346\1\162"+
    "\1\0\4\162\2\0\2\162\1\164\1\162\17\0\21\162"+
    "\1\164\2\162\1\164\3\162\4\0\1\162\1\164\2\162"+
    "\3\0\3\162\5\0\2\346\1\0\1\346\102\0\1\162"+
    "\2\0\1\162\4\351\1\162\1\0\4\162\2\0\1\162"+
    "\1\350\2\351\17\0\2\162\2\351\3\162\2\351\1\350"+
    "\7\162\1\351\2\162\1\351\3\162\4\0\3\351\1\162"+
    "\3\0\3\162\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\2\22"+
    "\1\230\23\22\4\0\4\22\3\0\3\22\44\0\1\353"+
    "\11\0\2\353\51\0\1\u015e\73\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\3\22\1\u015f\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\1\u0160\25\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\7\22\1\u0161\16\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\6\22\1\u0162\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\6\22\1\262\17\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\3\22\1\u0163\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\4\22\1\u0164\21\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\3\22\1\375\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\5\22\1\u0165\20\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\6\22\1\u0166\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\12\22\1\u0167\13\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\14\22\1\u0168\11\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\2\22\1\242\23\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\6\22\1\u0169\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\5\22\1\u016a"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\26\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\6\22\1\242\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\5\22"+
    "\1\u0111\20\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\2\22\1\371\23\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\4\22"+
    "\1\u0162\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\2\22\1\u016b\1\u016c\22\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\13\22\1\u016d\12\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\u016e\25\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\242\1\17\26\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\7\22\1\u016f\16\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\6\22\1\u0170\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\14\22\1\u0171\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\11\22\1\u0162\14\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\7\22\1\u0172\4\22\1\u0171\11\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\10\22"+
    "\1\u0173\15\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\1\u0174\25\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\3\22\1\u0175"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\6\22\1\u0176\17\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\14\22\1\242"+
    "\11\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\7\22\1\242\16\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\10\22\1\u0177"+
    "\15\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\13\22\1\242\12\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\7\22\1\374"+
    "\16\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\5\22\1\u0178\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\26\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\6\22\1\u0179\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\1\u017a\25\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\22\1\u017b\24\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\7\22\1\u0163\16\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\2\22\1\u017c\23\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\16\22\1\u017d\7\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\23\22\1\u017e\2\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\3\22\1\u017f\22\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\5\22\1\u0180\20\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\2\22\1\366\23\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\1\u0164\25\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\1\u0181"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\1\u0182\25\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\17\22\1\242\6\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\10\22\1\u0183\15\22\4\0\4\22\3\0\3\22"+
    "\5\0\4\u0184\12\0\2\u0184\21\0\2\u0184\3\0\2\u0184"+
    "\10\0\1\u0184\2\0\1\u0184\7\0\3\u0184\14\0\4\u0185"+
    "\12\0\2\u0185\21\0\2\u0185\3\0\2\u0185\10\0\1\u0185"+
    "\2\0\1\u0185\7\0\3\u0185\75\0\1\u0186\51\0\1\u0187"+
    "\125\0\1\u0188\123\0\1\u0127\101\0\1\u0189\4\0\1\u018a"+
    "\132\0\1\u018b\104\0\1\u018c\75\0\1\u018d\5\0\1\u018e"+
    "\102\0\1\u018f\114\0\1\u0190\114\0\1\u0191\105\0\1\u0192"+
    "\103\0\1\u0193\113\0\1\u0194\117\0\1\u0195\115\0\1\u0196"+
    "\103\0\1\u0197\3\0\1\u0198\120\0\1\u0199\112\0\1\u019a"+
    "\71\0\1\u019b\2\0\1\u019c\21\0\1\u019d\73\0\1\u019e"+
    "\102\0\1\u019f\123\0\1\u01a0\5\0\1\u01a1\34\0\1\u01a2"+
    "\154\0\1\u01a3\103\0\1\u01a4\2\0\1\u01a5\14\0\1\u01a6"+
    "\103\0\1\u01a7\104\0\1\u01a8\4\0\1\u01a9\111\0\1\u01aa"+
    "\101\0\1\u01ab\7\0\1\u01ac\113\0\1\u01ad\73\0\1\u01ae"+
    "\125\0\1\u01af\101\0\1\u01b0\15\0\1\u01b1\1\0\1\u01b2"+
    "\70\0\1\u01b3\114\0\1\u01b4\115\0\1\u01b5\3\0\1\u01b6"+
    "\101\0\1\u01b7\2\0\1\u0133\106\0\1\u01b8\111\0\1\u01b9"+
    "\125\0\1\u01ba\51\0\1\u01bb\125\0\1\u01bc\123\0\1\u014f"+
    "\46\0\1\u01bd\156\0\1\u01be\37\0\6\u0153\3\0\1\u0153"+
    "\3\0\6\u0153\13\0\1\u0153\1\0\1\u0153\1\0\26\u0153"+
    "\4\0\4\u0153\3\0\3\u0153\25\0\1\u01bf\164\0\1\u01c0"+
    "\77\0\1\u01c1\51\0\1\u01c2\125\0\1\u01c3\123\0\1\u0159"+
    "\62\0\1\u01c4\65\0\1\17\2\0\1\17\4\u01c5\1\17"+
    "\1\0\4\17\2\0\2\17\2\u01c5\17\0\2\17\2\u01c5"+
    "\3\17\2\u01c5\10\17\1\u01c5\2\17\1\u01c5\3\17\4\0"+
    "\3\u01c5\1\17\3\0\3\17\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\4\22\1\u01c6\21\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\16\22\1\242\7\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\6\22\1\u01c7\17\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\10\22\1\u01c8\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\3\22\1\u0162\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\13\22\1\u01c9\12\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\2\22\1\u01ca\23\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\15\22\1\u01cb\10\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\14\22\1\u01cc\11\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\4\22\1\u01cd\21\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\3\22\1\242\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\10\22\1\u01ce\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\20\22\1\u01cf\5\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\12\22\1\u01d0\13\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\4\22\1\u016b\21\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\6\22\1\u01d1\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\12\22\1\u01d2\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\1\22\1\u016f\1\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\1\u01d3\25\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\4\22\1\u01d4\21\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\23\22\1\374\2\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\11\22\1\u01d5\14\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\3\22\1\374\22\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\5\22\1\u01d6\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\26\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\7\22"+
    "\1\360\16\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\6\22\1\u01d7\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\1\u01d8"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\1\u0179\25\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\6\22\1\u01d9\17\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\3\22\1\u01da\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\7\22\1\u01db\16\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\3\22\1\250\22\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\12\22\1\u01dc\13\22"+
    "\4\0\4\22\3\0\3\22\42\0\1\u0188\5\0\1\u0127"+
    "\45\0\6\u0187\1\0\1\u01dd\1\0\1\u01dd\2\u0187\1\u01dd"+
    "\4\u0187\2\u01dd\1\0\2\u01dd\1\0\1\u01dd\2\0\6\u01dd"+
    "\1\u0187\1\u01dd\26\u0187\1\0\1\u01dd\1\0\1\u01dd\4\u0187"+
    "\3\u01dd\3\u0187\17\0\1\u01de\141\0\1\u01df\123\0\1\u01e0"+
    "\104\0\1\u0198\1\0\1\u01e1\44\0\1\u01e2\161\0\1\u01e3"+
    "\74\0\1\u01e4\116\0\1\u01e5\114\0\1\u01e6\103\0\1\u0198"+
    "\115\0\1\u0197\103\0\1\u01e7\116\0\1\u01e8\113\0\1\u0133"+
    "\120\0\1\u01e9\77\0\1\u0195\123\0\1\u0195\103\0\1\u01ea"+
    "\122\0\1\u01eb\35\0\1\u01ec\111\0\1\u01ed\155\0\1\u01ee"+
    "\104\0\1\u01ef\111\0\1\u01f0\130\0\1\u01f1\66\0\1\u0195"+
    "\125\0\1\u01f2\75\0\1\u01f3\121\0\1\u01f4\117\0\1\u01f5"+
    "\114\0\1\u0198\100\0\1\u01f6\121\0\1\u0195\107\0\1\u01f7"+
    "\100\0\1\u01f8\114\0\1\u01f9\104\0\1\u01fa\116\0\1\u01fb"+
    "\122\0\1\u0195\77\0\1\u0195\110\0\1\u01fc\105\0\1\u01fd"+
    "\120\0\1\u01e8\102\0\1\u01a2\134\0\1\u01fe\71\0\1\u01ff"+
    "\14\0\1\u0200\77\0\1\u0198\113\0\1\u0201\103\0\1\u0202"+
    "\103\0\1\u01bc\5\0\1\u014f\45\0\6\u01bb\1\0\1\u0203"+
    "\1\0\1\u0203\2\u01bb\1\u0203\4\u01bb\2\u0203\1\0\2\u0203"+
    "\1\0\1\u0203\2\0\6\u0203\1\u01bb\1\u0203\26\u01bb\1\0"+
    "\1\u0203\1\0\1\u0203\4\u01bb\3\u0203\3\u01bb\17\0\1\u0204"+
    "\143\0\1\u0205\120\0\1\u0206\132\0\1\u0207\52\0\1\u01c3"+
    "\5\0\1\u0159\45\0\6\u01c2\1\0\1\u0208\1\0\1\u0208"+
    "\2\u01c2\1\u0208\4\u01c2\2\u0208\1\0\2\u0208\1\0\1\u0208"+
    "\2\0\6\u0208\1\u01c2\1\u0208\26\u01c2\1\0\1\u0208\1\0"+
    "\1\u0208\4\u01c2\3\u0208\3\u01c2\17\0\1\u0209\73\0\1\17"+
    "\2\0\1\17\4\u020a\1\17\1\0\4\17\2\0\2\17"+
    "\2\u020a\17\0\2\17\2\u020a\3\17\2\u020a\10\17\1\u020a"+
    "\2\17\1\u020a\3\17\4\0\3\u020a\1\17\3\0\3\17"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\1\u020b\25\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\1\u020c\25\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\5\22\1\242\20\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\4\22"+
    "\1\u020d\21\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\10\22\1\u020e\15\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\22\22"+
    "\1\242\3\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\12\22\1\u020f\13\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\12\22"+
    "\1\u0210\13\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\6\22\1\u016f\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\17\22"+
    "\1\371\6\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\u0211\1\17\26\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\10\22\1\u0212\15\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\12\22\1\u0213\13\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\22\22\1\u0214\3\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\11\22\1\361\14\22\4\0\4\22\3\0\3\22"+
    "\1\0\1\17\2\0\6\22\1\0\1\17\1\161\2\22"+
    "\2\0\4\22\17\0\1\22\1\17\7\22\1\u016b\16\22"+
    "\4\0\4\22\3\0\3\22\1\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\2\22\1\u0215\1\22"+
    "\17\0\1\22\1\17\26\22\4\0\4\22\3\0\2\22"+
    "\1\u0216\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\11\22\1\374"+
    "\14\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\5\22\1\u0217\20\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\10\22\1\u0218"+
    "\15\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\7\22\1\u0219\16\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\10\22\1\u021a"+
    "\15\22\4\0\4\22\3\0\3\22\17\0\1\u0187\146\0"+
    "\1\u021b\117\0\1\u01af\107\0\1\u0195\106\0\1\u0133\116\0"+
    "\1\u01f9\103\0\1\u021c\107\0\1\u021d\107\0\1\u0198\107\0"+
    "\1\u021e\121\0\1\u01b0\116\0\1\u0198\113\0\1\u021f\106\0"+
    "\1\u0220\101\0\1\u0221\115\0\1\u0222\102\0\1\u0223\112\0"+
    "\1\u0224\112\0\1\u0225\112\0\1\u0226\110\0\1\u0195\126\0"+
    "\1\u01e2\75\0\1\u0227\111\0\1\u0228\117\0\1\u0229\103\0"+
    "\1\u0133\105\0\1\u0134\115\0\1\u0195\105\0\1\u022a\113\0"+
    "\1\u022b\115\0\1\u022c\46\0\1\u022d\146\0\1\u022e\117\0"+
    "\1\u022f\111\0\1\u0230\103\0\1\u0231\121\0\1\u0232\52\0"+
    "\1\u01bb\154\0\1\u0233\113\0\1\u0234\127\0\1\u0235\26\0"+
    "\1\u01c2\73\0\1\17\2\0\1\17\4\22\1\17\1\0"+
    "\4\17\2\0\2\17\2\22\17\0\2\17\2\22\3\17"+
    "\2\22\10\17\1\22\2\17\1\22\3\17\4\0\3\22"+
    "\1\17\3\0\3\17\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\5\22\1\u016b\20\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\u0162\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\14\22\1\u0236\11\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\6\22\1\u0237\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\5\22\1\374"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\26\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\6\22\1\u0238\17\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\3\22"+
    "\1\u01cf\22\22\4\0\4\22\3\0\3\22\1\0\1\17"+
    "\2\0\6\22\1\0\1\17\1\161\2\22\2\0\4\22"+
    "\17\0\1\22\1\17\5\22\1\372\20\22\4\0\4\22"+
    "\3\0\3\22\1\0\1\17\2\0\6\22\1\0\1\17"+
    "\1\161\2\22\2\0\4\22\17\0\1\22\1\17\1\u0239"+
    "\25\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\7\22\1\u023a\16\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\12\22\1\u023b"+
    "\13\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\3\22\1\u023c\22\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\14\22\1\u023d"+
    "\11\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\21\22\1\242\4\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\3\22\1\u0219"+
    "\22\22\4\0\4\22\3\0\3\22\52\0\1\u023e\117\0"+
    "\1\u0228\77\0\1\u023f\115\0\1\u0240\113\0\1\u0241\115\0"+
    "\1\u0242\111\0\1\u0243\103\0\1\u01b7\105\0\1\u0244\130\0"+
    "\1\u0245\72\0\1\u01a3\3\0\1\u0246\115\0\1\u0247\113\0"+
    "\1\u01fa\102\0\1\u0198\110\0\1\u0133\116\0\1\u0195\122\0"+
    "\1\u0248\76\0\1\u0249\113\0\1\u01f2\105\0\1\u0133\113\0"+
    "\1\u024a\110\0\1\u024b\110\0\1\u0202\122\0\1\u01e1\101\0"+
    "\1\u024c\40\0\26\u0234\1\u0195\63\u0234\102\0\1\u024d\7\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\u024e\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\12\22\1\u016b\13\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\12\22\1\u024f\13\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\5\22\1\374\20\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\14\22\1\u0250\11\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\3\22\1\u016f\22\22\4\0\4\22\3\0\3\22\1\0"+
    "\1\17\2\0\6\22\1\0\1\17\1\161\2\22\2\0"+
    "\4\22\17\0\1\22\1\17\6\22\1\u0121\17\22\4\0"+
    "\4\22\3\0\3\22\1\0\1\17\2\0\6\22\1\0"+
    "\1\17\1\161\2\22\2\0\4\22\17\0\1\22\1\17"+
    "\12\22\1\242\13\22\4\0\4\22\3\0\3\22\62\0"+
    "\1\u0241\102\0\1\u01f2\125\0\1\u0195\112\0\1\u0195\76\0"+
    "\1\u0240\107\0\1\u01a9\112\0\1\u0251\46\0\1\u0252\157\0"+
    "\1\u0253\100\0\1\u0196\111\0\1\u024a\114\0\1\u0254\111\0"+
    "\1\u0240\116\0\1\u0255\135\0\1\u0256\10\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\10\22\1\u0257\15\22\4\0\4\22\3\0"+
    "\3\22\1\0\1\17\2\0\6\22\1\0\1\17\1\161"+
    "\2\22\2\0\4\22\17\0\1\22\1\17\3\22\1\371"+
    "\22\22\4\0\4\22\3\0\3\22\1\0\1\17\2\0"+
    "\6\22\1\0\1\17\1\161\2\22\2\0\4\22\17\0"+
    "\1\22\1\17\1\u023b\25\22\4\0\4\22\3\0\3\22"+
    "\50\0\1\u01b0\114\0\1\u0258\117\0\1\u01f2\104\0\1\u01af"+
    "\103\0\1\u0259\142\0\1\u025a\13\0\1\17\2\0\6\22"+
    "\1\0\1\17\1\161\2\22\2\0\4\22\17\0\1\22"+
    "\1\17\26\22\4\0\4\22\3\0\1\u023c\2\22\51\0"+
    "\1\u025b\115\0\1\u0234\104\0\1\u0195\11\0\1\u01f9\30\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[40034];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\2\1\1\0\2\1\1\11\4\1\1\11\4\1"+
    "\2\11\4\1\1\11\22\1\2\11\3\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\5\1"+
    "\1\11\10\1\1\11\2\1\1\11\2\1\1\11\1\1"+
    "\1\11\5\1\1\11\2\1\1\11\1\1\3\11\3\1"+
    "\3\11\1\1\1\11\15\1\2\0\1\11\3\1\2\0"+
    "\1\11\62\1\1\11\2\1\1\11\4\0\1\11\2\0"+
    "\1\11\26\0\3\1\2\11\5\0\1\11\2\0\2\1"+
    "\1\0\73\1\60\0\1\1\2\0\1\11\5\0\1\11"+
    "\1\1\1\11\45\1\1\0\1\11\1\0\1\1\15\0"+
    "\1\11\45\0\1\1\3\0\1\11\2\0\1\1\1\0"+
    "\1\11\30\1\15\0\1\1\20\0\1\1\16\0\21\1"+
    "\33\0\11\1\4\0\1\1\12\0\3\1\6\0\1\1"+
    "\2\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[603];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	private static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in a JavaScript documentation comment.
	 */
	private static final int INTERNAL_IN_JS_COMMENT_DOCUMENTATION = -9;
	
	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_INVALID	= -10;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_VALID		= -11;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_INVALID	= -12;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_VALID		= -13;

	private static final int INTERNAL_E4X = -14;

	private static final int INTERNAL_E4X_INTAG = -15;

	private static final int INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION = -16;

	private static final int INTERNAL_IN_E4X_COMMENT = -17;

	private static final int INTERNAL_E4X_DTD = -18;

	private static final int INTERNAL_E4X_DTD_INTERNAL = -19;

	private static final int INTERNAL_E4X_ATTR_SINGLE = -20;

	private static final int INTERNAL_E4X_ATTR_DOUBLE = -21;

	private static final int INTERNAL_E4X_MARKUP_CDATA = -22;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * Whether we're in an internal DTD.  Only valid if in an e4x DTD.
	 */
	private boolean e4x_inInternalDtd;

	/**
	 * The previous e4x state.  Only valid if in an e4x state.
	 */
	private int e4x_prevState;

	/**
	 * The version of JavaScript being highlighted.
	 */
	private static String jsVersion;

	/**
	 * Whether e4x is being highlighted.
	 */
	private static boolean e4xSupported;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Language state set on E4X tokens.
	 */
	private static final int LANG_INDEX_E4X = 1;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public JavaScriptTokenMaker() {
		super();
	}


	static {
		jsVersion = "1.0";
		e4xSupported = true;
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes "standard" token type} for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 * 
	 */
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_IN_JS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				return TokenTypes.COMMENT_DOCUMENTATION;
			case INTERNAL_IN_JS_STRING_INVALID:
			case INTERNAL_IN_JS_STRING_VALID:
			case INTERNAL_IN_JS_CHAR_INVALID:
			case INTERNAL_IN_JS_CHAR_VALID:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
		}
		return type;
	}


	/**
	 * Returns the JavaScript version being highlighted.
	 *
	 * @return Supported JavaScript version.
	 * @see #isJavaScriptCompatible(String)
	 */
	public static String getJavaScriptVersion() {
		return jsVersion;
	}


	/**
	 * {@inheritDoc}
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		e4x_prevState = YYINITIAL;
		e4x_inInternalDtd = false;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				state = JS_DOCCOMMENT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			case INTERNAL_E4X:
				state = E4X;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_INTAG:
				state = E4X_INTAG;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION:
				state = E4X_PI;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD:
				state = E4X_DTD;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD_INTERNAL:
				state = E4X_DTD;
				e4x_inInternalDtd = true;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_SINGLE:
				state = E4X_INATTR_SINGLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_DOUBLE:
				state = E4X_INATTR_DOUBLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_CDATA:
				state = E4X_CDATA;
				languageIndex = LANG_INDEX_E4X;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_E4X_COMMENT - prevState
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_IN_E4X_COMMENT:
							state = E4X_COMMENT;
							break;
					}
					e4x_prevState = -initialTokenType&0xff;
					languageIndex = LANG_INDEX_E4X;
				}
				else { // Shouldn't happen
					state = Token.NULL;
				}
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new Token();
		}

	}


	/**
	 * Returns whether e4x is being highlighted.
	 *
	 * @return Whether e4x is being highlighted.
	 * @see #setE4xSupported(boolean)
	 */
	public static boolean isE4xSupported() {
		return e4xSupported;
	}


	/**
	 * Returns whether features for a specific JS version should be honored
	 * while highlighting.
	 * 
	 * @param version JavaScript version required 
	 * @return Whether the JavaScript version is the same or greater than
	 *         version required. 
	 */
	public static boolean isJavaScriptCompatible(String version) {
		return jsVersion.compareTo(version) >= 0;
	}


	/**
	 * Sets whether e4x should be highlighted.  A repaint should be forced on
	 * all <code>RSyntaxTextArea</code>s editing JavaScript if this property
	 * is changed to see the difference.
	 *
	 * @param supported Whether e4x should be highlighted.
	 * @see #isE4xSupported()
	 */
	public static void setE4xSupported(boolean supported) {
		e4xSupported = supported;
	}


	/**
	 * Set the supported JavaScript version because some keywords were
	 * introduced on or after this version.
	 *
	 * @param javaScriptVersion The version of JavaScript to support, such as
	 *        "<code>1.5</code>" or "<code>1.6</code>".
	 * @see #isJavaScriptCompatible(String)
	 * @see #getJavaScriptVersion()
	 */
	public static void setJavaScriptVersion(String javaScriptVersion) {
		jsVersion = javaScriptVersion;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 34: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_SINGLE);
          }
        case 73: break;
        case 33: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_DOUBLE);
          }
        case 74: break;
        case 36: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 75: break;
        case 71: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 76: break;
        case 26: 
          { addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
          }
        case 77: break;
        case 15: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 78: break;
        case 3: 
          { addToken(Token.WHITESPACE);
          }
        case 79: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 80: break;
        case 41: 
          { int start = zzStartRead;
										int operatorLen = yycharat(0)=='+' ? 2 : 1;
										int yylen = yylength(); // Cache before first addToken() invalidates it
										//System.out.println("'" + yytext() + "': " + yylength() + ", " + (operatorLen+1));
										addToken(zzStartRead,zzStartRead+operatorLen-1, Token.OPERATOR);
										if (yylen>operatorLen+1) {
											//System.out.println((start+operatorLen) + ", " + (zzMarkedPos-2));
											addToken(start+operatorLen,zzMarkedPos-2, Token.WHITESPACE);
										}
										zzStartRead = zzCurrentPos = zzMarkedPos = zzMarkedPos - 1;
										if (isE4xSupported()) {
											// Scanning will continue with "<" as markup tag start
											yybegin(E4X, LANG_INDEX_E4X);
										}
										// Found e4x (or syntax error) but option not enabled;
										// Scanning will continue at "<" as operator
          }
        case 81: break;
        case 64: 
          { addToken(Token.FUNCTION);
          }
        case 82: break;
        case 49: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_MARKUP); start = zzMarkedPos;
          }
        case 83: break;
        case 44: 
          { /* Skip all escaped chars. */
          }
        case 84: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 85: break;
        case 68: 
          { start = zzStartRead; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 86: break;
        case 60: 
          { int temp=zzStartRead; yybegin(E4X); addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addToken(temp,zzMarkedPos-1, Token.MARKUP_CDATA_DELIMITER);
          }
        case 87: break;
        case 58: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 88: break;
        case 46: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 89: break;
        case 61: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 90: break;
        case 52: 
          { start = zzMarkedPos-2; yybegin(E4X_PI);
          }
        case 91: break;
        case 35: 
          { yybegin(E4X_INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 92: break;
        case 13: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 93: break;
        case 19: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 94: break;
        case 23: 
          { yybegin(YYINITIAL, LANG_INDEX_DEFAULT); addToken(Token.IDENTIFIER);
          }
        case 95: break;
        case 45: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 96: break;
        case 70: 
          { int temp = zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_DTD); start = temp; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 97: break;
        case 63: 
          { if(e4xSupported){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 98: break;
        case 59: 
          { int temp = zzMarkedPos; addToken(start,zzStartRead+2, Token.MARKUP_COMMENT); start = temp; yybegin(e4x_prevState);
          }
        case 99: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 100: break;
        case 53: 
          { yybegin(E4X); addToken(start,zzStartRead+1, Token.MARKUP_PROCESSING_INSTRUCTION);
          }
        case 101: break;
        case 48: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_DOCUMENTATION);
          }
        case 102: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
          }
        case 103: break;
        case 25: 
          { addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
          }
        case 104: break;
        case 5: 
          { addToken(Token.IDENTIFIER);
          }
        case 105: break;
        case 42: 
          { addToken(isE4xSupported() ? Token.MARKUP_TAG_ATTRIBUTE : Token.ERROR_IDENTIFIER);
          }
        case 106: break;
        case 65: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 107: break;
        case 55: 
          { start = zzMarkedPos-3; yybegin(JS_DOCCOMMENT);
          }
        case 108: break;
        case 9: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 109: break;
        case 51: 
          { start = zzMarkedPos-2; e4x_inInternalDtd = false; yybegin(E4X_DTD);
          }
        case 110: break;
        case 24: 
          { addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
          }
        case 111: break;
        case 10: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 112: break;
        case 28: 
          { e4x_inInternalDtd = true;
          }
        case 113: break;
        case 67: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 114: break;
        case 40: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 115: break;
        case 38: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 116: break;
        case 72: 
          { addToken(Token.MARKUP_CDATA_DELIMITER); start = zzMarkedPos; yybegin(E4X_CDATA);
          }
        case 117: break;
        case 31: 
          { addToken(Token.MARKUP_TAG_DELIMITER); /* Not valid but we'll still accept it */
          }
        case 118: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 119: break;
        case 69: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addHyperlinkToken(temp,zzMarkedPos-1, Token.MARKUP_COMMENT); start = zzMarkedPos;
          }
        case 120: break;
        case 32: 
          { yybegin(E4X); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 121: break;
        case 22: 
          { addToken(Token.MARKUP_ENTITY_REFERENCE);
          }
        case 122: break;
        case 56: 
          { if(isJavaScriptCompatible("1.7")){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 123: break;
        case 62: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 124: break;
        case 4: 
          { addNullToken(); return firstToken;
          }
        case 125: break;
        case 43: 
          { addToken(Token.RESERVED_WORD);
          }
        case 126: break;
        case 47: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 127: break;
        case 57: 
          { addToken(Token.DATA_TYPE);
          }
        case 128: break;
        case 21: 
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(E4X_INTAG);
          }
        case 129: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 130: break;
        case 30: 
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 131: break;
        case 66: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_KEYWORD); start = zzMarkedPos;
          }
        case 132: break;
        case 16: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 133: break;
        case 39: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 134: break;
        case 20: 
          { addEndToken(INTERNAL_E4X); return firstToken;
          }
        case 135: break;
        case 12: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 136: break;
        case 37: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 137: break;
        case 50: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 138: break;
        case 54: 
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 139: break;
        case 27: 
          { if (!e4x_inInternalDtd) { yybegin(E4X); addToken(start,zzStartRead, Token.MARKUP_DTD); }
          }
        case 140: break;
        case 6: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 141: break;
        case 29: 
          { e4x_inInternalDtd = false;
          }
        case 142: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 143: break;
        case 1: 
          { 
          }
        case 144: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 604: break;
            case E4X: {
              addEndToken(INTERNAL_E4X); return firstToken;
            }
            case 605: break;
            case E4X_INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_INTAG); return firstToken;
            }
            case 606: break;
            case E4X_PI: {
              addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
            }
            case 607: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 608: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 609: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 610: break;
            case E4X_COMMENT: {
              addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
            }
            case 611: break;
            case JS_DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
            }
            case 612: break;
            case E4X_DTD: {
              addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
            }
            case 613: break;
            case E4X_INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_SINGLE); return firstToken;
            }
            case 614: break;
            case E4X_INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_DOUBLE); return firstToken;
            }
            case 615: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 616: break;
            case E4X_CDATA: {
              addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addEndToken(INTERNAL_E4X_MARKUP_CDATA); return firstToken;
            }
            case 617: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
