/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

class LineNumberList
extends AbstractGutterComponent
implements MouseInputListener {
    private int currentLine;
    private int lastY = -1;
    private int cellHeight;
    private int cellWidth;
    private int ascent;
    private int mouseDragStartOffset;
    private Listener l;
    private Insets textAreaInsets;
    private Rectangle visibleRect;
    private int lineNumberingStartIndex;
    private static final int RHS_BORDER_WIDTH = 8;

    public LineNumberList(RTextArea textArea) {
        this(textArea, Color.GRAY);
    }

    public LineNumberList(RTextArea textArea, Color numberColor) {
        super(textArea);
        if (numberColor != null) {
            this.setForeground(numberColor);
        } else {
            this.setForeground(Color.GRAY);
        }
        this.currentLine = 0;
        this.setLineNumberingStartIndex(1);
        this.visibleRect = new Rectangle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        if (this.textArea != null) {
            this.l.install(this.textArea);
        }
        this.updateCellWidths();
        this.updateCellHeights();
    }

    public int getLineNumberingStartIndex() {
        return this.lineNumberingStartIndex;
    }

    public Dimension getPreferredSize() {
        int h = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.cellWidth, h);
    }

    void handleDocumentEvent(DocumentEvent e) {
        int newLineCount;
        int n = newLineCount = this.textArea != null ? this.textArea.getLineCount() : 0;
        if (newLineCount != this.currentLineCount) {
            if (newLineCount / 10 != this.currentLineCount / 10) {
                this.updateCellWidths();
            }
            this.currentLineCount = newLineCount;
            this.repaint();
        }
    }

    void lineHeightsChanged() {
        this.updateCellHeights();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int pos;
        if (this.mouseDragStartOffset > -1 && (pos = this.textArea.viewToModel(new Point(0, e.getY()))) >= 0) {
            this.textArea.setCaretPosition(this.mouseDragStartOffset);
            this.textArea.moveCaretPosition(pos);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.textArea == null) {
            return;
        }
        if (e.getButton() == 1) {
            int pos = this.textArea.viewToModel(new Point(0, e.getY()));
            if (pos >= 0) {
                this.textArea.setCaretPosition(pos);
            }
            this.mouseDragStartOffset = pos;
        } else {
            this.mouseDragStartOffset = -1;
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected void paintComponent(Graphics g) {
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = g.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        Color bg = this.getBackground();
        if (this.getGutter() != null) {
            bg = this.getGutter().getBackground();
        }
        g.setColor(bg);
        g.fillRect(0, this.visibleRect.y, this.cellWidth, this.visibleRect.height);
        g.setFont(this.getFont());
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        if (this.textArea.getLineWrap()) {
            this.paintWrappedLineNumbers(g, this.visibleRect);
            return;
        }
        int topLine = this.visibleRect.y / this.cellHeight;
        int bottomLine = Math.min(topLine + this.visibleRect.height / this.cellHeight + 1, root.getElementCount());
        int actualTopY = topLine * this.cellHeight;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        int y = (actualTopY += this.textAreaInsets.top) + this.ascent;
        if (this.textArea.getHighlightCurrentLine() && this.currentLine >= topLine && this.currentLine <= bottomLine) {
            g.setColor(this.textArea.getCurrentLineHighlightColor());
            g.fillRect(0, actualTopY + (this.currentLine - topLine) * this.cellHeight, this.cellWidth, this.cellHeight);
        }
        g.setColor(this.getForeground());
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (ltr) {
            FontMetrics metrics = g.getFontMetrics();
            int rhs = this.getWidth() - 8;
            for (int i = topLine + 1; i <= bottomLine; ++i) {
                int index = i + this.getLineNumberingStartIndex() - 1;
                String number = Integer.toString(index);
                int width = metrics.stringWidth(number);
                g.drawString(number, rhs - width, y);
                y += this.cellHeight;
            }
        } else {
            for (int i = topLine + 1; i <= bottomLine; ++i) {
                int index = i + this.getLineNumberingStartIndex() - 1;
                String number = Integer.toString(index);
                g.drawString(number, 8, y);
                y += this.cellHeight;
            }
        }
    }

    private void paintWrappedLineNumbers(Graphics g, Rectangle visibleRect) {
        int width = this.getWidth();
        RTextAreaUI ui = (RTextAreaUI)this.textArea.getUI();
        View v = ui.getRootView(this.textArea).getView(0);
        boolean currentLineHighlighted = this.textArea.getHighlightCurrentLine();
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int topPosition = this.textArea.viewToModel(new Point(visibleRect.x, visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        Rectangle visibleEditorRect = ui.getVisibleEditorRect();
        Rectangle r = LineNumberList.getChildViewBounds(v, topLine, visibleEditorRect);
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int rhs = ltr ? width - 8 : 8;
        int visibleBottom = visibleRect.y + visibleRect.height;
        FontMetrics metrics = g.getFontMetrics();
        g.setColor(this.getForeground());
        for (int y = r.y; y < visibleBottom; y += r.height) {
            r = LineNumberList.getChildViewBounds(v, topLine, visibleEditorRect);
            if (currentLineHighlighted && topLine == this.currentLine) {
                g.setColor(this.textArea.getCurrentLineHighlightColor());
                g.fillRect(0, y, width, r.y + r.height - y);
                g.setColor(this.getForeground());
            }
            int index = topLine + 1 + this.getLineNumberingStartIndex() - 1;
            String number = Integer.toString(index);
            if (ltr) {
                int strWidth = metrics.stringWidth(number);
                g.drawString(number, rhs - strWidth, y + this.ascent);
                continue;
            }
            int x = 8;
            g.drawString(number, x, y + this.ascent);
            if (++topLine < lineCount) continue;
            break;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.textArea != null) {
            this.l.uninstall(this.textArea);
        }
    }

    private void repaintLine(int line) {
        int y = this.textArea.getInsets().top;
        this.repaint(0, y += line * this.cellHeight, this.cellWidth, this.cellHeight);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateCellWidths();
        this.updateCellHeights();
    }

    public void setLineNumberingStartIndex(int index) {
        this.lineNumberingStartIndex = index;
    }

    public void setTextArea(RTextArea textArea) {
        if (this.l == null) {
            this.l = new Listener();
        }
        if (this.textArea != null) {
            this.l.uninstall(textArea);
        }
        super.setTextArea(textArea);
        if (textArea != null) {
            this.l.install(textArea);
            this.updateCellHeights();
            this.updateCellWidths();
        }
    }

    private void updateCellHeights() {
        if (this.textArea != null) {
            this.cellHeight = this.textArea.getLineHeight();
            this.ascent = this.textArea.getMaxAscent();
        } else {
            this.cellHeight = 20;
            this.ascent = 5;
        }
        this.repaint();
    }

    private void updateCellWidths() {
        Font font;
        int oldCellWidth = this.cellWidth;
        this.cellWidth = 8;
        if (this.textArea != null && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int count = 0;
            int lineCount = this.textArea.getLineCount();
            while (lineCount >= 10) {
                lineCount /= 10;
                ++count;
            }
            this.cellWidth += fontMetrics.charWidth('9') * (count + 1) + 5;
        }
        if (this.cellWidth != oldCellWidth) {
            this.revalidate();
        }
    }

    private class Listener
    implements CaretListener,
    PropertyChangeListener {
        private boolean installed;

        private Listener() {
        }

        public void caretUpdate(CaretEvent e) {
            int dot = LineNumberList.this.textArea.getCaretPosition();
            if (!LineNumberList.this.textArea.getLineWrap()) {
                int line = LineNumberList.this.textArea.getDocument().getDefaultRootElement().getElementIndex(dot);
                if (LineNumberList.this.currentLine != line) {
                    LineNumberList.this.repaintLine(line);
                    LineNumberList.this.repaintLine(LineNumberList.this.currentLine);
                    LineNumberList.this.currentLine = line;
                }
            } else {
                try {
                    int y = LineNumberList.this.textArea.yForLineContaining(dot);
                    if (y != LineNumberList.this.lastY) {
                        LineNumberList.this.lastY = y;
                        LineNumberList.this.currentLine = LineNumberList.this.textArea.getDocument().getDefaultRootElement().getElementIndex(dot);
                        LineNumberList.this.repaint();
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }

        public void install(RTextArea textArea) {
            if (!this.installed) {
                textArea.addCaretListener(this);
                textArea.addPropertyChangeListener(this);
                this.caretUpdate(null);
                this.installed = true;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("RTA.currentLineHighlight".equals(name) || "RTA.currentLineHighlightColor".equals(name)) {
                LineNumberList.this.repaintLine(LineNumberList.this.currentLine);
            }
        }

        public void uninstall(RTextArea textArea) {
            if (this.installed) {
                textArea.removeCaretListener(this);
                textArea.removePropertyChangeListener(this);
                this.installed = false;
            }
        }
    }
}

