/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Action;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.modes.AbstractMarkupTokenMaker;
import org.fife.util.DynamicIntArray;

public class RSyntaxDocument
extends PlainDocument
implements SyntaxConstants {
    private transient TokenMakerFactory tokenMakerFactory;
    private TokenMaker tokenMaker;
    protected DynamicIntArray lastTokensOnLines;
    private transient Segment s;

    public RSyntaxDocument(String syntaxStyle) {
        this(null, syntaxStyle);
    }

    public RSyntaxDocument(TokenMakerFactory tmf, String syntaxStyle) {
        super(new RGapContent());
        this.putProperty("tabSize", new Integer(5));
        this.lastTokensOnLines = new DynamicIntArray(400);
        this.lastTokensOnLines.add(0);
        this.s = new Segment();
        this.setTokenMakerFactory(tmf);
        this.setSyntaxStyle(syntaxStyle);
    }

    public char charAt(int offset) throws BadLocationException {
        return ((RGapContent)this.getContent()).charAt(offset);
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        int previousTokenType;
        Element lineMap = this.getDefaultRootElement();
        DocumentEvent.ElementChange change = e.getChange(lineMap);
        Element[] added = change == null ? null : change.getChildrenAdded();
        int numLines = lineMap.getElementCount();
        int line = lineMap.getElementIndex(e.getOffset());
        int previousLine = line - 1;
        int n = previousTokenType = previousLine > -1 ? this.lastTokensOnLines.get(previousLine) : 0;
        if (added != null && added.length > 0) {
            Element[] removed = change.getChildrenRemoved();
            int numRemoved = removed != null ? removed.length : 0;
            int endBefore = line + added.length - numRemoved;
            for (int i = line; i < endBefore; ++i) {
                this.setSharedSegment(i);
                int tokenType = this.tokenMaker.getLastTokenTypeOnLine(this.s, previousTokenType);
                this.lastTokensOnLines.add(i, tokenType);
                previousTokenType = tokenType;
            }
            this.updateLastTokensBelow(endBefore, numLines, previousTokenType);
        } else {
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        }
        super.fireInsertUpdate(e);
    }

    protected void fireRemoveUpdate(DocumentEvent chng) {
        Element[] removed;
        Element lineMap = this.getDefaultRootElement();
        int numLines = lineMap.getElementCount();
        DocumentEvent.ElementChange change = chng.getChange(lineMap);
        Element[] elementArray = removed = change == null ? null : change.getChildrenRemoved();
        if (removed != null && removed.length > 0) {
            int line = change.getIndex();
            int previousLine = line - 1;
            int previousTokenType = previousLine > -1 ? this.lastTokensOnLines.get(previousLine) : 0;
            Element[] added = change.getChildrenAdded();
            int numAdded = added == null ? 0 : added.length;
            int endBefore = line + removed.length - numAdded;
            this.lastTokensOnLines.removeRange(line, endBefore);
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        } else {
            int line = lineMap.getElementIndex(chng.getOffset());
            if (line >= this.lastTokensOnLines.getSize()) {
                return;
            }
            int previousLine = line - 1;
            int previousTokenType = previousLine > -1 ? this.lastTokensOnLines.get(previousLine) : 0;
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        }
        super.fireRemoveUpdate(chng);
    }

    public boolean getCompleteMarkupCloseTags() {
        return this.getLanguageIsMarkup() && ((AbstractMarkupTokenMaker)this.tokenMaker).getCompleteCloseTags();
    }

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return this.tokenMaker.getCurlyBracesDenoteCodeBlocks();
    }

    public boolean getLanguageIsMarkup() {
        return this.tokenMaker.isMarkupLanguage();
    }

    public int getLastTokenTypeOnLine(int line) {
        return this.lastTokensOnLines.get(line);
    }

    public String[] getLineCommentStartAndEnd() {
        return this.tokenMaker.getLineCommentStartAndEnd();
    }

    boolean getMarkOccurrencesOfTokenType(int type) {
        return this.tokenMaker.getMarkOccurrencesOfTokenType(type);
    }

    public boolean getShouldIndentNextLine(int line) {
        Token t = this.getTokenListForLine(line);
        t = t.getLastNonCommentNonWhitespaceToken();
        return this.tokenMaker.getShouldIndentNextLineAfter(t);
    }

    public final Token getTokenListForLine(int line) {
        Element map = this.getDefaultRootElement();
        Element elem = map.getElement(line);
        int startOffset = elem.getStartOffset();
        int endOffset = elem.getEndOffset() - 1;
        try {
            this.getText(startOffset, endOffset - startOffset, this.s);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
        int initialTokenType = line == 0 ? 0 : this.getLastTokenTypeOnLine(line - 1);
        return this.tokenMaker.getTokenList(this.s, initialTokenType, startOffset);
    }

    boolean insertBreakSpecialHandling(ActionEvent e) {
        Action a = this.tokenMaker.getInsertBreakAction();
        if (a != null) {
            a.actionPerformed(e);
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.s = new Segment();
    }

    private final void setSharedSegment(int line) {
        Element map = this.getDefaultRootElement();
        Element element = map.getElement(line);
        if (element == null) {
            throw new InternalError("Invalid line number: " + line);
        }
        int startOffset = element.getStartOffset();
        int endOffset = element.getEndOffset() - 1;
        try {
            this.getText(startOffset, endOffset - startOffset, this.s);
        }
        catch (BadLocationException ble) {
            throw new InternalError("Text range not in document: " + startOffset + "-" + endOffset);
        }
    }

    public void setSyntaxStyle(String styleKey) {
        this.tokenMaker = this.tokenMakerFactory.getTokenMaker(styleKey);
        this.updateSyntaxHighlightingInformation();
    }

    public void setSyntaxStyle(TokenMaker tokenMaker) {
        this.tokenMaker = tokenMaker;
        this.updateSyntaxHighlightingInformation();
    }

    public void setTokenMakerFactory(TokenMakerFactory tmf) {
        this.tokenMakerFactory = tmf != null ? tmf : TokenMakerFactory.getDefaultInstance();
    }

    public void setWhitespaceVisible(boolean visible, RSyntaxTextArea textArea) {
        this.tokenMaker.setWhitespaceVisible(visible, textArea);
    }

    private int updateLastTokensBelow(int line, int numLines, int previousTokenType) {
        int firstLine = line;
        int end = numLines;
        while (line < end) {
            this.setSharedSegment(line);
            int oldTokenType = this.lastTokensOnLines.get(line);
            int newTokenType = this.tokenMaker.getLastTokenTypeOnLine(this.s, previousTokenType);
            if (oldTokenType == newTokenType) {
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, firstLine, line, DocumentEvent.EventType.CHANGE));
                return line;
            }
            this.lastTokensOnLines.setUnsafe(line, newTokenType);
            previousTokenType = newTokenType;
            ++line;
        }
        if (line > firstLine) {
            this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, firstLine, line, DocumentEvent.EventType.CHANGE));
        }
        return line;
    }

    protected void updateSyntaxHighlightingInformation() {
        Element map = this.getDefaultRootElement();
        int numLines = map.getElementCount();
        int lastTokenType = 0;
        for (int i = 0; i < numLines; ++i) {
            this.setSharedSegment(i);
            lastTokenType = this.tokenMaker.getLastTokenTypeOnLine(this.s, lastTokenType);
            this.lastTokensOnLines.set(i, lastTokenType);
        }
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, numLines - 1, DocumentEvent.EventType.CHANGE));
    }

    private static class RGapContent
    extends GapContent {
        public char charAt(int offset) throws BadLocationException {
            if (offset < 0 || offset >= this.length()) {
                throw new BadLocationException("Invalid offset", offset);
            }
            int g0 = this.getGapStart();
            char[] array = (char[])this.getArray();
            if (offset < g0) {
                return array[offset];
            }
            return array[this.getGapEnd() + offset - g0];
        }
    }
}

