/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.errorreporting;

public class ParameterDefinition {
    public static final ParameterDefinition UNDEFINED_PARAMETER = ParameterDefinition.builder("undefined parameter").build();
    private final String name;
    private final Object value;
    private final String description;

    private ParameterDefinition(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.description = builder.description;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String toString() {
        if (this.hasValue()) {
            return this.value.toString();
        }
        return "<null>";
    }

    public static class Builder {
        private final String name;
        private Object value;
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }
    }
}

