/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.windows;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.util.jna.windows.GDI32;
import dorkbox.util.jna.windows.User32;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class HBITMAPWrap
extends WinDef.HBITMAP {
    BufferedImage img;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WinDef.HBITMAP createBitmap(BufferedImage image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        WinDef.HDC screenDC = User32.User32.GetDC(null);
        WinDef.HDC memDC = GDI32.CreateCompatibleDC(screenDC);
        WinDef.HBITMAP hBitmap = null;
        try {
            BufferedImage buf = new BufferedImage(w, h, 3);
            Graphics2D g = (Graphics2D)buf.getGraphics();
            g.setComposite(AlphaComposite.getInstance(3));
            g.drawImage(image, 0, 0, w, h, null);
            WinGDI.BITMAPINFO bmi = new WinGDI.BITMAPINFO();
            bmi.bmiHeader.biWidth = w;
            bmi.bmiHeader.biHeight = h;
            bmi.bmiHeader.biPlanes = 1;
            bmi.bmiHeader.biBitCount = (short)32;
            bmi.bmiHeader.biCompression = 0;
            bmi.bmiHeader.biSizeImage = w * h * 4;
            PointerByReference ppbits = new PointerByReference();
            hBitmap = GDI32.CreateDIBSection(memDC, bmi, 0, ppbits, null, 0);
            Pointer pbits = ppbits.getValue();
            Raster raster = buf.getData();
            int[] pixel = new int[4];
            int[] bits = new int[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    raster.getPixel(x, h - y - 1, pixel);
                    int red = (pixel[2] & 0xFF) << 0;
                    int green = (pixel[1] & 0xFF) << 8;
                    int blue = (pixel[0] & 0xFF) << 16;
                    int alpha = (pixel[3] & 0xFF) << 24;
                    bits[x + y * w] = alpha | red | green | blue;
                }
            }
            pbits.write(0L, bits, 0, bits.length);
            WinDef.HBITMAP hBITMAP = hBitmap;
            return hBITMAP;
        }
        finally {
            User32.User32.ReleaseDC(null, screenDC);
            GDI32.DeleteDC(memDC);
        }
    }

    public HBITMAPWrap(BufferedImage img) {
        this.setPointer(HBITMAPWrap.createBitmap(img).getPointer());
        this.img = img;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (Pointer.nativeValue((Pointer)this.getPointer()) != 0L) {
            GDI32.DeleteObject((WinNT.HANDLE)this);
            this.setPointer(new Pointer(0L));
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

