/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.executor.ShellExecutor;
import dorkbox.util.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;

public class OSUtil {

    public static class DesktopEnv {
        private static volatile Boolean isGnome = null;
        private static volatile Boolean isKDE = null;
        private static volatile Boolean isChromeOS = null;
        private static volatile Boolean isNautilus = null;
        private static volatile String getPlasmaVersionFull = null;

        public static Env get() {
            String XDG = System.getenv("XDG_CURRENT_DESKTOP");
            if (XDG == null) {
                XDG = "unknown";
            }
            if (DesktopEnv.isGnome()) {
                XDG = "gnome";
            } else if (DesktopEnv.isKDE()) {
                XDG = "kde";
            }
            if ("unity".equalsIgnoreCase(XDG)) {
                return Env.Unity;
            }
            if ("unity:unity7".equalsIgnoreCase(XDG)) {
                return Env.Unity7;
            }
            if ("xfce".equalsIgnoreCase(XDG)) {
                return Env.XFCE;
            }
            if ("lxde".equalsIgnoreCase(XDG)) {
                return Env.LXDE;
            }
            if ("kde".equalsIgnoreCase(XDG)) {
                return Env.KDE;
            }
            if ("pantheon".equalsIgnoreCase(XDG)) {
                return Env.Pantheon;
            }
            if ("gnome".equalsIgnoreCase(XDG)) {
                return Env.Gnome;
            }
            if (DesktopEnv.isChromeOS()) {
                return Env.ChromeOS;
            }
            return Env.Unknown;
        }

        private static boolean isValidCommand(String partialExpectationInOutput, String commandOutput) {
            return commandOutput.contains(partialExpectationInOutput) && !commandOutput.contains("not installed") && !commandOutput.contains("No such file or directory");
        }

        public static boolean isUnity() {
            Env env = DesktopEnv.get();
            return DesktopEnv.isUnity(env);
        }

        public static boolean isUnity(Env env) {
            return env == Env.Unity || env == Env.Unity7;
        }

        public static boolean isGnome() {
            if (!OS.isLinux() && !OS.isUnix()) {
                return false;
            }
            if (isGnome != null) {
                return isGnome;
            }
            try {
                ShellExecutor shell = new ShellExecutor();
                shell.setExecutable("ps");
                shell.addArgument("x");
                shell.start();
                String output = shell.getOutput();
                boolean contains = output.contains("gnome-shell");
                if (!contains && OS.isLinux()) {
                    shell = new ShellExecutor();
                    shell.setExecutable("ps");
                    shell.addArgument("a");
                    shell.start();
                    output = shell.getOutput();
                    contains = output.contains("gnome-shell");
                }
                isGnome = contains;
                return contains;
            }
            catch (Throwable throwable) {
                isGnome = false;
                return false;
            }
        }

        public static String getGnomeVersion() {
            if (!OS.isLinux() && !OS.isUnix()) {
                return "";
            }
            try {
                String version;
                ShellExecutor shellVersion = new ShellExecutor();
                shellVersion.setExecutable("gnome-shell");
                shellVersion.addArgument("--version");
                shellVersion.start();
                String versionString = shellVersion.getOutput();
                if (!versionString.isEmpty() && (version = versionString.replaceAll("[^\\d.]", "")).length() > 0 && version.indexOf(46) > 0) {
                    return version;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public static boolean isKDE() {
            if (isKDE != null) {
                return isKDE;
            }
            String XDG = System.getenv("XDG_CURRENT_DESKTOP");
            if (XDG == null) {
                double plasmaVersion = DesktopEnv.getPlasmaVersion();
                isKDE = plasmaVersion > 0.0;
                return isKDE;
            }
            if ("kde".equalsIgnoreCase(XDG)) {
                isKDE = true;
                return false;
            }
            isKDE = false;
            return false;
        }

        public static double getPlasmaVersion() {
            String versionAsString = DesktopEnv.getPlasmaVersionFull();
            if (versionAsString.startsWith("0")) {
                return 0.0;
            }
            String[] split = versionAsString.split("\\.", 3);
            if (split.length > 2) {
                return Double.parseDouble(split[0] + "." + split[1]);
            }
            return Double.parseDouble(split[0]);
        }

        public static String getPlasmaVersionFull() {
            if (getPlasmaVersionFull != null) {
                return getPlasmaVersionFull;
            }
            if (!OS.isLinux() && !OS.isUnix()) {
                getPlasmaVersionFull = "";
                return "";
            }
            try {
                String s;
                ShellExecutor shellVersion = new ShellExecutor();
                shellVersion.setExecutable("plasmashell");
                shellVersion.addArgument("--version");
                shellVersion.start();
                String output = shellVersion.getOutput();
                if (!output.isEmpty() && DesktopEnv.isValidCommand(s = "plasmashell ", output)) {
                    String substring;
                    getPlasmaVersionFull = substring = output.substring(output.indexOf(s) + s.length(), output.length());
                    return substring;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            getPlasmaVersionFull = "0";
            return "0";
        }

        public static boolean isNautilus() {
            if (isNautilus != null) {
                return isNautilus;
            }
            if (!OS.isLinux() && !OS.isUnix()) {
                isNautilus = false;
                return false;
            }
            try {
                String s;
                ShellExecutor shellVersion = new ShellExecutor();
                shellVersion.setExecutable("nautilus");
                shellVersion.addArgument("--version");
                shellVersion.start();
                String output = shellVersion.getOutput();
                if (!output.isEmpty() && DesktopEnv.isValidCommand(s = "GNOME nautilus ", output)) {
                    isNautilus = true;
                    return true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            isNautilus = false;
            return false;
        }

        public static boolean isChromeOS() {
            if (isChromeOS == null) {
                if (!OS.isLinux()) {
                    isChromeOS = false;
                    return false;
                }
                isChromeOS = false;
                try {
                    ShellExecutor shellVersion = new ShellExecutor();
                    shellVersion.setExecutable("ps");
                    shellVersion.addArgument("aux");
                    shellVersion.start();
                    String output = shellVersion.getOutput();
                    if (!output.isEmpty() && output.contains("chromeos")) {
                        isChromeOS = true;
                        return true;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return isChromeOS;
        }

        public static String queryXfce(String channel, String property) {
            if (!OS.isLinux() && !OS.isUnix()) {
                return "";
            }
            if (channel == null) {
                return "";
            }
            try {
                ShellExecutor xfconf_query = new ShellExecutor();
                xfconf_query.setExecutable("xfconf-query");
                xfconf_query.addArgument("-c " + channel);
                if (property != null) {
                    xfconf_query.addArgument("-p " + property);
                } else {
                    xfconf_query.addArgument("-l");
                }
                xfconf_query.start();
                return xfconf_query.getOutput();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return "";
            }
        }

        public static enum Env {
            Gnome,
            KDE,
            Unity,
            Unity7,
            XFCE,
            LXDE,
            Pantheon,
            ChromeOS,
            Unknown;

        }
    }

    public static class Linux {
        private static String info = null;
        private static Boolean isArch = null;
        private static Boolean isDebian = null;
        private static Boolean isElementaryOS = null;
        private static Boolean isFedora = null;
        private static Boolean isLinuxMint = null;
        private static Boolean isUbuntu = null;
        private static Boolean isKali = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getInfo() {
            block11: {
                if (info != null) {
                    return info;
                }
                if (!OS.isLinux()) {
                    info = "";
                    return info;
                }
                try {
                    File[] list;
                    LinkedList<File> releaseFiles = new LinkedList<File>();
                    int totalLength = 0;
                    File file = new File("/etc");
                    if (file.isDirectory() && (list = file.listFiles()) != null) {
                        for (File f : list) {
                            if (!f.getName().contains("release")) continue;
                            releaseFiles.add(f);
                            totalLength += (int)file.length();
                        }
                    }
                    if (totalLength <= 0) break block11;
                    StringBuilder fileContents = new StringBuilder(totalLength);
                    BufferedReader reader = null;
                    for (File releaseFile : releaseFiles) {
                        try {
                            String currentLine;
                            reader = new BufferedReader(new FileReader(releaseFile));
                            while ((currentLine = reader.readLine()) != null) {
                                fileContents.append(currentLine).append("\n");
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    info = fileContents.toString();
                    return info;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            info = "";
            return info;
        }

        public static boolean getInfo(String id) {
            return Linux.getInfo().contains("ID=" + id + "\n");
        }

        public static boolean isArch() {
            if (isArch == null) {
                isArch = Linux.getInfo("arch");
            }
            return isArch;
        }

        public static boolean isDebian() {
            if (isDebian == null) {
                isDebian = Linux.getInfo("debian");
            }
            return isDebian;
        }

        public static boolean isElementaryOS() {
            if (isElementaryOS == null) {
                try {
                    String output = Linux.getInfo();
                    isElementaryOS = output.contains("ID=\"elementary\"\n") || output.contains("ID=elementary\n") || output.contains("ID=\"elementary OS\"\n");
                }
                catch (Throwable ignored) {
                    isElementaryOS = false;
                }
            }
            return isElementaryOS;
        }

        public static boolean isFedora() {
            if (isFedora == null) {
                isFedora = Linux.getInfo("fedora");
            }
            return isFedora;
        }

        public static int getFedoraVersion() {
            if (!Linux.isFedora()) {
                return 0;
            }
            try {
                String output = Linux.getInfo();
                if (output.contains("ID=fedora\n")) {
                    int beginIndex = output.indexOf("VERSION_ID=") + 11;
                    String fedoraVersion_ = output.substring(beginIndex, output.indexOf("\n", beginIndex));
                    return Integer.parseInt(fedoraVersion_);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return 0;
        }

        public static boolean isLinuxMint() {
            if (isLinuxMint == null) {
                isLinuxMint = Linux.getInfo("linuxmint");
            }
            return isLinuxMint;
        }

        public static boolean isUbuntu() {
            if (isUbuntu == null) {
                isUbuntu = Linux.getInfo("ubuntu");
            }
            return isUbuntu;
        }

        public static int[] getUbuntuVersion() {
            if (!OS.isLinux()) {
                return new int[]{0, 0};
            }
            if (!Linux.isUbuntu()) {
                return new int[]{0, 0};
            }
            String info = Linux.getInfo();
            String releaseString = "DISTRIB_RELEASE=";
            int index = info.indexOf(releaseString);
            try {
                String versionInfo;
                int newLine;
                if (index > -1 && (newLine = info.indexOf("\n", index += releaseString.length())) > index && (versionInfo = info.substring(index, newLine)).indexOf(46) > 0) {
                    String[] split = versionInfo.split("\\.");
                    return new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1])};
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new int[]{0, 0};
        }

        public static boolean isKali() {
            if (isKali == null) {
                isKali = Linux.getInfo("kali");
            }
            return isKali;
        }

        public static boolean isRoot() {
            boolean isSudoOrRoot;
            boolean bl = isSudoOrRoot = System.getenv("SUDO_USER") != null;
            if (!isSudoOrRoot) {
                try {
                    ShellExecutor shell = new ShellExecutor();
                    shell.setExecutable("id");
                    shell.addArgument("-u");
                    shell.start();
                    String output = shell.getOutput();
                    isSudoOrRoot = "0".equals(output);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return isSudoOrRoot;
        }
    }

    public static class Unix {
        public static boolean isFreeBSD() {
            if (!OS.isUnix()) {
                return false;
            }
            try {
                ShellExecutor shell = new ShellExecutor();
                shell.setExecutable("uname");
                shell.start();
                String output = shell.getOutput();
                return output.startsWith("FreeBSD");
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public static class Windows {
        public static int[] getVersion() {
            int[] version = new int[]{0, 0};
            if (!OS.isWindows()) {
                return version;
            }
            try {
                String output = System.getProperty("os.version");
                String[] split = output.split("\\.", -1);
                if (split.length <= 2) {
                    for (int i = 0; i < split.length; ++i) {
                        version[i] = Integer.parseInt(split[i]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return version;
        }

        public static boolean isWindowsXP() {
            return Windows.getVersion()[0] == 5;
        }

        public static boolean isWindowsVista() {
            int[] version = Windows.getVersion();
            return version[0] == 6 && version[1] == 0;
        }

        public static boolean isWindows7() {
            int[] version = Windows.getVersion();
            return version[0] == 6 && version[1] == 1;
        }

        public static boolean isWindows8() {
            int[] version = Windows.getVersion();
            return version[0] == 6 && version[1] == 2;
        }

        public static boolean isWindows8_1() {
            int[] version = Windows.getVersion();
            return version[0] == 6 && version[1] == 3;
        }

        public static boolean isWindows8_1_plus() {
            int[] version = Windows.getVersion();
            if (version[0] == 6 && version[1] >= 3) {
                return true;
            }
            return version[0] > 6;
        }

        public static boolean isWindows10() {
            return Windows.getVersion()[0] == 10;
        }

        public static boolean isWindows10_plus() {
            return Windows.getVersion()[0] >= 10;
        }
    }
}

