/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.util.OS;
import dorkbox.util.SwingUtil;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public final class _SwingTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = "";

    public _SwingTray(SystemTray systemTray) {
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        SwingMenu swingMenu = new SwingMenu(null, null){

            @Override
            public void setEnabled(final MenuItem menuItem) {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_SwingTray.this.tray == null) {
                            _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                        }
                        boolean enabled = menuItem.getEnabled();
                        if (_SwingTray.this.visible && !enabled) {
                            _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                            _SwingTray.this.visible = false;
                        } else if (!_SwingTray.this.visible && enabled) {
                            try {
                                _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                                _SwingTray.this.visible = true;
                                _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)e);
                            }
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _SwingTray.this.imageFile = menuItem.getImage();
                if (_SwingTray.this.imageFile == null) {
                    return;
                }
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_SwingTray.this.tray == null) {
                            _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                        }
                        Image trayImage = new ImageIcon(_SwingTray.this.imageFile.getAbsolutePath()).getImage();
                        trayImage.flush();
                        if (_SwingTray.this.trayIcon == null) {
                            _SwingTray.this.trayIcon = new TrayIcon(trayImage);
                            JPopupMenu popupMenu = (JPopupMenu)_native;
                            popupMenu.pack();
                            popupMenu.setFocusable(true);
                            if (_SwingTray.this.tooltipText != null && !_SwingTray.this.tooltipText.isEmpty()) {
                                _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                            }
                            _SwingTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mousePressed(MouseEvent e) {
                                    TrayPopup popupMenu = (TrayPopup)_native;
                                    popupMenu.doShow(e.getPoint(), 0);
                                }
                            });
                            try {
                                _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("TrayIcon could not be added.", (Throwable)e);
                            }
                        } else {
                            _SwingTray.this.trayIcon.setImage(trayImage);
                        }
                        _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                        ((TrayPopup)_native).setTitleBarImage(_SwingTray.this.imageFile);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                final String text = menuItem.getTooltip();
                if (_SwingTray.this.tooltipText != null && _SwingTray.this.tooltipText.equals(text) || _SwingTray.this.tooltipText == null && text != null) {
                    return;
                }
                _SwingTray.this.tooltipText = text;
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_SwingTray.this.trayIcon != null) {
                            _SwingTray.this.trayIcon.setToolTip(text);
                        }
                    }
                });
            }

            @Override
            public void remove() {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_SwingTray.this.trayIcon != null) {
                            if (_SwingTray.this.tray != null) {
                                _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                            }
                            _SwingTray.this.trayIcon = null;
                        }
                        _SwingTray.this.tray = null;
                    }
                });
                super.remove();
                if (OS.isLinux() || OS.isUnix()) {
                    GtkEventDispatch.shutdownGui();
                }
            }
        };
        this.bind(swingMenu, null, systemTray);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

