/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.jna.linux.AppIndicator;
import dorkbox.util.jna.linux.GObject;
import dorkbox.util.jna.linux.GtkEventDispatch;
import dorkbox.util.jna.linux.structs.AppIndicatorInstanceStruct;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public final class _AppIndicatorNativeTray
extends Tray {
    private volatile AppIndicatorInstanceStruct appIndicator;
    private boolean isActive = false;
    private AtomicBoolean shuttingDown = new AtomicBoolean();
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile boolean setName = false;

    public _AppIndicatorNativeTray(SystemTray systemTray) {
        GtkMenu gtkMenu = new GtkMenu(){

            @Override
            protected final void onMenuAdded(Pointer menu) {
                _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_menu(menu);
                if (!_AppIndicatorNativeTray.this.setName) {
                    _AppIndicatorNativeTray.this.setName = true;
                    _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_title("SystemTray");
                }
            }

            @Override
            public void setEnabled(final MenuItem menuItem) {
                GtkEventDispatch.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        boolean enabled = menuItem.getEnabled();
                        if (_AppIndicatorNativeTray.this.visible && !enabled) {
                            _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(0);
                            _AppIndicatorNativeTray.this.visible = false;
                        } else if (!_AppIndicatorNativeTray.this.visible && enabled) {
                            _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(1);
                            _AppIndicatorNativeTray.this.visible = true;
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AppIndicatorNativeTray.this.imageFile = menuItem.getImage();
                if (_AppIndicatorNativeTray.this.imageFile == null) {
                    return;
                }
                GtkEventDispatch.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_icon(_AppIndicatorNativeTray.this.imageFile.getAbsolutePath());
                        if (!_AppIndicatorNativeTray.this.isActive) {
                            _AppIndicatorNativeTray.this.isActive = true;
                            _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(1);
                        }
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
            }

            @Override
            public void remove() {
                if (!_AppIndicatorNativeTray.this.shuttingDown.getAndSet(true)) {
                    super.remove();
                    GtkEventDispatch.dispatch(new Runnable(){

                        @Override
                        public void run() {
                            AppIndicatorInstanceStruct savedAppIndicator = _AppIndicatorNativeTray.this.appIndicator;
                            _AppIndicatorNativeTray.this.appIndicator = null;
                            savedAppIndicator.app_indicator_set_status(0);
                            Pointer p = savedAppIndicator.getPointer();
                            GObject.g_object_unref(p);
                            GtkEventDispatch.shutdownGui();
                        }
                    });
                }
            }
        };
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                String id = System.nanoTime() + "DBST";
                File image = ImageResizeUtil.getTransparentImage();
                _AppIndicatorNativeTray.this.appIndicator = AppIndicator.app_indicator_new(id, image.getAbsolutePath(), 0);
            }
        });
        GtkEventDispatch.waitForEventsToComplete();
        this.bind(gtkMenu, null, systemTray);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

