/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.HeavyCheckMark;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.OSUtil;
import dorkbox.util.jna.linux.GCallback;
import dorkbox.util.jna.linux.GObject;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import dorkbox.util.jna.linux.GtkTheme;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItemCheckbox
extends GtkBaseMenuItem
implements CheckboxPeer,
GCallback {
    private static volatile String checkedFile;
    private static final String uncheckedFile;
    private static final boolean useFakeCheckMark;
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;
    private volatile Pointer checkedImage;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private final long handlerId;

    GtkMenuItemCheckbox(GtkMenu parent) {
        super(useFakeCheckMark ? Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic("") : Gtk.Gtk2.gtk_check_menu_item_new_with_mnemonic(""));
        this.parent = parent;
        this.handlerId = GObject.g_signal_connect_object(this._native, "activate", this, null, 0);
        if (useFakeCheckMark) {
            if (checkedFile == null) {
                Color color = GtkTheme.getTextColor();
                if (color == null) {
                    SystemTray.logger.error("Unable to determine the text color in use by your system. Please create an issue and include your full OS configuration and desktop environment, including theme details, such as the theme name, color variant, and custom theme options (if any).");
                    color = Color.BLACK;
                }
                if (checkedFile == null) {
                    Rectangle size = GtkTheme.getPixelTextHeight("X");
                    int imageHeight = SystemTray.get().getMenuImageSize();
                    int height = size.height;
                    checkedFile = SystemTray.get().getMenu() instanceof _AppIndicatorNativeTray ? HeavyCheckMark.get(color, height, height) : HeavyCheckMark.get(color, height, imageHeight);
                }
            }
            this.setCheckedIconForFakeCheckMarks();
        } else {
            GObject.g_signal_handler_block(this._native, this.handlerId);
            Gtk.Gtk2.gtk_check_menu_item_set_active(this._native, false);
            GObject.g_signal_handler_unblock(this._native, this.handlerId);
        }
    }

    @Override
    public int callback(Pointer instance, Pointer data) {
        ActionListener callback = this.callback;
        if (callback != null) {
            GtkEventDispatch.proxyClick(callback);
        }
        return 1;
    }

    @Override
    public boolean hasImage() {
        return true;
    }

    @Override
    public void setSpacerImage(boolean everyoneElseHasImages) {
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_widget_set_sensitive(GtkMenuItemCheckbox.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(Checkbox menuItem) {
        String text;
        int i;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((i = (text = menuItem.getText()).toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : menuItem.getText();
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_menu_item_set_label(GtkMenuItemCheckbox.this._native, textWithMnemonic);
                Gtk.Gtk2.gtk_widget_show_all(GtkMenuItemCheckbox.this._native);
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.setChecked(!GtkMenuItemCheckbox.this.isChecked);
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        boolean checked = menuItem.getChecked();
        if (checked != this.isChecked) {
            this.isChecked = checked;
            GtkEventDispatch.dispatch(new Runnable(){

                @Override
                public void run() {
                    if (useFakeCheckMark) {
                        GtkMenuItemCheckbox.this.setCheckedIconForFakeCheckMarks();
                    } else {
                        GObject.g_signal_handler_block(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.handlerId);
                        Gtk.Gtk2.gtk_check_menu_item_set_active(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.isChecked);
                        GObject.g_signal_handler_unblock(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.handlerId);
                    }
                }
            });
        }
    }

    private void setCheckedIconForFakeCheckMarks() {
        if (this.checkedImage != null) {
            Gtk.Gtk2.gtk_container_remove(this._native, this.checkedImage);
            this.checkedImage = null;
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        }
        this.checkedImage = this.isChecked ? Gtk.Gtk2.gtk_image_new_from_file(checkedFile) : Gtk.Gtk2.gtk_image_new_from_file(uncheckedFile);
        Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.checkedImage);
        Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }

    @Override
    public void setShortcut(Checkbox checkbox) {
        this.mnemonicKey = Character.toLowerCase(checkbox.getShortcut());
        this.setText(checkbox);
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                GtkMenuItemCheckbox.super.remove();
                GtkMenuItemCheckbox.this.callback = null;
                Gtk.Gtk2.gtk_container_remove(((GtkMenuItemCheckbox)GtkMenuItemCheckbox.this).parent._nativeMenu, GtkMenuItemCheckbox.this._native);
                if (GtkMenuItemCheckbox.this.image != null) {
                    Gtk.Gtk2.gtk_container_remove(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.image);
                    GtkMenuItemCheckbox.this.image = null;
                }
                GtkMenuItemCheckbox.this.parent.remove(GtkMenuItemCheckbox.this);
            }
        });
    }

    static {
        uncheckedFile = ImageResizeUtil.getTransparentImage().getAbsolutePath();
        useFakeCheckMark = SystemTray.AUTO_FIX_INCONSISTENCIES && SystemTray.get().getMenu() instanceof _AppIndicatorNativeTray && OSUtil.Linux.isUbuntu();
        if (SystemTray.DEBUG) {
            SystemTray.logger.info("Using Fake CheckMark: " + useFakeCheckMark);
        }
    }
}

