/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItemCheckbox;
import dorkbox.systemTray.ui.gtk.GtkMenuItemSeparator;
import dorkbox.systemTray.ui.gtk.GtkMenuItemStatus;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class GtkMenu
extends GtkBaseMenuItem
implements MenuPeer {
    private final List<GtkBaseMenuItem> menuEntries = new ArrayList<GtkBaseMenuItem>();
    private final GtkMenu parent;
    volatile Pointer _nativeMenu;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private AtomicBoolean obliterateInProgress = new AtomicBoolean(false);

    GtkMenu() {
        super(null);
        this.parent = null;
    }

    private GtkMenu(GtkMenu parent) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
    }

    GtkMenu getParent() {
        return this.parent;
    }

    protected void onMenuAdded(Pointer menu) {
    }

    private void deleteMenu() {
        if (this.obliterateInProgress.get()) {
            return;
        }
        if (this._nativeMenu != null) {
            int menuEntriesSize = this.menuEntries.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = this.menuEntries.get(i);
                menuEntry__.onDeleteMenu(this._nativeMenu);
            }
            Gtk.Gtk2.gtk_widget_destroy(this._nativeMenu);
        }
        if (this.parent != null) {
            this.parent.deleteMenu();
        }
        this._nativeMenu = Gtk.Gtk2.gtk_menu_new();
        if (this.parent != null) {
            Gtk.Gtk2.gtk_menu_item_set_submenu(this._native, this._nativeMenu);
        }
    }

    private void createMenu() {
        GtkBaseMenuItem menuEntry__;
        int i;
        if (this.obliterateInProgress.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.createMenu();
        }
        boolean hasImages = false;
        int menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            menuEntry__ = this.menuEntries.get(i);
            hasImages |= menuEntry__.hasImage();
        }
        menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            GtkMenu subMenu;
            menuEntry__ = this.menuEntries.get(i);
            menuEntry__.onCreateMenu(this._nativeMenu, hasImages);
            if (!(menuEntry__ instanceof GtkMenu) || (subMenu = (GtkMenu)menuEntry__).getParent() == this) continue;
            subMenu.createMenu();
        }
        this.onMenuAdded(this._nativeMenu);
        Gtk.Gtk2.gtk_widget_show_all(this._nativeMenu);
    }

    private void obliterateMenu() {
        if (this._nativeMenu != null && !this.obliterateInProgress.get()) {
            this.obliterateInProgress.set(true);
            ArrayList<GtkBaseMenuItem> menuEntriesCopy = new ArrayList<GtkBaseMenuItem>(this.menuEntries);
            this.menuEntries.clear();
            int menuEntriesSize = menuEntriesCopy.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = menuEntriesCopy.get(i);
                menuEntry__.remove();
            }
            menuEntriesCopy.clear();
            Gtk.Gtk2.gtk_widget_destroy(this._nativeMenu);
            this._nativeMenu = null;
            this.obliterateInProgress.set(false);
        }
    }

    @Override
    public void add(final Menu parentMenu, final Entry entry, final int index) {
        GtkEventDispatch.dispatchAndWait(new Runnable(){

            @Override
            public void run() {
                GtkMenu.this.deleteMenu();
                GtkBaseMenuItem item = null;
                if (entry instanceof Menu) {
                    item = new GtkMenu(GtkMenu.this);
                    GtkMenu.this.menuEntries.add(index, item);
                } else if (entry instanceof Separator) {
                    item = new GtkMenuItemSeparator(GtkMenu.this);
                    GtkMenu.this.menuEntries.add(index, item);
                } else if (entry instanceof Checkbox) {
                    item = new GtkMenuItemCheckbox(GtkMenu.this);
                    GtkMenu.this.menuEntries.add(index, item);
                } else if (entry instanceof Status) {
                    item = new GtkMenuItemStatus(GtkMenu.this);
                    GtkMenu.this.menuEntries.add(index, item);
                } else if (entry instanceof MenuItem) {
                    item = new GtkMenuItem(GtkMenu.this);
                    GtkMenu.this.menuEntries.add(index, item);
                }
                GtkMenu.this.createMenu();
                if (entry instanceof Menu) {
                    ((Menu)entry).bind((MenuPeer)((Object)item), parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Separator) {
                    ((Separator)entry).bind((GtkMenuItemSeparator)item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Checkbox) {
                    ((Checkbox)entry).bind((GtkMenuItemCheckbox)item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Status) {
                    ((Status)entry).bind((GtkMenuItemStatus)item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof MenuItem) {
                    ((MenuItem)entry).bind((GtkMenuItem)item, parentMenu, parentMenu.getSystemTray());
                }
            }
        });
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkMenu.this.image != null) {
                    Gtk.Gtk2.gtk_container_remove(GtkMenu.this._native, GtkMenu.this.image);
                    GtkMenu.this.image = null;
                    Gtk.Gtk2.gtk_widget_show_all(GtkMenu.this._native);
                }
                if (menuItem.getImage() != null) {
                    GtkMenu.this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                    Gtk.Gtk2.gtk_image_menu_item_set_image(GtkMenu.this._native, GtkMenu.this.image);
                    Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(GtkMenu.this._native, true);
                }
                Gtk.Gtk2.gtk_widget_show_all(GtkMenu.this._native);
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_widget_set_sensitive(GtkMenu.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_menu_item_set_label(GtkMenu.this._native, textWithMnemonic);
                Gtk.Gtk2.gtk_widget_show_all(GtkMenu.this._native);
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        this.mnemonicKey = Character.toLowerCase(menuItem.getShortcut());
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(final MenuItem menuItem) {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_widget_set_tooltip_text(GtkMenu.this._native, menuItem.getTooltip());
            }
        });
    }

    public void remove(GtkBaseMenuItem item) {
        this.menuEntries.remove(item);
        this.deleteMenu();
        this.createMenu();
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                GtkMenu parent = GtkMenu.this.getParent();
                if (parent != null) {
                    parent.menuEntries.remove(GtkMenu.this);
                }
                GtkMenu.this.obliterateMenu();
                if (parent != null) {
                    Gtk.Gtk2.gtk_menu_item_set_submenu(GtkMenu.this._native, null);
                    parent.deleteMenu();
                    parent.createMenu();
                }
            }
        });
    }
}

